/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat.state;

import io.fair_acc.chartfx.marker.DefaultMarker;
import io.fair_acc.chartfx.marker.Marker;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;
import us.hebi.gui.lib.azq;
import us.hebi.gui.views.teachrepeat.state.WaypointDataSet;

public class WaypointDataSetRenderer
extends AbstractRendererXY<WaypointDataSetRenderer> {
    private final Marker fixedMarker = DefaultMarker.RECTANGLE;
    private final Marker freeMarker = DefaultMarker.CIRCLE2;

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (!(dataSet instanceof WaypointDataSet)) {
            return;
        }
        WaypointDataSet waypointDataSet = (WaypointDataSet)dataSet;
        int n2 = Math.max(0, waypointDataSet.getIndex(0, this.xMin) - 1);
        if (Math.min(waypointDataSet.getIndex(0, this.xMax) + 2, waypointDataSet.getDataCount()) - n2 <= 0) {
            return;
        }
        graphicsContext.save();
        Paint paint = dataSetNode.getMarkerColor();
        graphicsContext.setStroke(paint);
        graphicsContext.setFill(paint);
        graphicsContext.setLineWidth(dataSetNode.getMarkerLineWidth());
        graphicsContext.setLineDashes(dataSetNode.getMarkerLineDashes());
        for (int i2 = 0; i2 < waypointDataSet.getDataCount(); ++i2) {
            double d2 = this.xAxis.getDisplayPosition(((azq)waypointDataSet).getX(i2));
            double d3 = this.yAxis.getDisplayPosition(((azq)waypointDataSet).getY(i2));
            if (Double.isNaN(d3)) continue;
            (waypointDataSet.isFree(i2) ? this.freeMarker : this.fixedMarker).draw(graphicsContext, d2, d3, dataSetNode.getMarkerSize());
        }
        graphicsContext.restore();
    }

    @Override
    protected WaypointDataSetRenderer getThis() {
        return this;
    }
}

