/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.transform.TransformerException;
import okhttp3.Headers;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.lib.abs;
import us.hebi.gui.lib.abu;
import us.hebi.gui.lib.abv;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.aid;
import us.hebi.gui.lib.aif;
import us.hebi.gui.lib.ain;
import us.hebi.gui.lib.aio;
import us.hebi.gui.lib.air;
import us.hebi.gui.lib.ajl;
import us.hebi.gui.lib.akj;
import us.hebi.gui.lib.akt;
import us.hebi.gui.lib.amw;
import us.hebi.gui.lib.arz;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.atv;
import us.hebi.gui.lib.auk;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.axb;
import us.hebi.gui.lib.axk;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.bcq;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdk;
import us.hebi.gui.lib.bdt;
import us.hebi.gui.lib.bfq;
import us.hebi.gui.lib.bfs;
import us.hebi.gui.lib.u;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.components.PidController;

public class GainsController {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button loadFileBtn;
    @FXML
    private Button loadDefaultsBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private Button sendDirectBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private HEnumInputField<aif> controlStrategy;
    @FXML
    private HEnumInputField<ajl> mStopStrategy;
    @FXML
    private HEnumInputField<akj> posLimitStrategy;
    @FXML
    private Hyperlink docsLink;
    @FXML
    private Text docsText;
    @FXML
    private ToggleButton advancedToggle;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private HDoubleInputField minPosLimit;
    @FXML
    private HDoubleInputField maxPosLimit;
    @FXML
    private HDoubleInputField minVelLimit;
    @FXML
    private HDoubleInputField maxVelLimit;
    @FXML
    private HDoubleInputField minEffortLimit;
    @FXML
    private HDoubleInputField maxEffortLimit;
    @FXML
    private Parent positionPid;
    @FXML
    private PidController positionPidController;
    @FXML
    private Parent velocityPid;
    @FXML
    private PidController velocityPidController;
    @FXML
    private Parent effortPid;
    @FXML
    private PidController effortPidController;
    final ValidationSupport basicValidation = bcq.a();
    final ValidationSupport advancedValidation = bcq.a();
    @Inject
    aup properties;
    @Inject
    axp module;
    @Inject
    ayn fileChooser;
    @Inject
    axk moduleSelector;
    @Inject
    axb commandService;
    akt reusableCommand;
    @Inject
    bdt webViewer;
    private BooleanProperty advancedView;
    private final List<Runnable> clearers = new ArrayList<Runnable>();

    @FXML
    public void openGainsDocumentationInBrowser(ActionEvent actionEvent) {
        this.webViewer.showDocument("https://docs.hebi.us/core_concepts.html#motor_control");
    }

    @FXML
    private void sendGains(ActionEvent actionEvent) {
        akj akj2;
        ajl ajl2;
        akt akt2 = this.reusableCommand;
        ((amw)akt2).clear();
        ain ain2 = akt2.getGains();
        if (this.persistToggle.isSelected()) {
            akt2.setPersistAllFlag();
        }
        aid aid2 = akt2.getSafetyLimits();
        GainsController.addSafetyLimit(this.minPosLimit, aid2::a);
        GainsController.addSafetyLimit(this.maxPosLimit, aid2::b);
        GainsController.addSafetyLimit(this.minVelLimit, aid2::c);
        GainsController.addSafetyLimit(this.maxVelLimit, aid2::d);
        GainsController.addSafetyLimit(this.minEffortLimit, aid2::e);
        GainsController.addSafetyLimit(this.maxEffortLimit, aid2::f);
        aif aif2 = this.controlStrategy.getValue();
        if (aif2 != null) {
            ain2.a(aif2);
        }
        if ((ajl2 = this.mStopStrategy.getValue()) != null) {
            ain2.a(ajl2);
        }
        if ((akj2 = this.posLimitStrategy.getValue()) != null) {
            aid2.a(akj2);
            aid2.b(akj2);
        }
        this.positionPidController.addGainsToMessage(ain2);
        this.velocityPidController.addGainsToMessage(ain2);
        this.effortPidController.addGainsToMessage(ain2);
        this.moduleSelector.getSelectedAddresses().forEach(ahg2 -> this.commandService.a((ahg)ahg2, akt2));
    }

    private static void addSafetyLimit(HDoubleInputField hDoubleInputField, DoubleConsumer doubleConsumer) {
        if (!hDoubleInputField.getTextInput().isDisable() && hDoubleInputField.isInputValid()) {
            doubleConsumer.accept(hDoubleInputField.getInputValue());
        }
    }

    @FXML
    void clearAllFields(ActionEvent actionEvent) {
        this.positionPidController.clearAllTextFields();
        this.velocityPidController.clearAllTextFields();
        this.effortPidController.clearAllTextFields();
        this.controlStrategy.clear();
        this.mStopStrategy.clear();
        this.posLimitStrategy.clear();
        Iterator<Runnable> iterator = this.clearers.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> Optional<T[]> readGainsFile(Function<abu, T[]> function) {
        Window window = this.getActiveWindow();
        ayn ayn2 = this.fileChooser;
        ayn2.a(ayn2.c, "lastGainsChoiceDirectory");
        ayn ayn3 = ayn2;
        File file = ayn3.b(ayn3.c.showOpenDialog(window), "lastGainsChoiceDirectory");
        if (file == null) {
            return Optional.empty();
        }
        T[] TArray = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            abu abu2 = abu.a(fileInputStream);
            TArray = function.apply(abu2);
            if (TArray.length != 0) return Optional.ofNullable(TArray);
            awg.a("Selected file did not contain gains", this.getActiveWindow());
            Optional<T[]> optional = Optional.empty();
            return optional;
        }
        catch (Exception exception) {
            awg.a(exception, this.getActiveWindow());
        }
        return Optional.ofNullable(TArray);
    }

    @FXML
    void loadDefaultGains(ActionEvent actionEvent) {
        if (this.module.isEmpty()) {
            return;
        }
        bfq bfq2 = bfq.a();
        aif aif2 = Optional.ofNullable(this.controlStrategy.getValue()).orElse(this.module.getGains().a());
        Headers headers = bdk.a(this.module.getInfo());
        CompletableFuture.supplyAsync(() -> {
            try {
                Headers headers2 = headers;
                String string = this.toStrategyUrlName(aif2);
                String string2 = this.module.getModule().c().toString();
                String string3 = bfs.a(bfq.b("gains", string, string2), headers2);
                return abu.a(new ByteArrayInputStream(string3.getBytes(u.a))).a();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).whenCompleteAsync((aioArray, throwable) -> {
            if (throwable != null) {
                awg.a("Could not load default gains because the \nserver could not be reached, or because there are \nno default gains for the selected module and \nstrategy '" + String.valueOf((Object)aif2) + "'.", this.getActiveWindow());
                return;
            }
            if (((aio[])aioArray).length != 1) {
                awg.a("Could not load gains due to invalid source format.", this.getActiveWindow());
                return;
            }
            this.setGainFields(aioArray[0]);
        }, bdc.b);
    }

    private String toStrategyUrlName(aif aif2) {
        switch (aif2) {
            case d: {
                return "strategy2";
            }
            case e: {
                return "strategy3";
            }
            case f: {
                return "strategy4";
            }
            case g: {
                return "strategy5";
            }
        }
        return aif2.toString();
    }

    @FXML
    void loadFromFileAndSend(ActionEvent actionEvent) {
        ObservableList<aum> observableList;
        int n2;
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        Optional<T[]> optional = this.readGainsFile(abu::a);
        if (!optional.isPresent()) {
            return;
        }
        akt[] aktArray = (akt[])optional.get();
        if (aktArray.length != (n2 = (observableList = this.moduleSelector.getSelectedModules()).size())) {
            awg.a(String.format("Selected file contains %d modules, but %d modules are selected", aktArray.length, n2), this.getActiveWindow());
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            aum aum2 = (aum)observableList.get(i2);
            this.commandService.a(aum2.a(), aktArray[i2]);
        }
    }

    @FXML
    void loadFromFile(ActionEvent actionEvent) {
        aio aio2;
        Optional<T[]> optional = this.readGainsFile(abu::a);
        if (!optional.isPresent()) {
            return;
        }
        aio[] aioArray = (aio[])optional.get();
        if (aioArray.length > 1) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < aioArray.length; ++i2) {
                arrayList.add(i2 + 1);
            }
            ChoiceDialog choiceDialog = new ChoiceDialog((Object)1, arrayList);
            choiceDialog.setTitle("Group Gain Selector");
            choiceDialog.setHeaderText("File contains gains for more than one device");
            choiceDialog.setContentText("Choose device index:");
            choiceDialog.initOwner(this.getActiveWindow());
            Optional optional2 = choiceDialog.showAndWait();
            if (!optional2.isPresent()) {
                return;
            }
            aio2 = aioArray[(Integer)optional2.get() - 1];
        } else {
            aio2 = aioArray[0];
        }
        this.setGainFields(aio2);
    }

    private void setGainFields(aio aio2) {
        aif aif2 = aio2.a();
        if (aif2 == aif.a) {
            aif2 = null;
        }
        this.controlStrategy.setValue(aif2);
        this.positionPidController.setTextFields(aio2);
        this.velocityPidController.setTextFields(aio2);
        this.effortPidController.setTextFields(aio2);
    }

    @FXML
    void saveGainsToFile(ActionEvent actionEvent) {
        if (this.moduleSelector.getSelectedModules().size() == 0) {
            return;
        }
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        File file = this.fileChooser.f(this.getActiveWindow());
        if (file == null) {
            return;
        }
        abv abv2 = abv.a((air[])this.moduleSelector.getSelectedModules().stream().map(aum::getInfo).toArray(air[]::new));
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            abv2.a(fileOutputStream);
            return;
        }
        catch (IOException | TransformerException exception) {
            awg.a(exception, this.getActiveWindow());
            return;
        }
    }

    private boolean tryShowGroupGainsNotice() {
        if (!this.moduleSelector.selectionMultiple().get()) {
            return true;
        }
        return awg.a("Gains from multiple devices are stored in a single file.\nWhen loading or saving gains from multiple devices,\nthe order within the file will match the order of selected\ndevices as shown on the left. The device order can be\nchanged using the ALT + UpDown shortcuts.", this.getActiveWindow());
    }

    private Window getActiveWindow() {
        return this.controlStrategy.getScene().getWindow();
    }

    @FXML
    void initialize() {
        this.advancedToggle.setSelected(this.properties.c.get());
        this.properties.c.bind((ObservableValue)this.advancedToggle.selectedProperty());
        this.persistToggle.setSelected(this.properties.m.get());
        this.properties.m.bind((ObservableValue)this.persistToggle.selectedProperty());
        this.positionPidController.initialize(abs.a, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.velocityPidController.initialize(abs.b, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.effortPidController.initialize(abs.c, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        arz.b((Node)this.advancedToggle, bcq.a(this.advancedValidation));
        arz.a((Node)this.advancedToggle, bcq.b(this.advancedValidation));
        arz.a((Node)this.sendBtn, bcq.b(this.basicValidation), bcq.b(this.advancedValidation));
        Object object = this.module.getGains();
        this.controlStrategy.initValues((ReadOnlyObjectProperty<aif>)((atv)object).v, aif.a);
        this.basicValidation.registerValidator((Control)this.controlStrategy.getChoiceBox(), false, bcq.a(this.controlStrategy));
        Object object2 = this.module.getGains();
        this.mStopStrategy.initValues((ReadOnlyObjectProperty<ajl>)((atv)object2).w, ajl.a);
        this.basicValidation.registerValidator((Control)this.mStopStrategy.getChoiceBox(), false, bcq.a(this.mStopStrategy));
        object2 = this.module.getSafetyLimits();
        this.posLimitStrategy.initValues((ReadOnlyObjectProperty<akj>)((auk)object2).G, akj.a);
        this.basicValidation.registerValidator((Control)this.posLimitStrategy.getChoiceBox(), false, bcq.a(this.posLimitStrategy));
        GainsController gainsController = this;
        auk auk2 = this.module.getSafetyLimits();
        object = auk2;
        object = this.module.getFeedback();
        gainsController.initializeSafetyLimit(gainsController.minPosLimit, (ReadOnlyDoubleProperty)auk2.cH, (ReadOnlyDoubleProperty)((atl)object).E);
        GainsController gainsController2 = this;
        auk auk3 = this.module.getSafetyLimits();
        object = auk3;
        object = this.module.getFeedback();
        gainsController2.initializeSafetyLimit(gainsController2.maxPosLimit, (ReadOnlyDoubleProperty)auk3.cE, (ReadOnlyDoubleProperty)((atl)object).E);
        GainsController gainsController3 = this;
        auk auk4 = this.module.getSafetyLimits();
        object = auk4;
        object = this.module.getFeedback();
        gainsController3.initializeSafetyLimit(gainsController3.minVelLimit, (ReadOnlyDoubleProperty)auk4.cI, (ReadOnlyDoubleProperty)((atl)object).P);
        GainsController gainsController4 = this;
        auk auk5 = this.module.getSafetyLimits();
        object = auk5;
        object = this.module.getFeedback();
        gainsController4.initializeSafetyLimit(gainsController4.maxVelLimit, (ReadOnlyDoubleProperty)auk5.cF, (ReadOnlyDoubleProperty)((atl)object).P);
        GainsController gainsController5 = this;
        auk auk6 = this.module.getSafetyLimits();
        object = auk6;
        object = this.module.getFeedback();
        gainsController5.initializeSafetyLimit(gainsController5.minEffortLimit, (ReadOnlyDoubleProperty)auk6.cG, (ReadOnlyDoubleProperty)((atl)object).h);
        GainsController gainsController6 = this;
        auk auk7 = this.module.getSafetyLimits();
        object = auk7;
        object = this.module.getFeedback();
        gainsController6.initializeSafetyLimit(gainsController6.maxEffortLimit, (ReadOnlyDoubleProperty)auk7.cD, (ReadOnlyDoubleProperty)((atl)object).h);
        this.sendBtn.setOnAction(this::sendGains);
        this.sendBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty().or((ObservableBooleanValue)this.basicValidation.invalidProperty()).or((ObservableBooleanValue)this.advancedValidation.invalidProperty()));
        this.saveFileBtn.setOnAction(this::saveGainsToFile);
        this.saveFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadDefaultsBtn.setOnAction(this::loadDefaultGains);
        this.loadDefaultsBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadFileBtn.setOnAction(this::loadFromFile);
        this.loadFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.sendDirectBtn.setOnAction(this::loadFromFileAndSend);
        this.sendDirectBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.clearBtn.setOnAction(this::clearAllFields);
    }

    private void initializeSafetyLimit(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        hDoubleInputField.setShowTarget(true);
        hDoubleInputField.setTargetSupplier(() -> ((ReadOnlyDoubleProperty)readOnlyDoubleProperty2).get());
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = bcq.a(customTextField, ParseUtils.NON_NAN_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.basicValidation.registerValidator((Control)customTextField, false, validator);
        this.clearers.add(() -> ((CustomTextField)customTextField).clear());
    }

    @PostConstruct
    public void postConstruct() {
        GainsController gainsController = this;
        this.reusableCommand = gainsController.commandService.b();
        this.advancedView = this.properties.c;
    }
}

