/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.util.OptionalDouble;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javax.inject.Inject;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.TextFieldUtil;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.ac;
import us.hebi.gui.lib.akt;
import us.hebi.gui.lib.amw;
import us.hebi.gui.lib.apo;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.aua;
import us.hebi.gui.lib.auj;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.axb;
import us.hebi.gui.lib.axk;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.bcq;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bxv;
import us.hebi.gui.lib.dr;
import us.hebi.gui.views.scope.components.ParseUtils;

public class DeviceParams {
    @FXML
    private HBox positionField;
    @FXML
    private HBox positionOffsetField;
    @FXML
    private HBox effortField;
    @FXML
    private HBox deflectionOffsetField;
    @FXML
    private Button applyBtn;
    @FXML
    private Button applySelectedBtn;
    @FXML
    private Button calibratePositionBtn;
    @Inject
    axp module;
    @Inject
    axk moduleSelector;
    @Inject
    axb commandService;
    final akt cmd = new akt();
    final ValidationSupport validation = bcq.a();

    @FXML
    void initialize() {
        atl atl2 = this.module.getFeedback();
        Object object = this.module.getInfo();
        auj auj2 = ((aua)object).a;
        DeviceParams deviceParams = this;
        object = auj2;
        atl atl3 = atl2;
        deviceParams.initializeField(deviceParams.positionField, (ReadOnlyBooleanProperty)((auj)object).E, (ReadOnlyDoubleProperty)atl3.E, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        DeviceParams deviceParams2 = this;
        object = auj2;
        atl3 = atl2;
        deviceParams2.initializeField(deviceParams2.positionOffsetField, (ReadOnlyBooleanProperty)((auj)object).C, (ReadOnlyDoubleProperty)atl3.E, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        DeviceParams deviceParams3 = this;
        object = auj2;
        atl3 = atl2;
        deviceParams3.initializeField(deviceParams3.effortField, (ReadOnlyBooleanProperty)((auj)object).D, (ReadOnlyDoubleProperty)atl3.h, ParseUtils.ONLY_ZERO_VALIDATOR);
        DeviceParams deviceParams4 = this;
        object = auj2;
        atl3 = atl2;
        deviceParams4.initializeField(deviceParams4.deflectionOffsetField, (ReadOnlyBooleanProperty)((auj)object).B, (ReadOnlyDoubleProperty)atl3.f, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.applyBtn.setOnAction(actionEvent -> this.sendMessage(false));
        this.applySelectedBtn.setOnAction(actionEvent -> this.sendMessage(true));
        this.applyBtn.disableProperty().bind((ObservableValue)this.module.getEmptyProperty().or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.applySelectedBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionMultiple().not().or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.deflectionOffsetField.setVisible(false);
        this.deflectionOffsetField.setManaged(false);
        if (!apo.i("hebi.scope.enableCalibrateButton")) {
            this.calibratePositionBtn.setVisible(false);
            this.calibratePositionBtn.setManaged(false);
        }
        this.calibratePositionBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionSingle().not());
        this.calibratePositionBtn.setOnAction(this::sendCalibratePosition);
    }

    private void sendCalibratePosition(ActionEvent actionEvent) {
        if (!awg.a("This will calibrate the position encoder. This action is irreversible, and \nchanges internal device state that will change the behavior of commands sent \nto the module. Make sure that the actuator is sitting on a flat surface and \nthat nothing is attached to the actuator output.", bdc.a(actionEvent))) {
            return;
        }
        ((amw)this.cmd).clear();
        ((amw)this.cmd).getRootMessage().a().e().a(true);
        this.commandService.a(this.moduleSelector.getSingleSelection().map(aum::a), this.cmd);
    }

    private void sendMessage(boolean bl2) {
        if (!awg.a("Are you sure you want to change the reference points? This action is irreversible, \nand changes internal device state that will change the behavior of commands sent \nto the module. Note that this will cause code commanding this module to perform \ndifferently.", this.applyBtn.getScene().getWindow())) {
            return;
        }
        ((amw)this.cmd).clear();
        bxv bxv2 = ((amw)this.cmd).getRootMessage().a().e();
        DeviceParams deviceParams = this;
        deviceParams.tryParseValue(deviceParams.positionField).ifPresent(d2 -> bxv2.c(true).a((float)d2));
        DeviceParams deviceParams2 = this;
        deviceParams2.tryParseValue(deviceParams2.positionOffsetField).ifPresent(d2 -> bxv2.f(true).c((float)d2));
        DeviceParams deviceParams3 = this;
        deviceParams3.tryParseValue(deviceParams3.effortField).ifPresent(d2 -> bxv2.e(true).b((float)d2));
        DeviceParams deviceParams4 = this;
        deviceParams4.tryParseValue(deviceParams4.deflectionOffsetField).ifPresent(d2 -> bxv2.g(true).d((float)d2));
        if (bl2) {
            this.commandService.a(this.moduleSelector.getSelectedAddresses(), this.cmd);
            return;
        }
        this.commandService.a(this.module.getModule().a(), this.cmd);
    }

    private void initializeField(HBox hBox, ReadOnlyBooleanProperty readOnlyBooleanProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty, Validator<String> validator) {
        CustomTextField customTextField = (CustomTextField)((Object)hBox.getChildren().get(hBox.getChildren().size() - 2));
        Button button = (Button)hBox.getChildren().get(1);
        Text text = (Text)hBox.getChildren().get(hBox.getChildren().size() - 1);
        TextFieldUtil.setupClearButtonField(customTextField);
        this.validation.registerValidator((Control)customTextField, false, validator);
        if (validator == ParseUtils.ONLY_ZERO_VALIDATOR) {
            button.setOnAction(actionEvent -> customTextField.setText("0"));
        } else {
            button.setOnAction(actionEvent -> customTextField.setText(TextUtil.format4digitsWithoutZeros(readOnlyDoubleProperty.getValue())));
        }
        text.textProperty().bind((ObservableValue)ParseUtils.asFormattedString(readOnlyDoubleProperty));
        hBox.disableProperty().bind((ObservableValue)readOnlyBooleanProperty.not().or((ObservableBooleanValue)ParseUtils.isNaN((ObservableDoubleValue)readOnlyDoubleProperty)));
        text.visibleProperty().bind((ObservableValue)hBox.disabledProperty().not());
    }

    private OptionalDouble tryParseValue(HBox hBox) {
        String string = ((CustomTextField)((Object)hBox.getChildren().get(hBox.getChildren().size() - 2))).getText();
        if (ac.a(string)) {
            return OptionalDouble.empty();
        }
        Double d2 = dr.a(string);
        if (d2 == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(d2);
    }
}

