/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components;

import java.io.File;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Mesh;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.ase;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.asz;
import us.hebi.gui.lib.atc;
import us.hebi.gui.lib.avb;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.avo;
import us.hebi.gui.lib.avq;
import us.hebi.gui.lib.avt;
import us.hebi.gui.lib.avw;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.bcn;
import us.hebi.gui.lib.bco;
import us.hebi.gui.lib.bcq;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bfy;
import us.hebi.gui.lib.bml;
import us.hebi.gui.lib.bmm;
import us.hebi.gui.lib.boj;
import us.hebi.gui.lib.brk;
import us.hebi.gui.lib.cec;
import us.hebi.gui.lib.je;
import us.hebi.gui.lib.lh;
import us.hebi.gui.lib.zx;
import us.hebi.gui.views.ResourceLoader;
import us.hebi.gui.views.maps.EncoderState;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsAppState$View;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.maps.ScanningState;
import us.hebi.gui.views.scope.components.ParseUtils;

public class ScanningController
extends bcn {
    @FXML
    private ToggleButton pauseToggle;
    @FXML
    private Pane pauseArea;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane pane3d;
    @FXML
    private TextField resolutionField;
    @FXML
    private TextField distanceField;
    @FXML
    private Button startBtn;
    @FXML
    private Button cancelBtn;
    @FXML
    private Button restartBtn;
    @FXML
    private Button repeatBtn;
    @FXML
    private Button completeBtn;
    @FXML
    private Button backBtn;
    avq coverageImg;
    ase coverageGrid = new ase();
    asz mappedSurface = null;
    @Inject
    asf maps;
    @Inject
    MapsAppState state;
    @Inject
    EncoderState encoderState;
    @Inject
    ScanningState scanState;
    @Inject
    awh notifications;
    final zx logWriter = zx.a();

    @Override
    public void initializeFx() {
        this.resolutionField.textProperty().bindBidirectional((Property)this.state.getString("scanResolution", "10"));
        this.distanceField.textProperty().bindBidirectional((Property)this.state.getString("scanMaxDistance", "30"));
        this.state.addUnitFields(this.resolutionField, this.distanceField);
        bdc.b(() -> this.pauseArea.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.pauseToggle.selectedProperty().get()), new Observable[]{this.pauseToggle.selectedProperty()});
        this.pauseToggle.selectedProperty().bindBidirectional((Property)this.scanState.pausedProperty());
        SimpleObjectProperty simpleObjectProperty = new SimpleObjectProperty();
        avk avk2 = new avk();
        avw avw2 = MapsCss.createEndEffectorAxes3d();
        avw avw3 = new avw(new Node[]{avw2, avk2.e});
        avw avw4 = new avw(new Node[]{avw3, avt.a.a()});
        new avy(new Node[]{avw4}).a().a(this.pane3d);
        ImageView imageView = MapsCss.createView2d(this.pane2d);
        this.maps.b(arg_0 -> this.lambda$initializeFx$1((Property)simpleObjectProperty, avk2, avw3, imageView, arg_0));
        this.maps.d(asg2 -> {
            double d2;
            asg2.cx = d2 = this.coverageGrid.cx;
            this.scanState.setInContact(asg2.isInContact());
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                if (this.state.getShowLiveMap()) {
                    this.mappedSurface.a((asg)asg2, this.state.getProbeWidth());
                }
                if (this.scanState.isActive().booleanValue() && this.scanState.isInContact()) {
                    boolean bl2;
                    asg asg3 = asg2;
                    ase ase2 = this.coverageGrid;
                    if (ase2.aQ && (avb.a(asg3.o, ase2.x) || avb.a(asg3.p, ase2.y))) {
                        ase2.x = asg3.o - (float)ase2.cs;
                        ase2.a.a(ase2.x);
                        ase2.y = asg3.p - (float)ase2.cu;
                        ase2.b.a(ase2.y);
                        ase2.c.a(asg3.A);
                        je je2 = ase2.a;
                        int n2 = je2.S - 1;
                        int n3 = ase2.r(n2);
                        int n4 = ase2.s(n2);
                        if (ase2.a.a(n3, n4) || (double)asg3.A > ase2.cx) {
                            bl2 = false;
                        } else {
                            ase2.a.f(n3, n4);
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (bl2 && this.state.getShowLiveMap()) {
                        this.redrawCoverage();
                    }
                }
            }
        });
        this.maps.c(bfy2 -> {
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                avw2.b((bfy)bfy2);
            }
        });
        ValidationSupport validationSupport = bcq.a();
        bcq.a(validationSupport, this.resolutionField);
        bcq.a(validationSupport, this.distanceField);
        bdc.b(this::updateGrid, new Observable[]{this.resolutionField.textProperty(), this.distanceField.textProperty()});
        this.backBtn.setOnAction(this.state::previousView);
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(false);
        this.scanState.pausedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$initializeFx$4((BooleanProperty)simpleBooleanProperty, arg_0, arg_1, arg_2));
        this.encoderState.encoderStartMessageProperty().addListener((observableValue, bml2, bml3) -> this.scanState.reset());
        this.startBtn.setOnAction(bdc.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.mappedSurface == null) {
                this.notifications.i("Scan cannot be started without a map.");
                return;
            }
            Optional.ofNullable(this.encoderState.getEncoderStartMessage()).ifPresent(bml2 -> {
                bml bml3 = bml2;
                asf asf2 = this.maps;
                asf2.b.c().a().a(bml3);
                asf asf3 = asf2;
                asf3.a(asf3.b, null);
            });
            this.startLogging();
            this.scanState.startScan();
        })));
        this.cancelBtn.setOnAction(bdc.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Cancelling this scan will irrecoverably delete data. Do you want to delete this scan?")) {
                this.reset();
                this.cancelLogging();
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.restartBtn.setOnAction(bdc.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Restarting will discard the current scan and begin a new scan on this same surface. Do you want to restart")) {
                this.reset();
                this.cancelLogging();
                this.maps.a(bmm.b);
            }
        })));
        this.repeatBtn.setOnAction(bdc.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Repeating will complete the current scan and begin a new scan on this same surface. Do you want to repeat?")) {
                this.reset();
                this.stopLogging().ifPresent(file -> awg.a(file, bdc.a(actionEvent)));
                this.maps.a(bmm.b);
            }
        })));
        this.completeBtn.setOnAction(bdc.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.j("Completing a scan will finish this scan and let you set up a new surface. Do you want to complete this scan?")) {
                this.reset();
                this.maps.a(bmm.d);
                this.stopLogging().ifPresent(file -> awg.a(file, bdc.a(actionEvent)));
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.updateGrid();
    }

    private void reset() {
        this.scanState.reset();
        this.coverageGrid.aA();
        this.redrawCoverage();
    }

    private void updateGrid() {
        Double d2 = ParseUtils.tryParseFiniteDouble(this.resolutionField);
        Double d3 = ParseUtils.tryParseFiniteDouble(this.distanceField);
        if (this.mappedSurface != null && d2 != null && d2 > 0.0) {
            this.mappedSurface.l(((aqy)aqy.a).e(d2));
        }
        if (d2 != null && d3 != null && d2 > 0.0 && d3 > 0.0) {
            boolean bl2;
            boolean bl3;
            double d4 = ((aqy)aqy.a).e(d2);
            ase ase2 = this.coverageGrid;
            if (ase2.cw != d4) {
                ase2.cw = d4;
                ase2.az();
                bl3 = true;
            } else {
                bl3 = false;
            }
            boolean bl4 = false | bl3;
            d4 = ((aqy)aqy.a).e(d3);
            ase2 = this.coverageGrid;
            if (ase2.cx != d4) {
                ase2.cx = d4;
                ase2.az();
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (bl4 | bl2) {
                this.redrawCoverage();
            }
        }
    }

    private void redrawCoverage() {
        lh lh2 = this.coverageGrid.a;
        if (lh2.h() == 0) {
            return;
        }
        if (this.coverageImg == null || this.coverageImg.cD != lh2.ao || this.coverageImg.cE != lh2.an) {
            this.coverageImg = new avq((double)lh2.ao, (double)lh2.an);
        }
        int n2 = avq.a(Color.WHITE);
        int n3 = avq.a(ResourceLoader.SCOPE_PRIMARY_COLOR_LIGHTER);
        for (int i2 = 0; i2 < lh2.ao; ++i2) {
            for (int i3 = 0; i3 < lh2.an; ++i3) {
                int n4 = lh2.a(i3, i2) ? n3 : n2;
                this.coverageImg.e(i2, i3, n4);
            }
        }
        ase ase2 = this.coverageGrid;
        ase ase3 = ase2;
        ase3 = this.coverageGrid;
        this.mappedSurface.a((Image)this.coverageImg.a().a, this.coverageGrid.cs, this.coverageGrid.cu, (double)ase2.I() * ase3.cw, (double)ase3.H() * ase3.cw);
    }

    private void startLogging() {
        try {
            UUID uUID = UUID.randomUUID();
            ScanningController scanningController = this;
            brk brk2 = scanningController.logWriter.a();
            brk2.a("MAPS Feedback Log").a().a(bco.b.ai).b(bco.b.ah);
            this.logWriter.a(new File(this.state.getLogDirectory(), String.valueOf(uUID) + ".mapslog"), brk2);
            this.maps.a(this.logWriter);
            asf asf2 = this.maps;
            boj boj2 = boj.a();
            boj2.c().a().d().a(true);
            asf2.a(boj2, null);
            return;
        }
        catch (Exception exception) {
            this.notifications.f(exception);
            return;
        }
    }

    private Optional<File> stopLogging() {
        try {
            this.maps.a((zx)null);
            return Optional.ofNullable(this.logWriter.b());
        }
        catch (Exception exception) {
            this.notifications.f(exception);
            return Optional.empty();
        }
    }

    private void cancelLogging() {
        this.stopLogging().map(File::delete).ifPresent(bl2 -> cec.c(bl2, "Failed to delete log file"));
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }

    @Generated
    public EncoderState getEncoderState() {
        return this.encoderState;
    }

    @Generated
    public ScanningState getScanState() {
        return this.scanState;
    }

    private /* synthetic */ void lambda$initializeFx$4(BooleanProperty booleanProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (!booleanProperty.get()) {
            this.maps.a(bl3 != false ? null : this.logWriter);
            this.maps.a(bl3 != false ? bmm.e : bmm.f);
        }
    }

    private /* synthetic */ void lambda$initializeFx$1(Property property, avk avk2, avw avw2, ImageView imageView, atc atc2) {
        atc atc3 = atc2;
        ase ase2 = this.coverageGrid;
        this.coverageGrid.cs = atc3.cS;
        ase2.cu = atc3.cT;
        ase2.ct = atc3.cU;
        ase2.cv = atc3.cV;
        ase ase3 = ase2;
        ase3.y = Float.NaN;
        ase3.x = Float.NaN;
        ase2.aQ = true;
        ase2.aA();
        ase2.az();
        property.setValue((Object)atc2);
        avk2.a((Mesh)atc2.a());
        bdc.a((Node)avw2, avo.a((Mesh)atc2.a()));
        this.mappedSurface = asz.a(atc2, 1000.0, 1000.0);
        avk2.e.diffuseMapProperty().bind(this.mappedSurface.a);
        avk2.f.diffuseMapProperty().bind(this.mappedSurface.b);
        imageView.imageProperty().bind(this.mappedSurface.a);
        this.updateGrid();
        this.scanState.reset();
        this.stopLogging();
    }
}

