/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Circle;
import javax.inject.Inject;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.awb;
import us.hebi.gui.lib.bcn;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsAppState$View;
import us.hebi.gui.views.maps.MapsCss;

public class MapsPresenter
extends bcn {
    @FXML
    private Circle connectionLed;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private Pane clickDisableOverlay;
    @FXML
    private TabPane tabPane;
    @FXML
    private Pane progressPane;
    @FXML
    private Tab configurationTab;
    @FXML
    private Tab encoderTab;
    @FXML
    private Tab registrationTab;
    @FXML
    private Tab scanningTab;
    @FXML
    private Tab validationTab;
    @Inject
    asf maps;
    @Inject
    MapsAppState state;
    @Inject
    awb dialogService;

    @Override
    public void initializeFx() {
        AnchorPane anchorPane;
        this.tabPane.disableProperty().bind((ObservableValue)this.maps.e);
        this.progressPane.visibleProperty().bind((ObservableValue)this.maps.e);
        this.progressPane.managedProperty().bind((ObservableValue)this.maps.e);
        this.clickDisableOverlay.visibleProperty().bind((ObservableValue)this.state.enableNavigationProperty().not());
        this.clickDisableOverlay.managedProperty().bind((ObservableValue)this.clickDisableOverlay.visibleProperty());
        bdc.b(() -> this.connectionLed.pseudoClassStateChanged(MapsCss.STALE, !this.maps.f.get()), new Observable[]{this.maps.f});
        this.state.activeViewProperty().addListener((observableValue, mapsAppState$View, mapsAppState$View2) -> {
            switch (mapsAppState$View2) {
                case Configuration: {
                    this.tabPane.getSelectionModel().select((Object)this.configurationTab);
                    break;
                }
                case Registration: {
                    this.tabPane.getSelectionModel().select((Object)this.registrationTab);
                    break;
                }
                case Validation: {
                    this.tabPane.getSelectionModel().select((Object)this.validationTab);
                    break;
                }
                case Encoder: {
                    this.tabPane.getSelectionModel().select((Object)this.encoderTab);
                    break;
                }
                case Scanning: {
                    this.tabPane.getSelectionModel().select((Object)this.scanningTab);
                }
            }
            (this.clickDisableOverlay.isVisible() ? this.clickDisableOverlay : this.tabPane).requestFocus();
        });
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((observableValue, tab, tab2) -> {
            if (tab2 == this.configurationTab) {
                this.state.setActiveView(MapsAppState$View.Configuration);
                return;
            }
            if (tab2 == this.registrationTab) {
                this.state.setActiveView(MapsAppState$View.Registration);
                return;
            }
            if (tab2 == this.validationTab) {
                this.state.setActiveView(MapsAppState$View.Validation);
                return;
            }
            if (tab2 == this.encoderTab) {
                this.state.setActiveView(MapsAppState$View.Encoder);
                return;
            }
            if (tab2 == this.scanningTab) {
                this.state.setActiveView(MapsAppState$View.Scanning);
            }
        });
        this.state.setOnViewFinished(mapsAppState$View -> {
            switch (mapsAppState$View) {
                case Configuration: {
                    this.state.setActiveView(MapsAppState$View.Registration);
                    return;
                }
                case Registration: {
                    this.state.setActiveView(MapsAppState$View.Validation);
                    return;
                }
                case Validation: {
                    this.state.setActiveView(MapsAppState$View.Encoder);
                    return;
                }
                case Encoder: {
                    this.state.setActiveView(MapsAppState$View.Scanning);
                    return;
                }
                case Scanning: {
                    this.state.setActiveView(MapsAppState$View.Scanning);
                }
            }
        });
        this.state.setOnViewCancel(mapsAppState$View -> {
            switch (mapsAppState$View) {
                case Configuration: {
                    this.state.setActiveView(MapsAppState$View.Configuration);
                    return;
                }
                case Registration: {
                    this.state.setActiveView(MapsAppState$View.Configuration);
                    return;
                }
                case Validation: {
                    this.state.setActiveView(MapsAppState$View.Registration);
                    return;
                }
                case Encoder: {
                    this.state.setActiveView(MapsAppState$View.Validation);
                    return;
                }
                case Scanning: {
                    this.state.setActiveView(MapsAppState$View.Encoder);
                }
            }
        });
        this.dialogService.root = anchorPane = this.rootPane;
    }
}

