/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.mapslog.data;

import java.util.function.Supplier;
import us.hebi.gui.lib.ark;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.bad;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bmv;
import us.hebi.gui.lib.bnz;
import us.hebi.gui.lib.bol;
import us.hebi.gui.lib.bpb;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.lib.bqx;
import us.hebi.gui.lib.brg;
import us.hebi.gui.lib.brk;
import us.hebi.gui.lib.cdw;
import us.hebi.gui.lib.cel;
import us.hebi.gui.lib.cen;
import us.hebi.gui.lib.jc;
import us.hebi.gui.lib.zr;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class MapsLogFeedback
extends zr {
    private static final Supplier<String> poseCategory = () -> "World Pose";
    private static final Supplier<String> MapPointCategory = () -> "Mapped Point";
    private static final Supplier<String> utCategory = () -> "UT Data";
    private static final Supplier<String> RobotCategory = () -> "Robot";
    private static final Supplier<String> RuntimeCategory = () -> "Runtime";
    long startTime = 0L;
    int numJoints = -1;
    int maxEntries = -1;
    public jc time;
    public jc mapX;
    public jc mapY;
    public jc mapTheta;
    public jc mapDistance;
    public jc mapAngularDistance;
    public jc[] mapXyz;
    public jc runtimeAmbientTemperature;
    public jc runtimeBatteryVoltage;
    public jc runtimePcResidentMemoryUsage;
    public jc runtimePcVirtualMemoryUsage;
    public jc runtimePcUserCpuUsage;
    public jc runtimePcKernelCpuUsage;
    public jc runtimePcTemperature;
    public jc runtimePcVoltage;
    public jc runtimeMainCycleTimeMs;
    public jc runtimeMainBusyTimeMs;
    public jc runtimeCyclesSincePositionSourceData;
    public jc utThicknessSamples;
    public jc[] poseTranslation;
    public jc[] poseOrientation;
    public jc poseDelay;
    public jc[] position;
    public jc[] velocity;
    public jc[] power;
    public jc[] sequence;
    public jc[] rxSequence;
    public jc[] temperature;
    public jc[] voltage;
    public jc[] roundTripTime;
    public jc[] hwResponseTime;
    public jc[] transmitTimeDelta;
    public jc[] packetLoss;
    public jc[] firstOrientation;
    private final bpb prevRobotFbk = bpb.a();

    public MapsLogFeedback() {
        this.init(8192);
    }

    public MapsLogFeedback init(int n2) {
        this.maxEntries = n2;
        this.resize();
        return this;
    }

    private jc[] resizeGroup(jc[] jcArray) {
        return this.resizeMultiple(jcArray, this.numJoints);
    }

    private jc[] resizeMultiple(jc[] jcArray, int n2) {
        return TDoubleArrayListRegistry.resizeMultiple(jcArray, n2, this.maxEntries);
    }

    private jc resizeSingle(jc jc2) {
        return TDoubleArrayListRegistry.resizeSingle(jc2, this.maxEntries);
    }

    @Override
    public void onHeader(brk brk2) {
        if (brk2.eq()) {
            this.startTime = brk2.aK;
            return;
        }
        if (brk2.ep()) {
            this.startTime = brk2.B;
        }
    }

    @Override
    public void onResponse(brg brg2, bol bol2, int n2) {
        if (!bol2.ck()) {
            return;
        }
        bmv bmv2 = bol2.a;
        bnz bnz2 = bol2.a.a;
        this.time.c(ark.a(brg2.B - this.startTime));
        this.mapX.c(bnz2.o);
        this.mapY.c(bnz2.p);
        this.mapTheta.c(bnz2.z);
        this.mapDistance.c(bnz2.A);
        this.mapAngularDistance.c(bnz2.B);
        this.mapXyz[0].c((double)bnz2.a.o * 1000.0);
        this.mapXyz[1].c((double)bnz2.a.p * 1000.0);
        this.mapXyz[2].c((double)bnz2.a.q * 1000.0);
        bpd bpd2 = bol2.a.a;
        this.runtimeAmbientTemperature.c(bpd2.aj);
        this.runtimeBatteryVoltage.c(bpd2.ak);
        this.runtimePcResidentMemoryUsage.c(bpd2.al / 1024.0f);
        this.runtimePcVirtualMemoryUsage.c(bpd2.am / 1024.0f);
        this.runtimePcUserCpuUsage.c(bpd2.an);
        this.runtimePcKernelCpuUsage.c(bpd2.ao);
        this.runtimePcTemperature.c(bpd2.ap);
        this.runtimePcVoltage.c(bpd2.aq);
        this.runtimeMainCycleTimeMs.c(bpd2.ar);
        this.runtimeMainBusyTimeMs.c(bpd2.as);
        this.runtimeCyclesSincePositionSourceData.c((double)bpd2.el);
        this.utThicknessSamples.c((double)bmv2.a.ec);
        bqx bqx2 = bol2.a.a;
        this.poseTranslation[0].c((double)bqx2.d.o * 1000.0);
        this.poseTranslation[1].c((double)bqx2.d.p * 1000.0);
        this.poseTranslation[2].c((double)bqx2.d.q * 1000.0);
        this.poseOrientation[0].c(bqx2.c.ai);
        this.poseOrientation[1].c(bqx2.c.o);
        this.poseOrientation[2].c(bqx2.c.p);
        this.poseOrientation[3].c(bqx2.c.q);
        this.poseDelay.c((double)bqx2.ew);
        if (bmv2.br()) {
            bpb bpb2 = bmv2.a;
            if (this.numJoints < 0) {
                this.numJoints = bpb2.b.ar();
                this.resizeRobotFeedback(bpb2);
            }
            MapsLogFeedback mapsLogFeedback = this;
            mapsLogFeedback.addMultiple(mapsLogFeedback.position, bpb2.b);
            MapsLogFeedback mapsLogFeedback2 = this;
            mapsLogFeedback2.addMultiple(mapsLogFeedback2.velocity, bpb2.c);
            MapsLogFeedback mapsLogFeedback3 = this;
            mapsLogFeedback3.addMultiple(mapsLogFeedback3.power, bpb2.d);
            MapsLogFeedback mapsLogFeedback4 = this;
            mapsLogFeedback4.addMultiple(mapsLogFeedback4.sequence, bpb2.a);
            MapsLogFeedback mapsLogFeedback5 = this;
            mapsLogFeedback5.addMultiple(mapsLogFeedback5.rxSequence, bpb2.b);
            MapsLogFeedback mapsLogFeedback6 = this;
            mapsLogFeedback6.addMultiple(mapsLogFeedback6.temperature, bpb2.e);
            MapsLogFeedback mapsLogFeedback7 = this;
            mapsLogFeedback7.addMultiple(mapsLogFeedback7.voltage, bpb2.f);
            MapsLogFeedback mapsLogFeedback8 = this;
            mapsLogFeedback8.addMultiple(mapsLogFeedback8.firstOrientation, bpb2.g);
            for (int i2 = 0; i2 < this.roundTripTime.length; ++i2) {
                this.roundTripTime[i2].c(1000.0 * ark.a(bpb2.e.e(i2) - bpb2.f.e(i2)));
                this.hwResponseTime[i2].c(1000.0 * ark.a(bpb2.d.e(i2) - bpb2.c.e(i2)));
                if (((cdw)this.prevRobotFbk).isEmpty()) {
                    this.transmitTimeDelta[i2].c(Double.NaN);
                    this.packetLoss[i2].c(Double.NaN);
                    continue;
                }
                double d2 = ark.a(bpb2.f.e(i2) - this.prevRobotFbk.f.e(i2));
                this.transmitTimeDelta[i2].c(d2 * 1000.0);
                this.packetLoss[i2].c(bpb2.a.e(i2) - this.prevRobotFbk.a.e(i2) - 1L);
            }
            this.prevRobotFbk.a(bpb2);
        }
    }

    private void addMultiple(jc[] jcArray, cel cel2) {
        for (int i2 = 0; i2 < jcArray.length; ++i2) {
            jcArray[i2].c(cel2.a(i2));
        }
    }

    private void addMultiple(jc[] jcArray, cen cen2) {
        for (int i2 = 0; i2 < jcArray.length; ++i2) {
            jcArray[i2].c(cen2.e(i2));
        }
    }

    public void getCharts(ChartList chartList) {
        chartList.setTime(this.time).setTraceType(bat.a).addTimeTraces(MapPointCategory, "Position XY", null, 0.0, 1.0, new jc[]{this.mapX, this.mapY}, renderer -> {
            azk.a(renderer, 0, "X", "trace-solid");
            azk.a(renderer, 1, "Y", "trace-solid");
        }).addDeviceXY(MapPointCategory, "Position XY (2D)", bad.a("X", null), new jc[]{this.mapX}, bad.a("Y", null), new jc[]{this.mapY}).addSingleTrace(MapPointCategory, "Theta", null, 0.0, 1.0, this.mapTheta).addSingleTrace(MapPointCategory, "Distance", null, 0.0, 0.0, this.mapDistance).addSingleTrace(MapPointCategory, "Angular Distance", null, 0.0, 0.0, this.mapAngularDistance).addXyzChart(MapPointCategory, "Position XYZ (closest)", "mm", -50.0, 50.0, this.mapXyz).addXyzChart(poseCategory, "Position XYZ", "mm", -50.0, 50.0, this.poseTranslation).addQuaternionTraces(poseCategory, "Orientation", this.poseOrientation).addSingleTrace(poseCategory, "Delay", "ms", 0.0, 10.0, this.poseDelay);
        if (!((cdw)this.prevRobotFbk).isEmpty()) {
            chartList.setTraceType(bat.a).addDeviceChart(RobotCategory, "Position", "rad", -1.5707963267948966, 1.5707963267948966, this.position).addDeviceChart(RobotCategory, "Velocity", "rad/s", -5.0, 5.0, this.velocity).addDeviceChart(RobotCategory, "Power", "W", 0.0, 1.0, this.power).addDeviceChart(RobotCategory, "Voltage", "V", 0.0, 50.0, this.voltage).addDeviceChart(RobotCategory, "Temperature", "\u00b0C", 0.0, 100.0, this.temperature).addQuaternionTraces(RobotCategory, "First Orientation", this.firstOrientation).setTraceType(bat.c).addDeviceChart(RobotCategory, "Round Trip Time", "ms", 0.0, 0.5, this.roundTripTime).addAsHistogram(RobotCategory, "Round Trip Time %", "ms", this.roundTripTime).addDeviceChart(RobotCategory, "Hardware Response Time", "ms", 0.0, 0.5, this.hwResponseTime).addAsHistogram(RobotCategory, "Hardware Response Time %", "ms", this.hwResponseTime).addDeviceChart(RobotCategory, "Transmit Time Delta", "ms", 0.0, 0.5, this.transmitTimeDelta).addAsHistogram(RobotCategory, "Transmit Time Delta %", "ms", this.transmitTimeDelta).addDeviceChart(RobotCategory, "Packet Loss", "", 0.0, 1.0, this.packetLoss).addAsHistogram(RobotCategory, "Packet Loss %", "", this.packetLoss).addDeviceChart(RobotCategory, "Rx Sequence", "", 0.0, 1.0, this.rxSequence).setTraceType(bat.a);
        }
        chartList.setTraceType(bat.a).addTimeTraces(RuntimeCategory, "Voltage", "V", 0.0, 50.0, new jc[]{this.runtimeBatteryVoltage, this.runtimePcVoltage}, renderer -> {
            azk.a(renderer, 0, "battery", new String[0]);
            azk.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Temperature", "\u00b0C", 0.0, 50.0, new jc[]{this.runtimeAmbientTemperature, this.runtimePcTemperature}, renderer -> {
            azk.a(renderer, 0, "ambient", new String[0]);
            azk.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "CPU Usage", "%", 0.0, 100.0, new jc[]{this.runtimePcUserCpuUsage, this.runtimePcKernelCpuUsage}, renderer -> {
            azk.a(renderer, 0, "user", new String[0]);
            azk.a(renderer, 1, "kernel", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Memory Usage", "MB", 0.0, 10.0, new jc[]{this.runtimePcResidentMemoryUsage, this.runtimePcVirtualMemoryUsage}, renderer -> {
            azk.a(renderer, 0, "resident", new String[0]);
            azk.a(renderer, 1, "virtual", new String[0]);
        }).addSingleTrace(RuntimeCategory, "Cycles Since Position", null, 0.0, 1.0, this.runtimeCyclesSincePositionSourceData).setTraceType(bat.c).addTimeTraces(RuntimeCategory, "Main Loop Times", "ms", 0.0, 10.0, new jc[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            azk.a(renderer, 0, "cycle time", new String[0]);
            azk.a(renderer, 1, "busy time", new String[0]);
        }).addAsHistogram(RuntimeCategory, "Main Loop Times %", "ms", new jc[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            azk.a(renderer, 0, "cycle time", new String[0]);
            azk.a(renderer, 1, "busy time", new String[0]);
        });
    }

    private void resize() {
        this.time = this.resizeSingle(this.time);
        this.mapX = this.resizeSingle(this.mapX);
        this.mapY = this.resizeSingle(this.mapY);
        this.mapTheta = this.resizeSingle(this.mapTheta);
        this.mapDistance = this.resizeSingle(this.mapDistance);
        this.mapAngularDistance = this.resizeSingle(this.mapAngularDistance);
        this.mapXyz = this.resizeMultiple(this.mapXyz, 3);
        this.runtimeAmbientTemperature = this.resizeSingle(this.runtimeAmbientTemperature);
        this.runtimeBatteryVoltage = this.resizeSingle(this.runtimeBatteryVoltage);
        this.runtimePcResidentMemoryUsage = this.resizeSingle(this.runtimePcResidentMemoryUsage);
        this.runtimePcVirtualMemoryUsage = this.resizeSingle(this.runtimePcVirtualMemoryUsage);
        this.runtimePcUserCpuUsage = this.resizeSingle(this.runtimePcUserCpuUsage);
        this.runtimePcKernelCpuUsage = this.resizeSingle(this.runtimePcKernelCpuUsage);
        this.runtimePcTemperature = this.resizeSingle(this.runtimePcTemperature);
        this.runtimePcVoltage = this.resizeSingle(this.runtimePcVoltage);
        this.runtimeMainCycleTimeMs = this.resizeSingle(this.runtimeMainCycleTimeMs);
        this.runtimeMainBusyTimeMs = this.resizeSingle(this.runtimeMainBusyTimeMs);
        this.runtimeCyclesSincePositionSourceData = this.resizeSingle(this.runtimeCyclesSincePositionSourceData);
        this.utThicknessSamples = this.resizeSingle(this.utThicknessSamples);
        this.poseTranslation = this.resizeMultiple(this.poseTranslation, 3);
        this.poseOrientation = this.resizeMultiple(this.poseOrientation, 4);
        this.poseDelay = this.resizeSingle(this.poseDelay);
    }

    private void resizeRobotFeedback(bpb bpb2) {
        this.numJoints = bpb2.b.ar();
        this.position = this.resizeMultiple(this.position, bpb2.b.ar());
        this.velocity = this.resizeMultiple(this.velocity, bpb2.c.ar());
        this.power = this.resizeMultiple(this.power, bpb2.d.ar());
        this.sequence = this.resizeMultiple(this.sequence, bpb2.a.ar());
        this.rxSequence = this.resizeMultiple(this.rxSequence, bpb2.b.ar());
        this.roundTripTime = this.resizeMultiple(this.roundTripTime, bpb2.c.ar());
        this.hwResponseTime = this.resizeMultiple(this.hwResponseTime, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.packetLoss = this.resizeMultiple(this.packetLoss, this.roundTripTime.length);
        this.temperature = this.resizeMultiple(this.temperature, bpb2.e.ar());
        this.voltage = this.resizeMultiple(this.voltage, bpb2.f.ar());
        this.firstOrientation = this.resizeMultiple(this.firstOrientation, 4);
        this.prevRobotFbk.c();
    }
}

