/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.custom;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.air;
import us.hebi.gui.lib.anq;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.bak;
import us.hebi.gui.lib.baz;
import us.hebi.gui.lib.bba;
import us.hebi.gui.lib.bbb;
import us.hebi.gui.lib.bef;
import us.hebi.gui.lib.jc;

public class DeviceData {
    final ahg deviceAddress;
    String family;
    String name;
    final jc time = new jc();
    final List<bba> xmlCharts;
    final HashMap<String, bef> expressionMap = new HashMap();
    final List<bef> traceValues;
    private boolean hasInfo = false;
    private final anq info = new anq();
    private List<List<DataSet>> allChartTraces = Collections.emptyList();

    public DeviceData(ahg ahg2, List<bba> list, int n2) {
        this.xmlCharts = list;
        this.deviceAddress = ahg2;
        for (bba bba2 : list) {
            for (bbb bbb2 : bba2.getTraces()) {
                if (this.expressionMap.containsKey(bbb2.getValue())) continue;
                this.expressionMap.put(bbb2.getValue(), new bef(bbb2.getFunc(), new jc(n2)));
            }
            baz baz2 = bba2.getAxisX();
            if (baz2 == null || this.expressionMap.containsKey(baz2.getExpression())) continue;
            this.expressionMap.put(baz2.getExpression(), new bef(baz2.getFunc(), new jc(n2)));
        }
        this.traceValues = List.copyOf(this.expressionMap.values());
    }

    public boolean hasInfo() {
        return this.hasInfo;
    }

    public air getInfo() {
        return this.info;
    }

    public void addInfo(air air2) {
        this.family = air2.getFamily();
        this.name = air2.getName();
        this.info.a(air2);
        this.hasInfo = true;
    }

    public void addFeedback(double d2, FlatFeedback flatFeedback, FlatFeedback flatFeedback2) {
        this.time.c(d2);
        Iterator<bef> iterator = this.traceValues.iterator();
        while (iterator.hasNext()) {
            FlatFeedback flatFeedback3 = flatFeedback2;
            FlatFeedback flatFeedback4 = flatFeedback;
            bef bef2 = iterator.next();
            bef2.d.c(bef2.a.computeValue(flatFeedback4, flatFeedback3));
        }
    }

    public void convertToDataSets() {
        double[] dArray = DeviceData.toArrayAndReset(this.time);
        this.allChartTraces = new ArrayList<List<DataSet>>(this.xmlCharts.size());
        for (int i2 = 0; i2 < this.xmlCharts.size(); ++i2) {
            bba bba2 = this.xmlCharts.get(i2);
            int n2 = bba2.getTraces().size();
            ArrayList<bak> arrayList = new ArrayList<bak>(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                bbb bbb2 = bba2.getTraces().get(i3);
                double[] dArray2 = bba2.getAxisX() == null ? dArray : this.getValues(bba2.getAxisX().getExpression());
                double[] dArray3 = this.getValues(bbb2.getValue());
                String string = bbb2.getLabel() + "[" + bbb2.getUnits() + "]";
                bak bak2 = new bak(string, dArray2, dArray3);
                bak2.addStyleClasses(new String[]{bbb2.getStyle().D()});
                bak2.setStyle(DataSetStyleBuilder.instance().setDatasetColor(azk.a(bbb2.getColor())).build());
                arrayList.add(bak2);
            }
            this.allChartTraces.add(arrayList);
        }
    }

    public List<DataSet> getDataSets(int n2) {
        return this.allChartTraces.get(n2);
    }

    static double[] toArrayAndReset(jc jc2) {
        try {
            double[] dArray = jc2.a();
            return dArray;
        }
        finally {
            jc2.q();
        }
    }

    private double[] getValues(String string) {
        bef bef2 = this.expressionMap.get(string);
        if (bef2.M == null) {
            bef2.M = DeviceData.toArrayAndReset(bef2.d);
        }
        return bef2.M;
    }

    public String toString() {
        if (this.family != null || this.name != null) {
            return this.family + " | " + this.name;
        }
        return String.valueOf(this.deviceAddress).substring(1);
    }
}

