/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer;

import io.fair_acc.chartfx.XYChart;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Material;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.lib.abv;
import us.hebi.gui.lib.afh;
import us.hebi.gui.lib.afj;
import us.hebi.gui.lib.air;
import us.hebi.gui.lib.aqp;
import us.hebi.gui.lib.aru;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.auy;
import us.hebi.gui.lib.avf;
import us.hebi.gui.lib.avn;
import us.hebi.gui.lib.avo;
import us.hebi.gui.lib.avt;
import us.hebi.gui.lib.avw;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.bcn;
import us.hebi.gui.lib.bdb;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdg;
import us.hebi.gui.lib.bdh;
import us.hebi.gui.lib.bdu;
import us.hebi.gui.lib.bdv;
import us.hebi.gui.lib.bdx;
import us.hebi.gui.lib.bec;
import us.hebi.gui.lib.bgi;
import us.hebi.gui.lib.bho;
import us.hebi.gui.lib.bhp;
import us.hebi.gui.lib.blm;
import us.hebi.gui.lib.zd;
import us.hebi.gui.views.ResourceLoader$ScopeIcons;
import us.hebi.gui.views.logviewer.custom.CustomLogviewerView;
import us.hebi.gui.views.logviewer.hebilog.HebiLogContent;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.hebilog.MobileIoFeedback;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.NamedChart;
import us.hebi.gui.views.scope.assets.Asset;

public class LogviewerPresenter
extends bcn {
    @FXML
    private Pane root;
    @FXML
    private TreeView<NamedChart> plotTree;
    @FXML
    private AnchorPane chartPane;
    @FXML
    private Button saveGainsBtn;
    @FXML
    private Button loadHrdfOrConfigBtn;
    @FXML
    private Button loadCustomBtn;
    @FXML
    private Button showInfoBtn;
    @FXML
    private Button view3dBtn;
    public static final PseudoClass CELL_CATEGORY = PseudoClass.getPseudoClass((String)"category");
    final TreeItem<NamedChart> rootNode = new TreeItem();
    @Inject
    HebiLogContent logContent;
    @Inject
    ayn fileChooser;
    @Inject
    aup properties;
    @Inject
    awh notificationService;
    bdh indicator = new bdh();
    DoubleProperty selectedTime = new SimpleDoubleProperty(0.0);
    bdb timer = bdb.a(d2 -> this.selectedTime.set(this.selectedTime.get() + d2));
    IntegerBinding selectedIndex = Bindings.createIntegerBinding(() -> {
        double d2 = this.selectedTime.get();
        if (!Double.isFinite(d2) || this.logContent == null || !this.logContent.hasValidFeedback()) {
            return -1;
        }
        return this.logContent.getFeedback().getIndexAt(d2);
    }, (Observable[])new Observable[]{this.selectedTime});
    BooleanProperty showModelCmd = new SimpleBooleanProperty(false);
    SimpleObjectProperty<Parent> infoTable = new SimpleObjectProperty();

    @Override
    public void initializeFx() {
        bdx.e((Parent)this.root);
        this.indicator.a((Pane)this.root).loading.bind((ObservableValue)this.logContent.loadingProperty());
        this.logContent.loadAsync().thenRunAsync(this::updateChartMenu, Platform::runLater);
        XYChart xYChart = azk.a(-10.0, 10.0, "");
        this.chartPane.getChildren().setAll((Object[])new Node[]{bdc.c(xYChart)});
        bdg.b((Node)this.chartPane);
        this.plotTree.setCellFactory(LogviewerPresenter::createStyledCell);
        this.plotTree.setRoot(this.rootNode);
        this.plotTree.getSelectionModel().selectedItemProperty().addListener((observableValue, treeItem, treeItem2) -> {
            if (treeItem2 == null || treeItem2.getValue() == null || ((NamedChart)treeItem2.getValue()).isCategory()) {
                return;
            }
            this.chartPane.getChildren().setAll((Object[])new Node[]{bdc.c(((NamedChart)treeItem2.getValue()).getChart())});
        });
        this.showInfoBtn.disableProperty().bind((ObservableValue)this.infoTable.isNull());
        this.showInfoBtn.setOnAction(actionEvent -> this.chartPane.getChildren().setAll((Object[])new Node[]{bdc.c((Parent)this.infoTable.get())}));
        this.saveGainsBtn.disableProperty().bind((ObservableValue)this.logContent.hasInfoProperty().not());
        this.saveGainsBtn.setOnAction(actionEvent -> {
            Window window = bdc.a(actionEvent);
            File file = this.fileChooser.f(window);
            if (file != null) {
                try {
                    File file2 = file;
                    abv abv2 = abv.a(this.logContent.getInfo());
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        abv2.a(fileOutputStream);
                    }
                    awg.a(file, window);
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.f(exception);
                }
            }
        });
        this.loadHrdfOrConfigBtn.setOnAction(actionEvent -> {
            Window window = bdc.a(actionEvent);
            File file = this.fileChooser.c(window);
            if (file != null) {
                try {
                    this.logContent.setRobotConfig(null);
                    if (zd.a(file) == zd.e) {
                        afj afj2 = afj.tryReadFile(file.toPath());
                        this.logContent.setRobotConfig(afj2);
                        file = new File(blm.b(afj2.getHrdf(), (Object)"Robot config does not specify an hrdf"));
                    }
                    int n2 = bhp.a(file).a().Q();
                    if (this.logContent.getNumJoints() != n2) {
                        throw new IllegalArgumentException("The log file contains " + this.logContent.getNumJoints() + " joints, but the selected HRDF lists " + n2 + " joints.");
                    }
                    this.logContent.setHrdfFile(file, this.logContent.getIndexMap());
                    this.updateChartMenu();
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.f(exception);
                }
            }
        });
        this.loadCustomBtn.setOnAction(actionEvent -> new CustomLogviewerView(this.logContent.getFile()).getViewAsync(parent -> {
            Stage stage = new Stage();
            stage.getIcons().add((Object)ResourceLoader$ScopeIcons.icon);
            stage.setTitle(this.logContent.getFileName());
            stage.setScene(new Scene(parent));
            bdc.a(stage, bdc.a(actionEvent));
        }));
        if (!bdc.aG()) {
            this.view3dBtn.setDisable(true);
        } else {
            BooleanBinding booleanBinding = Bindings.size(this.logContent.getMobileIoList()).isEqualTo(0);
            this.view3dBtn.disableProperty().bind((ObservableValue)booleanBinding.and((ObservableBooleanValue)this.logContent.hasValidHrdf().not()));
            this.view3dBtn.setOnAction(actionEvent -> {
                Window window = bdc.a(actionEvent);
                if (this.logContent.hasValidHrdf().get()) {
                    this.launchStage(window, (Pane)this.createRobotView3d());
                }
                for (MobileIoFeedback mobileIoFeedback : this.logContent.getMobileIoList()) {
                    this.launchStage(window, (Pane)this.createMobileIo3d(mobileIoFeedback));
                }
            });
        }
        this.selectedTime.bindBidirectional((Property)this.logContent.getChartList().getIndicatorTime());
        bdc.a((Node)this.root, this::registerKeyHandler);
    }

    private void launchStage(Window window, Pane pane) {
        Stage stage = new Stage();
        stage.getIcons().add((Object)ResourceLoader$ScopeIcons.icon);
        stage.setTitle(this.logContent.getFileName());
        stage.setScene(new Scene((Parent)pane, 700.0, 450.0, true));
        bdc.a(stage, window);
        Stage stage2 = stage;
        bdg.a(stage2, () -> ((Stage)stage2).close());
    }

    private void registerKeyHandler(Scene scene) {
        scene.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (bdg.o.match(keyEvent)) {
                this.timer.bH();
                keyEvent.consume();
                return;
            }
            if (bdg.a.match(keyEvent)) {
                this.showModelCmd.set(!this.showModelCmd.get());
                keyEvent.consume();
                return;
            }
            if (bdg.e.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() - 1.0);
                keyEvent.consume();
                return;
            }
            if (bdg.f.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() + 1.0);
                keyEvent.consume();
            }
        });
    }

    private AnchorPane createRobotView3d() {
        avt avt2 = new avt().a();
        aru aru2 = avt2.a;
        avf avf2 = new avf(this.logContent.getXmlContent());
        avf2.s.bind((ObservableValue)avt2.e.visibleProperty());
        avf2.t.bind((ObservableValue)aru2.a("CoM Axes", false));
        Object object = "Models";
        avf2.u.bind((ObservableValue)aru2.a("Models", true));
        BooleanProperty booleanProperty = aru2.a("Command Overlay", this.showModelCmd.get(), "ctrl + f");
        bdc.a(booleanProperty, this.showModelCmd);
        avf avf3 = new avf(this.logContent.getXmlContent());
        avf3.s.set(false);
        avf3.t.set(false);
        avf3.u.bind((ObservableValue)avf2.u);
        avf3.c.visibleProperty().bind((ObservableValue)booleanProperty);
        avo.a((Node)avf3.c, (Material)avf.c);
        XyzLogData xyzLogData = this.logContent.getXyzData();
        avn avn2 = new avn(xyzLogData.xyzPosition, azj.f);
        avn avn3 = new avn(xyzLogData.xyzPositionCmd, azj.e);
        object = "Fbk Line";
        avn2.visibleProperty().bind((ObservableValue)aru2.a("Fbk Line", true));
        object = "Cmd Line";
        avn3.visibleProperty().bind((ObservableValue)aru2.a("Cmd Line", true));
        BooleanProperty booleanProperty2 = aru2.a("Full Line", false);
        avn2.D.bind((ObservableValue)booleanProperty2);
        avn3.D.bind((ObservableValue)booleanProperty2);
        Node node = avf.a();
        node.visibleProperty().bind((ObservableValue)avf2.t);
        bgi bgi2 = bhp.a(this.logContent.getXmlContent()).a();
        object = node;
        auy auy2 = new auy(new bho(bgi2));
        new auy(new bho(bgi2)).b = object;
        avt avt3 = avt2;
        object = avt3.d;
        v0.a = object;
        auy auy3 = auy2;
        this.logContent.getRobotConfig().flatMap(afh::getGravComp).ifPresent(auy3::a);
        auy3.q.bind((ObservableValue)aru2.a("Orient Base", false));
        auy3.r.bind((ObservableValue)aru2.a("Offset Base", false));
        auy3.update();
        bdc.a(aru2.a("Play", this.timer.N.get(), "ctrl + space"), this.timer.N);
        avt3 = avt2;
        avt3.d.getChildren().setAll((Object[])new Node[]{avf2.c, avf3.c, avn2, avn3, node});
        aqp aqp2 = this.logContent.getIndexMap();
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            avn3.u(n2);
            avn2.u(n2);
            HebiLogFeedback hebiLogFeedback = this.logContent.getFeedback();
            for (int i2 = 0; i2 < hebiLogFeedback.getNumJoints(); ++i2) {
                int n3 = aqp2.apply(i2);
                avf2.b(i2, hebiLogFeedback.position[n3].a(n2));
                avf3.b(i2, hebiLogFeedback.positionCmd[n3].a(n2));
                auy3.a(i2, hebiLogFeedback.position[n3].a(n2));
                auy3.a(i2, hebiLogFeedback.orientationW[n3].a(n2), hebiLogFeedback.orientationX[n3].a(n2), hebiLogFeedback.orientationY[n3].a(n2), hebiLogFeedback.orientationZ[n3].a(n2));
            }
            auy3.update();
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        bdc.a((Node)avt2, this::registerKeyHandler);
        bdv.d((Parent)avt2);
        bdu.b((Parent)avt2);
        bdx.e((Parent)avt2);
        bdc.a((Parent)avt2);
        return avt2;
    }

    private AnchorPane createMobileIo3d(MobileIoFeedback mobileIoFeedback) {
        avt avt2 = new avt().a();
        aru aru2 = avt2.a;
        String string = "Model";
        BooleanProperty booleanProperty = aru2.a("Model", true);
        avw avw2 = new avw(new Node[0]);
        Asset.Iphone.getModelAsync(group -> {
            group.visibleProperty().bind((ObservableValue)booleanProperty);
            avw2.getChildren().add(group);
        });
        avn avn2 = new avn(mobileIoFeedback.arPosition, azj.i);
        BooleanProperty booleanProperty2 = aru2.a("Full Path", false);
        string = "Path";
        avn2.visibleProperty().bind((ObservableValue)aru2.a("Path", true));
        avn2.D.bind((ObservableValue)booleanProperty2);
        bdc.a(aru2.a("Play", this.timer.N.get(), "ctrl + space"), this.timer.N);
        avt avt3 = avt2;
        avt3.d.getChildren().setAll((Object[])new Node[]{avn2, avw2});
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            avn2.u(n2);
            avw2.b(mobileIoFeedback.arOrientation[0].a(n2), mobileIoFeedback.arOrientation[1].a(n2), mobileIoFeedback.arOrientation[2].a(n2), mobileIoFeedback.arOrientation[3].a(n2), mobileIoFeedback.arPosition[0].a(n2), mobileIoFeedback.arPosition[1].a(n2), mobileIoFeedback.arPosition[2].a(n2));
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        bdc.a((Node)avt2, this::registerKeyHandler);
        bdv.d((Parent)avt2);
        bdu.b((Parent)avt2);
        bdx.e((Parent)avt2);
        bdc.a((Parent)avt2);
        return avt2;
    }

    public void updateChartMenu() {
        this.plotTree.getSelectionModel().clearSelection();
        this.rootNode.getChildren().setAll(this.logContent.createChartHierarchy());
        if (this.rootNode.getChildren().size() > 0) {
            this.plotTree.getSelectionModel().select(1);
        }
        LogviewerPresenter logviewerPresenter = this;
        Optional.ofNullable(logviewerPresenter.createInfoTable(logviewerPresenter.logContent.getInfo())).ifPresent(arg_0 -> this.infoTable.set(arg_0));
    }

    TableView<air> createInfoTable(air[] airArray) {
        if (airArray == null || airArray.length == 0) {
            return null;
        }
        ObservableList observableList = FXCollections.observableArrayList((Object[])airArray);
        TableView tableView = new TableView();
        Object[] objectArray = new TableColumn[7];
        objectArray[0] = this.createColumn("Index", arg_0 -> observableList.indexOf(arg_0));
        objectArray[1] = this.createCategory("Identifier", this.createColumn("Family", air::getFamily), this.createColumn("Name", air::getName), this.createColumn("Serial", air2 -> air2.a().f()));
        objectArray[2] = this.createCategory("Gains", this.createColumn("Strategy", air2 -> air2.a().a()));
        objectArray[3] = this.createCategory("Mechanical", this.createColumn("Type", air2 -> air2.a().u()), this.createColumn("Rev", air2 -> air2.a().v()));
        objectArray[4] = this.createCategory("Electrical", this.createColumn("Type", air2 -> air2.a().s()), this.createColumn("Rev", air2 -> air2.a().t()));
        objectArray[5] = this.createCategory("Firmware", this.createColumn("Type", air2 -> air2.a().getType()), this.createColumn("Rev", air2 -> air2.a().p()));
        objectArray[6] = this.createCategory("Network", this.createColumn("Mac", air2 -> air2.a().b()), this.createColumn("IP", air2 -> air2.a().b().getHostAddress()), this.createColumn("Subnet", air2 -> air2.a().c().getHostAddress()));
        tableView.getColumns().addAll(objectArray);
        tableView.setItems(observableList);
        bdc.c(tableView);
        tableView.setPrefSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return tableView;
    }

    private TableColumn<air, String> createCategory(String string, TableColumn<air, String> ... tableColumnArray) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.getColumns().setAll((Object[])tableColumnArray);
        return tableColumn;
    }

    private TableColumn<air, String> createColumn(String string, Function<air, Object> function) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.setCellValueFactory(cellDataFeatures -> {
            String string = String.valueOf(function.apply((air)cellDataFeatures.getValue()));
            return new SimpleStringProperty(string);
        });
        return tableColumn;
    }

    public static <T> TreeCell<NamedChart> createStyledCell(TreeView<NamedChart> treeView) {
        return new bec();
    }
}

