/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.glue;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import us.hebi.glue.UnsafeAccess;

class DirectBuffer6Fallback {
    private static final long INVALID_OFFSET = -1L;
    private static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;

    DirectBuffer6Fallback() {
    }

    static long getAddress(ByteBuffer byteBuffer) {
        if (BYTE_BUFFER_ADDRESS_FIELD_OFFSET == -1L) {
            String string = "DirectBuffer6::getAddress may require JVM option '--add-opens=java.base/java.nio=ALL-UNNAMED'";
            System.err.println(string);
            throw new AssertionError((Object)string);
        }
        return UnsafeAccess.UNSAFE.getLong(byteBuffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l2 = -1L;
        try {
            Field field = Buffer.class.getDeclaredField("address");
            l2 = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        finally {
            BYTE_BUFFER_ADDRESS_FIELD_OFFSET = l2;
        }
    }
}

