/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation.decoration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.control.Control;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.StyleClassDecoration;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.decoration.AbstractValidationDecoration;

public class StyleClassValidationDecoration
extends AbstractValidationDecoration {
    private final String errorClass;
    private final String warningClass;
    private final String infoClass;
    private final String okClass;

    public StyleClassValidationDecoration() {
        this(null, null);
    }

    public StyleClassValidationDecoration(String string, String string2) {
        this(string, string2, null, null);
    }

    public StyleClassValidationDecoration(String string, String string2, String string3, String string4) {
        this.errorClass = string != null ? string : "error";
        this.warningClass = string2 != null ? string2 : "warning";
        this.infoClass = string3 != null ? string3 : "info";
        this.okClass = string4 != null ? string4 : "ok";
    }

    @Override
    protected Collection<Decoration> createValidationDecorations(ValidationMessage validationMessage) {
        String string = this.infoClass;
        switch (validationMessage.getSeverity()) {
            case ERROR: {
                string = this.errorClass;
                break;
            }
            case WARNING: {
                string = this.warningClass;
                break;
            }
            case OK: {
                string = this.okClass;
                break;
            }
            default: {
                string = this.infoClass;
            }
        }
        return Arrays.asList(new StyleClassDecoration(string));
    }

    @Override
    protected Collection<Decoration> createRequiredDecorations(Control control) {
        return Collections.emptyList();
    }
}

