/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.i18n.Localization;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.controlsfx.dialog.DialogUtils;

public class ProgressDialog
extends Dialog<Void> {
    public ProgressDialog(Worker<?> worker) {
        if (worker != null && (worker.getState() == Worker.State.CANCELLED || worker.getState() == Worker.State.FAILED || worker.getState() == Worker.State.SUCCEEDED)) {
            return;
        }
        this.setResultConverter(buttonType -> null);
        DialogPane dialogPane = this.getDialogPane();
        this.setTitle(Localization.getString("progress.dlg.title"));
        dialogPane.setHeaderText(Localization.getString("progress.dlg.header"));
        dialogPane.getStyleClass().add((Object)"progress-dialog");
        dialogPane.getStylesheets().add((Object)ProgressDialog.class.getResource("dialogs.css").toExternalForm());
        Label label = new Label();
        label.textProperty().bind((ObservableValue)worker.messageProperty());
        WorkerProgressPane workerProgressPane = new WorkerProgressPane(this);
        workerProgressPane.setMaxWidth(Double.MAX_VALUE);
        workerProgressPane.setWorker(worker);
        VBox vBox = new VBox(10.0, new Node[]{label, workerProgressPane});
        vBox.setMaxWidth(Double.MAX_VALUE);
        vBox.setPrefSize(300.0, 100.0);
        Label label2 = new Label();
        label2.setWrapText(true);
        vBox.getChildren().add(0, (Object)label2);
        label2.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        dialogPane.setContent((Node)vBox);
    }

    private static class WorkerProgressPane
    extends Region {
        private Worker<?> worker;
        private boolean dialogVisible = false;
        private boolean cancelDialogShow = false;
        private ChangeListener<Worker.State> stateListener = new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                switch (state2) {
                    case CANCELLED: 
                    case FAILED: 
                    case SUCCEEDED: {
                        if (!dialogVisible) {
                            cancelDialogShow = true;
                            this.end();
                            break;
                        }
                        if (state != Worker.State.SCHEDULED && state != Worker.State.RUNNING) break;
                        this.end();
                        break;
                    }
                    case SCHEDULED: {
                        this.begin();
                        break;
                    }
                }
            }
        };
        private final ProgressDialog dialog;
        private final ProgressBar progressBar;

        public final void setWorker(Worker<?> worker) {
            if (worker != this.worker) {
                if (this.worker != null) {
                    this.worker.stateProperty().removeListener(this.stateListener);
                    this.end();
                }
                this.worker = worker;
                if (worker != null) {
                    worker.stateProperty().addListener(this.stateListener);
                    if (worker.getState() == Worker.State.RUNNING || worker.getState() == Worker.State.SCHEDULED) {
                        this.begin();
                    }
                }
            }
        }

        public WorkerProgressPane(ProgressDialog progressDialog) {
            this.dialog = progressDialog;
            this.progressBar = new ProgressBar();
            this.progressBar.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().add((Object)this.progressBar);
            if (this.worker != null) {
                this.progressBar.progressProperty().bind((ObservableValue)this.worker.progressProperty());
            }
        }

        private void begin() {
            this.cancelDialogShow = false;
            Platform.runLater(() -> {
                if (!this.cancelDialogShow) {
                    this.progressBar.progressProperty().bind((ObservableValue)this.worker.progressProperty());
                    this.dialogVisible = true;
                    this.dialog.show();
                }
            });
        }

        private void end() {
            this.progressBar.progressProperty().unbind();
            this.dialogVisible = false;
            DialogUtils.forcefullyHideDialog(this.dialog);
        }

        protected void layoutChildren() {
            if (this.progressBar != null) {
                Insets insets = this.getInsets();
                double d2 = this.getWidth() - insets.getLeft() - insets.getRight();
                double d3 = this.getHeight() - insets.getTop() - insets.getBottom();
                double d4 = this.progressBar.prefHeight(-1.0);
                double d5 = insets.getLeft() + (d2 - d2) / 2.0;
                double d6 = insets.getTop() + (d3 - d4) / 2.0;
                this.progressBar.resizeRelocate(d5, d6, d2, d4);
            }
        }
    }
}

