/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.i18n.Localization;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public class CommandLinksDialog
extends Dialog<ButtonType> {
    private static final int gapSize = 10;
    private final Map<ButtonType, CommandLinksButtonType> typeMap;
    private Label contentTextLabel;
    private GridPane grid = new GridPane(){

        protected double computePrefWidth(double d2) {
            boolean bl2 = true;
            double d3 = 0.0;
            for (ButtonType buttonType : CommandLinksDialog.this.getDialogPane().getButtonTypes()) {
                Button button = (Button)CommandLinksDialog.this.getDialogPane().lookupButton(buttonType);
                double d4 = button.getGraphic().prefWidth(-1.0);
                if (bl2) {
                    d3 = d4;
                    bl2 = false;
                    continue;
                }
                d3 = Math.min(d3, d4);
            }
            return d3 + 10.0;
        }

        protected double computePrefHeight(double d2) {
            double d3 = CommandLinksDialog.this.getDialogPane().getHeader() == null ? 0.0 : 10.0;
            for (ButtonType buttonType : CommandLinksDialog.this.getDialogPane().getButtonTypes()) {
                Button button = (Button)CommandLinksDialog.this.getDialogPane().lookupButton(buttonType);
                d3 += button.prefHeight(d2) + 10.0;
            }
            return d3 * 1.2;
        }
    };

    public CommandLinksDialog(CommandLinksButtonType ... commandLinksButtonTypeArray) {
        this(Arrays.asList(commandLinksButtonTypeArray));
    }

    public CommandLinksDialog(List<CommandLinksButtonType> list) {
        this.grid.setHgap(10.0);
        this.grid.setVgap(10.0);
        this.grid.getStyleClass().add((Object)"container");
        DialogPane dialogPane = new DialogPane(){

            protected Node createButtonBar() {
                return null;
            }

            protected Node createButton(ButtonType buttonType) {
                return CommandLinksDialog.this.createCommandLinksButton(buttonType);
            }
        };
        this.setDialogPane(dialogPane);
        this.setTitle(Localization.getString("Dialog.info.title"));
        dialogPane.getStyleClass().add((Object)"command-links-dialog");
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("dialogs.css").toExternalForm());
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("commandlink.css").toExternalForm());
        this.typeMap = new HashMap<ButtonType, CommandLinksButtonType>();
        for (CommandLinksButtonType commandLinksButtonType : list) {
            this.addLinkToDialog(dialogPane, commandLinksButtonType);
        }
        this.addLinkToDialog(dialogPane, CommandLinksButtonType.buildHiddenCancelLink());
        this.updateGrid();
        dialogPane.getButtonTypes().addListener(change -> this.updateGrid());
        this.contentTextProperty().addListener(observable -> this.updateContentText());
    }

    private void addLinkToDialog(DialogPane dialogPane, CommandLinksButtonType commandLinksButtonType) {
        this.typeMap.put(commandLinksButtonType.getButtonType(), commandLinksButtonType);
        dialogPane.getButtonTypes().add((Object)commandLinksButtonType.getButtonType());
    }

    private void updateContentText() {
        String string = this.getDialogPane().getContentText();
        this.grid.getChildren().remove((Object)this.contentTextLabel);
        if (string != null && !string.isEmpty()) {
            if (this.contentTextLabel != null) {
                this.contentTextLabel.setText(string);
            } else {
                this.contentTextLabel = new Label(this.getDialogPane().getContentText());
                this.contentTextLabel.getStyleClass().add((Object)"command-link-message");
            }
            this.grid.add((Node)this.contentTextLabel, 0, 0);
        }
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.updateContentText();
        int n2 = 1;
        for (ButtonType buttonType : this.getDialogPane().getButtonTypes()) {
            if (buttonType == null) continue;
            Button button = (Button)this.getDialogPane().lookupButton(buttonType);
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            this.grid.add((Node)button, 0, n2++);
        }
        this.getDialogPane().setContent((Node)this.grid);
        this.getDialogPane().requestLayout();
    }

    private Button createCommandLinksButton(ButtonType buttonType) {
        CommandLinksButtonType commandLinksButtonType = this.typeMap.getOrDefault(buttonType, new CommandLinksButtonType(buttonType));
        Button button = new Button();
        button.getStyleClass().addAll((Object[])new String[]{"command-link-button"});
        button.setMaxHeight(Double.MAX_VALUE);
        button.setMaxWidth(Double.MAX_VALUE);
        button.setAlignment(Pos.CENTER_LEFT);
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        button.setDefaultButton(buttonData != null && buttonData.isDefaultButton());
        button.setOnAction(actionEvent -> this.setResult(buttonType));
        final Label label = new Label(commandLinksButtonType.getButtonType().getText());
        label.minWidthProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{label.prefWidthProperty()});
            }

            protected double computeValue() {
                return label.getPrefWidth() + 400.0;
            }
        });
        label.getStyleClass().addAll((Object[])new String[]{"line-1"});
        label.setWrapText(true);
        label.setAlignment(Pos.TOP_LEFT);
        GridPane.setVgrow((Node)label, (Priority)Priority.NEVER);
        Label label2 = new Label(commandLinksButtonType.getLongText());
        label2.getStyleClass().addAll((Object[])new String[]{"line-2"});
        label2.setWrapText(true);
        label2.setAlignment(Pos.TOP_LEFT);
        label2.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)label2, (Priority)Priority.SOMETIMES);
        Node node = commandLinksButtonType.getGraphic();
        Node node2 = node == null ? new ImageView(CommandLinksDialog.class.getResource("arrow-green-right.png").toExternalForm()) : node;
        Pane pane = new Pane(new Node[]{node2});
        pane.getStyleClass().add((Object)"graphic-container");
        GridPane.setValignment((Node)pane, (VPos)VPos.TOP);
        GridPane.setMargin((Node)pane, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        GridPane gridPane = new GridPane();
        gridPane.minWidthProperty().bind((ObservableValue)label.prefWidthProperty());
        gridPane.setMaxHeight(Double.MAX_VALUE);
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.getStyleClass().add((Object)"container");
        gridPane.add((Node)pane, 0, 0, 1, 2);
        gridPane.add((Node)label, 1, 0);
        gridPane.add((Node)label2, 1, 1);
        button.setGraphic((Node)gridPane);
        button.minWidthProperty().bind((ObservableValue)label.prefWidthProperty());
        if (commandLinksButtonType.isHidden) {
            button.setVisible(false);
            button.setPrefHeight(1.0);
        }
        return button;
    }

    public static class CommandLinksButtonType {
        private final ButtonType buttonType;
        private final String longText;
        private final Node graphic;
        private boolean isHidden = false;

        public CommandLinksButtonType(String string, boolean bl2) {
            this(new ButtonType(string, CommandLinksButtonType.buildButtonData(bl2)), null);
        }

        public CommandLinksButtonType(String string, String string2, boolean bl2) {
            this(new ButtonType(string, CommandLinksButtonType.buildButtonData(bl2)), string2, null);
        }

        public CommandLinksButtonType(String string, String string2, Node node, boolean bl2) {
            this(new ButtonType(string, CommandLinksButtonType.buildButtonData(bl2)), string2, node);
        }

        private CommandLinksButtonType(ButtonType buttonType) {
            this(buttonType, null);
        }

        private CommandLinksButtonType(ButtonType buttonType, String string) {
            this(buttonType, string, null);
        }

        private CommandLinksButtonType(ButtonType buttonType, String string, Node node) {
            this.buttonType = buttonType;
            this.longText = string;
            this.graphic = node;
        }

        private static ButtonBar.ButtonData buildButtonData(boolean bl2) {
            return bl2 ? ButtonBar.ButtonData.OK_DONE : ButtonBar.ButtonData.OTHER;
        }

        private static CommandLinksButtonType buildHiddenCancelLink() {
            CommandLinksButtonType commandLinksButtonType = new CommandLinksButtonType(new ButtonType("", ButtonBar.ButtonData.CANCEL_CLOSE));
            commandLinksButtonType.isHidden = true;
            return commandLinksButtonType;
        }

        public ButtonType getButtonType() {
            return this.buttonType;
        }

        public Node getGraphic() {
            return this.graphic;
        }

        public String getLongText() {
            return this.longText;
        }
    }
}

