/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.filter.filtereditor;

import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import org.controlsfx.control.tableview2.FilteredTableColumn;
import org.controlsfx.control.tableview2.filter.filtereditor.SouthFilter;
import org.controlsfx.control.tableview2.filter.filtermenubutton.FilterMenuButton;

public class FilterEditor<S, T>
extends ComboBox<T> {
    private static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private final FilteredTableColumn<S, T> tableColumn;
    private final ObservableList<T> filterValues;
    private final ListChangeListener<S> itemsListener = change -> this.loadItems();
    private final WeakListChangeListener<S> weakListChangeListener = new WeakListChangeListener(this.itemsListener);
    private final ChangeListener<String> editorListener = (observableValue, string, string2) -> {
        if (this.getTableColumn() == null || this.getTableColumn().getTableView() == null) {
            return;
        }
        ObservableList observableList = this.getTableColumn().getTableView().getItems();
        if (observableList != null) {
            observableList.removeListener(this.weakListChangeListener);
        }
        this.updatePredicate((String)string2);
        if (observableList != null) {
            observableList.addListener(this.weakListChangeListener);
        }
    };
    private final WeakChangeListener<String> weakEditorListener = new WeakChangeListener(this.editorListener);
    private final ChangeListener<ObservableList<S>> itemsPropertyListener = (observableValue, observableList, observableList2) -> {
        if (observableList != null) {
            observableList.removeListener(this.weakListChangeListener);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakListChangeListener);
        }
        Platform.runLater(() -> this.loadItems());
    };
    private final WeakChangeListener<ObservableList<S>> weakItemsPropertyListener = new WeakChangeListener(this.itemsPropertyListener);
    private InvalidationListener parentListener;
    private WeakInvalidationListener weakParentListener;
    private InvalidationListener tableListener;
    private WeakInvalidationListener weakTableListener;
    private FilterMenuButton menuButton;
    private final ChangeListener<Boolean> menuButtonListener = (observableValue, bl2, bl3) -> {
        if (!bl3.booleanValue() && bl2.booleanValue()) {
            this.updatePredicate(this.getEditor().getText());
        }
    };
    private final WeakChangeListener<Boolean> weakMenuButtonListener = new WeakChangeListener(this.menuButtonListener);

    public FilterEditor(FilteredTableColumn<S, T> filteredTableColumn) {
        this.tableColumn = filteredTableColumn;
        this.filterValues = FXCollections.observableArrayList();
        if (this.getParent() != null) {
            this.setMenuButton();
        } else {
            this.parentListener = observable -> {
                if (this.getParent() != null) {
                    this.setMenuButton();
                    this.parentProperty().removeListener((InvalidationListener)this.weakParentListener);
                }
            };
            this.weakParentListener = new WeakInvalidationListener(this.parentListener);
            this.parentProperty().addListener((InvalidationListener)this.weakParentListener);
        }
        this.getStyleClass().add((Object)"filter-editor");
        if (filteredTableColumn.getTableView() != null) {
            this.addItemsListeners();
        } else {
            this.tableListener = observable -> {
                if (filteredTableColumn.getTableView() != null) {
                    this.addItemsListeners();
                    this.tableColumn.tableViewProperty().removeListener((InvalidationListener)this.weakTableListener);
                }
            };
            this.weakTableListener = new WeakInvalidationListener(this.tableListener);
            this.tableColumn.tableViewProperty().addListener((InvalidationListener)this.weakTableListener);
        }
        this.setItems(this.filterValues);
        this.setEditable(true);
        this.setOnAction(actionEvent -> actionEvent.consume());
        this.getEditor().textProperty().addListener(this.weakEditorListener);
    }

    private void setMenuButton() {
        this.menuButton = ((SouthFilter)this.getParent()).getMenuButton();
        this.menuButton.showingProperty().addListener(this.weakMenuButtonListener);
    }

    private void addItemsListeners() {
        TableView tableView = this.tableColumn.getTableView();
        tableView.itemsProperty().addListener(this.weakItemsPropertyListener);
        tableView.getItems().addListener(this.weakListChangeListener);
        this.loadItems();
    }

    private void loadItems() {
        Object object2 = this.getValue();
        this.filterValues.clear();
        if (this.tableColumn != null && this.tableColumn.getTableView() != null && this.tableColumn.getTableView().getItems() != null) {
            this.tableColumn.getTableView().getItems().stream().filter(object -> this.tableColumn.getCellData(object) != null).map(arg_0 -> this.tableColumn.getCellData(arg_0)).distinct().forEach(arg_0 -> this.filterValues.add(arg_0));
            this.setValue(object2);
        } else {
            this.setValue(null);
        }
    }

    private void updatePredicate(String string) {
        if (string == null || string.isEmpty()) {
            this.getTableColumn().setPredicate(null);
        } else {
            this.getTableColumn().setPredicate(this.menuButton.parse(string, this.getConverter()));
        }
        this.updateError();
    }

    private void updateError() {
        String string = this.getEditor().getText();
        if (string == null || string.isEmpty()) {
            this.setTooltip(null);
            this.getEditor().pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
        } else {
            String string2 = this.menuButton.getErrorMessage();
            if (string2 == null || string2.isEmpty()) {
                this.setTooltip(null);
                this.getEditor().pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
            } else {
                this.setTooltip(new Tooltip(string2));
                this.getEditor().pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
            }
        }
    }

    public FilteredTableColumn<S, T> getTableColumn() {
        return this.tableColumn;
    }

    public void cancelFilter() {
        this.setValue(null);
    }

    protected double computeMaxWidth(double d2) {
        return Double.MAX_VALUE;
    }
}

