/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.BreadCrumbBarSkin;
import java.util.UUID;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.util.Callback;
import org.controlsfx.control.ControlsFXControl;

public class BreadCrumbBar<T>
extends ControlsFXControl {
    private static final String STYLE_CLASS_FIRST = "first";
    private final Callback<TreeItem<T>, Button> defaultCrumbNodeFactory = new Callback<TreeItem<T>, Button>(){

        public Button call(TreeItem<T> treeItem) {
            return new BreadCrumbButton(treeItem.getValue() != null ? treeItem.getValue().toString() : "");
        }
    };
    private final ObjectProperty<TreeItem<T>> selectedCrumb = new SimpleObjectProperty((Object)this, "selectedCrumb");
    private final BooleanProperty autoNavigation = new SimpleBooleanProperty((Object)this, "autoNavigationEnabled", true);
    private final ObjectProperty<Callback<TreeItem<T>, Button>> crumbFactory = new SimpleObjectProperty((Object)this, "crumbFactory");
    private ObjectProperty<EventHandler<BreadCrumbActionEvent<T>>> onCrumbAction = new ObjectPropertyBase<EventHandler<BreadCrumbActionEvent<T>>>(){

        protected void invalidated() {
            BreadCrumbBar.this.setEventHandler(BreadCrumbActionEvent.CRUMB_ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return BreadCrumbBar.this;
        }

        public String getName() {
            return "onCrumbAction";
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "bread-crumb-bar";

    public static <T> TreeItem<T> buildTreeModel(T ... TArray) {
        TreeItem treeItem = null;
        for (T t2 : TArray) {
            TreeItem treeItem2 = new TreeItem(t2);
            if (treeItem == null) {
                treeItem = treeItem2;
                continue;
            }
            treeItem.getChildren().add((Object)treeItem2);
            treeItem = treeItem2;
        }
        return treeItem;
    }

    public BreadCrumbBar() {
        this(null);
    }

    public BreadCrumbBar(TreeItem<T> treeItem) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setSelectedCrumb(treeItem);
        this.setCrumbFactory(this.defaultCrumbNodeFactory);
    }

    public final ObjectProperty<TreeItem<T>> selectedCrumbProperty() {
        return this.selectedCrumb;
    }

    public final TreeItem<T> getSelectedCrumb() {
        return (TreeItem)this.selectedCrumb.get();
    }

    public final void setSelectedCrumb(TreeItem<T> treeItem) {
        this.selectedCrumb.set(treeItem);
    }

    public final BooleanProperty autoNavigationEnabledProperty() {
        return this.autoNavigation;
    }

    public final boolean isAutoNavigationEnabled() {
        return this.autoNavigation.get();
    }

    public final void setAutoNavigationEnabled(boolean bl2) {
        this.autoNavigation.set(bl2);
    }

    public final ObjectProperty<Callback<TreeItem<T>, Button>> crumbFactoryProperty() {
        return this.crumbFactory;
    }

    public final void setCrumbFactory(Callback<TreeItem<T>, Button> callback) {
        if (callback == null) {
            callback = this.defaultCrumbNodeFactory;
        }
        this.crumbFactoryProperty().set(callback);
    }

    public final Callback<TreeItem<T>, Button> getCrumbFactory() {
        return (Callback)this.crumbFactory.get();
    }

    public final ObjectProperty<EventHandler<BreadCrumbActionEvent<T>>> onCrumbActionProperty() {
        return this.onCrumbAction;
    }

    public final void setOnCrumbAction(EventHandler<BreadCrumbActionEvent<T>> eventHandler) {
        this.onCrumbActionProperty().set(eventHandler);
    }

    public final EventHandler<BreadCrumbActionEvent<T>> getOnCrumbAction() {
        return (EventHandler)this.onCrumbActionProperty().get();
    }

    protected Skin<?> createDefaultSkin() {
        return new BreadCrumbBarSkin(this);
    }

    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(BreadCrumbBar.class, "breadcrumbbar.css");
    }

    public static class BreadCrumbButton
    extends Button {
        private final ObjectProperty<Boolean> first = new SimpleObjectProperty((Object)this, "first");
        private final double arrowWidth = 5.0;
        private final double arrowHeight = 20.0;

        public BreadCrumbButton(String string) {
            this(string, null);
        }

        public BreadCrumbButton(String string, Node node) {
            super(string, node);
            this.first.set((Object)false);
            this.getStyleClass().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    this.updateShape();
                }
            });
            this.updateShape();
        }

        private void updateShape() {
            this.setShape((Shape)this.createButtonShape());
        }

        public double getArrowWidth() {
            return 5.0;
        }

        private Path createButtonShape() {
            ArcTo arcTo;
            Path path = new Path();
            MoveTo moveTo = new MoveTo(0.0, 0.0);
            path.getElements().add((Object)moveTo);
            HLineTo hLineTo = new HLineTo();
            hLineTo.xProperty().bind((ObservableValue)this.widthProperty().subtract(5.0));
            path.getElements().add((Object)hLineTo);
            LineTo lineTo = new LineTo();
            lineTo.xProperty().bind((ObservableValue)hLineTo.xProperty().add(5.0));
            lineTo.setY(10.0);
            path.getElements().add((Object)lineTo);
            LineTo lineTo2 = new LineTo();
            lineTo2.xProperty().bind((ObservableValue)hLineTo.xProperty());
            lineTo2.setY(20.0);
            path.getElements().add((Object)lineTo2);
            HLineTo hLineTo2 = new HLineTo(0.0);
            path.getElements().add((Object)hLineTo2);
            if (!this.getStyleClass().contains((Object)BreadCrumbBar.STYLE_CLASS_FIRST)) {
                arcTo = new LineTo(5.0, 10.0);
                path.getElements().add((Object)arcTo);
            } else {
                arcTo = new ArcTo();
                arcTo.setSweepFlag(true);
                arcTo.setX(0.0);
                arcTo.setY(0.0);
                arcTo.setRadiusX(15.0);
                arcTo.setRadiusY(15.0);
                path.getElements().add((Object)arcTo);
            }
            arcTo = new ClosePath();
            path.getElements().add((Object)arcTo);
            path.setFill((Paint)Color.BLACK);
            return path;
        }
    }

    public static class BreadCrumbActionEvent<TE>
    extends Event {
        public static final EventType<BreadCrumbActionEvent<?>> CRUMB_ACTION = new EventType("CRUMB_ACTION" + UUID.randomUUID().toString());
        private final TreeItem<TE> selectedCrumb;

        public BreadCrumbActionEvent(TreeItem<TE> treeItem) {
            super(CRUMB_ACTION);
            this.selectedCrumb = treeItem;
        }

        public TreeItem<TE> getSelectedCrumb() {
            return this.selectedCrumb;
        }
    }
}

