/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;

public class UnsafeBufferPosition
extends Position {
    private boolean isClosed = false;
    private final int counterId;
    private final long addressOffset;
    private final byte[] byteArray;
    private final CountersManager countersManager;
    private final ByteBuffer byteBuffer;

    public UnsafeBufferPosition(UnsafeBuffer unsafeBuffer, int n2) {
        this(unsafeBuffer, n2, null);
    }

    public UnsafeBufferPosition(UnsafeBuffer unsafeBuffer, int n2, CountersManager countersManager) {
        this.counterId = n2;
        this.countersManager = countersManager;
        this.byteArray = unsafeBuffer.byteArray();
        this.byteBuffer = unsafeBuffer.byteBuffer();
        int n3 = CountersManager.counterOffset(n2);
        unsafeBuffer.boundsCheck(n3, 8);
        this.addressOffset = unsafeBuffer.addressOffset() + (long)n3;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public long get() {
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset);
    }

    @Override
    public long getVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset);
    }

    @Override
    public void set(long l2) {
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset, l2);
    }

    @Override
    public void setOrdered(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, l2);
    }

    @Override
    public void setVolatile(long l2) {
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset, l2);
    }

    @Override
    public boolean proposeMax(long l2) {
        boolean bl2 = false;
        byte[] byArray = this.byteArray;
        long l3 = this.addressOffset;
        if (UnsafeAccess.UNSAFE.getLong(byArray, l3) < l2) {
            UnsafeAccess.UNSAFE.putLong(byArray, l3, l2);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean proposeMaxOrdered(long l2) {
        boolean bl2 = false;
        byte[] byArray = this.byteArray;
        long l3 = this.addressOffset;
        if (UnsafeAccess.UNSAFE.getLong(byArray, l3) < l2) {
            UnsafeAccess.UNSAFE.putOrderedLong(byArray, l3, l2);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.countersManager) {
                this.countersManager.free(this.counterId);
            }
        }
    }

    public String toString() {
        return "UnsafeBufferPosition{isClosed=" + this.isClosed() + ", counterId=" + this.counterId + ", value=" + (this.isClosed() ? -1L : this.getVolatile()) + "}";
    }
}

