/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.ringbuffer;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.ControlledMessageHandler;
import org.agrona.concurrent.MemoryAccess;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.ringbuffer.RecordDescriptor;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public final class OneToOneRingBuffer
implements RingBuffer {
    public static final int MIN_CAPACITY = 16;
    private final int capacity;
    private final int maxMsgLength;
    private final int tailPositionIndex;
    private final int headCachePositionIndex;
    private final int headPositionIndex;
    private final int correlationIdCounterIndex;
    private final int consumerHeartbeatIndex;
    private final AtomicBuffer buffer;

    public OneToOneRingBuffer(AtomicBuffer atomicBuffer) {
        this.capacity = RingBufferDescriptor.checkCapacity(atomicBuffer.capacity(), 16);
        atomicBuffer.verifyAlignment();
        this.buffer = atomicBuffer;
        this.maxMsgLength = 16 == this.capacity ? 0 : Math.max(8, this.capacity >> 3);
        this.tailPositionIndex = this.capacity + RingBufferDescriptor.TAIL_POSITION_OFFSET;
        this.headCachePositionIndex = this.capacity + RingBufferDescriptor.HEAD_CACHE_POSITION_OFFSET;
        this.headPositionIndex = this.capacity + RingBufferDescriptor.HEAD_POSITION_OFFSET;
        this.correlationIdCounterIndex = this.capacity + RingBufferDescriptor.CORRELATION_COUNTER_OFFSET;
        this.consumerHeartbeatIndex = this.capacity + RingBufferDescriptor.CONSUMER_HEARTBEAT_OFFSET;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean write(int n2, DirectBuffer directBuffer, int n3, int n4) {
        RecordDescriptor.checkTypeId(n2);
        this.checkMsgLength(n4);
        AtomicBuffer atomicBuffer = this.buffer;
        int n5 = n4 + 8;
        int n6 = this.claimCapacity(atomicBuffer, n5);
        if (-2 == n6) {
            return false;
        }
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n6), -n5);
        MemoryAccess.releaseFence();
        atomicBuffer.putBytes(RecordDescriptor.encodedMsgOffset(n6), directBuffer, n3, n4);
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n6), n2);
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n6), n5);
        return true;
    }

    @Override
    public int tryClaim(int n2, int n3) {
        RecordDescriptor.checkTypeId(n2);
        this.checkMsgLength(n3);
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = n3 + 8;
        int n5 = this.claimCapacity(atomicBuffer, n4);
        if (-2 == n5) {
            return n5;
        }
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n5), -n4);
        MemoryAccess.releaseFence();
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n5), n2);
        return RecordDescriptor.encodedMsgOffset(n5);
    }

    @Override
    public void commit(int n2) {
        int n3 = this.computeRecordIndex(n2);
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = this.verifyClaimedSpaceNotReleased(atomicBuffer, n3);
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n3), -n4);
    }

    @Override
    public void abort(int n2) {
        int n3 = this.computeRecordIndex(n2);
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = this.verifyClaimedSpaceNotReleased(atomicBuffer, n3);
        atomicBuffer.putInt(RecordDescriptor.typeOffset(n3), -1);
        atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n3), -n4);
    }

    @Override
    public int read(MessageHandler messageHandler) {
        return this.read(messageHandler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(MessageHandler messageHandler, int n2) {
        int n3;
        int n4 = 0;
        AtomicBuffer atomicBuffer = this.buffer;
        int n5 = this.headPositionIndex;
        long l2 = atomicBuffer.getLong(n5);
        int n6 = this.capacity;
        int n7 = (int)l2 & n6 - 1;
        int n8 = n6 - n7;
        try {
            int n9;
            for (n3 = 0; n3 < n8 && n4 < n2; n3 += BitUtil.align(n9, 8)) {
                int n10 = n7 + n3;
                n9 = atomicBuffer.getIntVolatile(RecordDescriptor.lengthOffset(n10));
                if (n9 > 0) continue;
                break;
            }
        }
        finally {
            if (n3 > 0) {
                atomicBuffer.putLongOrdered(n5, l2 + (long)n3);
            }
        }
        return n4;
    }

    @Override
    public int controlledRead(ControlledMessageHandler controlledMessageHandler) {
        return this.controlledRead(controlledMessageHandler, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int controlledRead(ControlledMessageHandler controlledMessageHandler, int n2) {
        int n3 = 0;
        AtomicBuffer atomicBuffer = this.buffer;
        int n4 = this.headPositionIndex;
        long l2 = atomicBuffer.getLong(n4);
        int n5 = 0;
        int n6 = this.capacity;
        int n7 = (int)l2 & n6 - 1;
        int n8 = n6 - n7;
        try {
            while (n5 < n8 && n3 < n2) {
                int n9 = n7 + n5;
                int n10 = atomicBuffer.getIntVolatile(RecordDescriptor.lengthOffset(n9));
                if (n10 <= 0) {
                    break;
                }
                int n11 = BitUtil.align(n10, 8);
                n5 += n11;
                int n12 = atomicBuffer.getInt(RecordDescriptor.typeOffset(n9));
                if (-1 == n12) continue;
                ControlledMessageHandler.Action action = controlledMessageHandler.onMessage(n12, atomicBuffer, n9 + 8, n10 - 8);
                if (ControlledMessageHandler.Action.ABORT == action) {
                    n5 -= n11;
                    break;
                }
                ++n3;
                if (ControlledMessageHandler.Action.BREAK == action) {
                    break;
                }
                if (ControlledMessageHandler.Action.COMMIT != action) continue;
                atomicBuffer.putLongOrdered(n4, l2 + (long)n5);
                n7 += n5;
                l2 += (long)n5;
                n5 = 0;
            }
        }
        finally {
            if (n5 > 0) {
                atomicBuffer.putLongOrdered(n4, l2 + (long)n5);
            }
        }
        return n3;
    }

    @Override
    public int maxMsgLength() {
        return this.maxMsgLength;
    }

    @Override
    public long nextCorrelationId() {
        return this.buffer.getAndAddLong(this.correlationIdCounterIndex, 1L);
    }

    @Override
    public AtomicBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void consumerHeartbeatTime(long l2) {
        this.buffer.putLongOrdered(this.consumerHeartbeatIndex, l2);
    }

    @Override
    public long consumerHeartbeatTime() {
        return this.buffer.getLongVolatile(this.consumerHeartbeatIndex);
    }

    @Override
    public long producerPosition() {
        return this.buffer.getLongVolatile(this.tailPositionIndex);
    }

    @Override
    public long consumerPosition() {
        return this.buffer.getLongVolatile(this.headPositionIndex);
    }

    @Override
    public int size() {
        long l2;
        long l3;
        AtomicBuffer atomicBuffer = this.buffer;
        int n2 = this.headPositionIndex;
        int n3 = this.tailPositionIndex;
        long l4 = atomicBuffer.getLongVolatile(n2);
        do {
            l3 = l4;
            l2 = atomicBuffer.getLongVolatile(n3);
        } while ((l4 = atomicBuffer.getLongVolatile(n2)) != l3);
        long l5 = l2 - l4;
        if (l5 < 0L) {
            return 0;
        }
        if (l5 > (long)this.capacity) {
            return this.capacity;
        }
        return (int)l5;
    }

    @Override
    public boolean unblock() {
        return false;
    }

    private void checkMsgLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid message length=" + n2);
        }
        if (n2 > this.maxMsgLength) {
            throw new IllegalArgumentException("encoded message exceeds maxMsgLength=" + this.maxMsgLength + ", length=" + n2);
        }
    }

    private int claimCapacity(AtomicBuffer atomicBuffer, int n2) {
        int n3 = BitUtil.align(n2, 8);
        int n4 = n3 + 8;
        int n5 = this.capacity;
        int n6 = this.tailPositionIndex;
        int n7 = this.headCachePositionIndex;
        int n8 = n5 - 1;
        long l2 = atomicBuffer.getLong(n7);
        long l3 = atomicBuffer.getLong(n6);
        int n9 = n5 - (int)(l3 - l2);
        if (n4 > n9) {
            l2 = atomicBuffer.getLongVolatile(this.headPositionIndex);
            if (n4 > n5 - (int)(l3 - l2)) {
                return -2;
            }
            atomicBuffer.putLong(n7, l2);
        }
        int n10 = 0;
        int n11 = (int)l3 & n8;
        int n12 = n5 - n11;
        int n13 = n11;
        long l4 = l3 + (long)n3;
        if (n3 == n12) {
            atomicBuffer.putLongOrdered(n6, l4);
            atomicBuffer.putLong(0, 0L);
            return n11;
        }
        if (n4 > n12) {
            n13 = 0;
            int n14 = (int)l2 & n8;
            if (n4 > n14) {
                l2 = atomicBuffer.getLongVolatile(this.headPositionIndex);
                n14 = (int)l2 & n8;
                if (n4 > n14) {
                    n13 = -2;
                    l4 = l3;
                }
                atomicBuffer.putLong(n7, l2);
            }
            n10 = n12;
            l4 += (long)n10;
        }
        atomicBuffer.putLongOrdered(n6, l4);
        if (0 != n10) {
            atomicBuffer.putLong(0, 0L);
            atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n11), -n10);
            MemoryAccess.releaseFence();
            atomicBuffer.putInt(RecordDescriptor.typeOffset(n11), -1);
            atomicBuffer.putIntOrdered(RecordDescriptor.lengthOffset(n11), n10);
        }
        if (-2 != n13) {
            atomicBuffer.putLong(n13 + n3, 0L);
        }
        return n13;
    }

    private int computeRecordIndex(int n2) {
        int n3 = n2 - 8;
        if (n3 < 0 || n3 > this.capacity - 8) {
            throw new IllegalArgumentException("invalid message index " + n2);
        }
        return n3;
    }

    private int verifyClaimedSpaceNotReleased(AtomicBuffer atomicBuffer, int n2) {
        int n3 = atomicBuffer.getInt(RecordDescriptor.lengthOffset(n2));
        if (n3 < 0) {
            return n3;
        }
        throw new IllegalStateException("claimed space previously " + (-1 == atomicBuffer.getInt(RecordDescriptor.typeOffset(n2)) ? "aborted" : "committed"));
    }
}

