/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import java.util.function.ToIntFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntFunction;
import org.agrona.collections.ObjIntConsumer;
import org.agrona.collections.ObjIntPredicate;
import org.agrona.collections.ObjectIntToIntFunction;

public class Object2IntHashMap<K>
implements Map<K, Integer> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private K[] keys;
    private int[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Object2IntHashMap(int n2) {
        this(8, 0.65f, n2);
    }

    public Object2IntHashMap(int n2, float f2, int n3) {
        this(n2, f2, n3, true);
    }

    public Object2IntHashMap(int n2, float f2, int n3, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        int n4 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n4 * f2);
        this.missingValue = n3;
        this.shouldAvoidAllocation = bl2;
        this.keys = new Object[n4];
        this.values = new int[n4];
        Arrays.fill(this.values, n3);
    }

    public Object2IntHashMap(Object2IntHashMap<K> object2IntHashMap) {
        this.loadFactor = object2IntHashMap.loadFactor;
        this.resizeThreshold = object2IntHashMap.resizeThreshold;
        this.size = object2IntHashMap.size;
        this.missingValue = object2IntHashMap.missingValue;
        this.shouldAvoidAllocation = object2IntHashMap.shouldAvoidAllocation;
        this.keys = (Object[])object2IntHashMap.keys.clone();
        this.values = (int[])object2IntHashMap.values.clone();
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.missingValue != this.getValue(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue((Integer)object);
    }

    public boolean containsValue(int n2) {
        int[] nArray;
        if (this.missingValue == n2) {
            return false;
        }
        boolean bl2 = false;
        for (int n3 : nArray = this.values) {
            if (n2 != n3) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public int getOrDefault(Object object, int n2) {
        int n3 = this.getValue(object);
        return this.missingValue != n3 ? n3 : n2;
    }

    @Override
    public Integer get(Object object) {
        return this.valueOrNull(this.getValue(object));
    }

    public int getValue(K k2) {
        int n2;
        Objects.requireNonNull(k2);
        int n3 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        while (n3 != (n2 = nArray[n5]) && !Objects.equals(KArray[n5], k2)) {
            ++n5;
            n5 &= n4;
        }
        return n2;
    }

    public int computeIfAbsent(K k2, ToIntFunction<? super K> toIntFunction) {
        int n2;
        Objects.requireNonNull(k2);
        int n3 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        while (n3 != (n2 = nArray[n5])) {
            if (Objects.equals(KArray[n5], k2)) {
                return n2;
            }
            ++n5;
            n5 &= n4;
        }
        int n6 = toIntFunction.applyAsInt(k2);
        if (n3 != n6) {
            KArray[n5] = k2;
            nArray[n5] = n6;
            ++this.size;
            this.increaseCapacity();
        }
        return n6;
    }

    public int computeIfPresent(K k2, ObjectIntToIntFunction<? super K> objectIntToIntFunction) {
        int n2;
        Objects.requireNonNull(k2);
        int n3 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        while (n3 != (n2 = nArray[n5])) {
            if (Objects.equals(KArray[n5], k2)) {
                int n6;
                nArray[n5] = n6 = objectIntToIntFunction.apply(k2, n2);
                if (n3 == n6) {
                    KArray[n5] = null;
                    --this.size;
                    this.compactChain(n5);
                }
                return n6;
            }
            ++n5;
            n5 &= n4;
        }
        return n3;
    }

    public int compute(K k2, ObjectIntToIntFunction<? super K> objectIntToIntFunction) {
        int n2;
        Objects.requireNonNull(k2);
        int n3 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        while (n3 != (n2 = nArray[n5]) && !Objects.equals(KArray[n5], k2)) {
            ++n5;
            n5 &= n4;
        }
        int n6 = objectIntToIntFunction.apply(k2, n2);
        if (n3 != n6) {
            nArray[n5] = n6;
            if (n3 == n2) {
                KArray[n5] = k2;
                ++this.size;
                this.increaseCapacity();
            }
        } else if (n3 != n2) {
            KArray[n5] = null;
            nArray[n5] = n3;
            --this.size;
            this.compactChain(n5);
        }
        return n6;
    }

    public int merge(K k2, int n2, IntIntFunction intIntFunction) {
        int n3;
        int n4;
        Objects.requireNonNull(k2);
        Objects.requireNonNull(intIntFunction);
        int n5 = this.missingValue;
        if (n5 == n2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n6 = nArray.length - 1;
        int n7 = Hashing.hash(k2, n6);
        while (n5 != (n4 = nArray[n7]) && !Objects.equals(KArray[n7], k2)) {
            ++n7;
            n7 &= n6;
        }
        int n8 = n3 = n5 == n4 ? n2 : intIntFunction.apply(n4, n2);
        if (n5 != n3) {
            KArray[n7] = k2;
            nArray[n7] = n3;
            if (n5 == n4) {
                KArray[n7] = k2;
                ++this.size;
                this.increaseCapacity();
            }
        } else {
            KArray[n7] = null;
            nArray[n7] = n5;
            --this.size;
            this.compactChain(n7);
        }
        return n3;
    }

    @Override
    public Integer put(K k2, Integer n2) {
        return this.valueOrNull(this.put(k2, (int)n2));
    }

    @Override
    public int put(K k2, int n2) {
        int n3;
        Objects.requireNonNull(k2);
        int n4 = this.missingValue;
        if (n4 == n2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n5 = nArray.length - 1;
        int n6 = Hashing.hash(k2, n5);
        while (n4 != (n3 = nArray[n6]) && !Objects.equals(KArray[n6], k2)) {
            ++n6;
            n6 &= n5;
        }
        if (n4 == n3) {
            ++this.size;
            KArray[n6] = k2;
        }
        nArray[n6] = n2;
        this.increaseCapacity();
        return n3;
    }

    @Override
    public Integer putIfAbsent(K k2, Integer n2) {
        return this.valueOrNull(this.putIfAbsent(k2, (int)n2));
    }

    @Override
    public int putIfAbsent(K k2, int n2) {
        int n3;
        Objects.requireNonNull(k2);
        int n4 = this.missingValue;
        if (n4 == n2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n5 = nArray.length - 1;
        int n6 = Hashing.hash(k2, n5);
        while (n4 != (n3 = nArray[n6])) {
            if (Objects.equals(KArray[n6], k2)) {
                return n3;
            }
            ++n6;
            n6 &= n5;
        }
        KArray[n6] = k2;
        nArray[n6] = n2;
        ++this.size;
        this.increaseCapacity();
        return n4;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove(object, (Integer)object2);
    }

    public boolean remove(Object object, int n2) {
        int n3;
        int n4 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n5 = nArray.length - 1;
        int n6 = Hashing.hash(object, n5);
        while (n4 != (n3 = nArray[n6])) {
            if (Objects.equals(KArray[n6], object)) {
                if (n2 != n3) break;
                KArray[n6] = null;
                nArray[n6] = n4;
                --this.size;
                this.compactChain(n6);
                return true;
            }
            ++n6;
            n6 &= n5;
        }
        return false;
    }

    @Override
    public Integer remove(Object object) {
        return this.valueOrNull(this.removeKey(object));
    }

    public int removeKey(K k2) {
        int n2;
        Objects.requireNonNull(k2);
        int n3 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(k2, n4);
        while (n3 != (n2 = nArray[n5])) {
            if (Objects.equals(KArray[n5], k2)) {
                KArray[n5] = null;
                nArray[n5] = n3;
                --this.size;
                this.compactChain(n5);
                break;
            }
            ++n5;
            n5 &= n4;
        }
        return n2;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> map) {
        for (Map.Entry<K, Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Object2IntHashMap<? extends K> object2IntHashMap) {
        int n2 = object2IntHashMap.missingValue;
        K[] KArray = object2IntHashMap.keys;
        int[] nArray = object2IntHashMap.values;
        int n3 = nArray.length;
        int n4 = object2IntHashMap.size;
        for (int i2 = 0; n4 > 0 && i2 < n3; ++i2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            this.put(KArray[i2], n5);
            --n4;
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder stringBuilder = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            stringBuilder.append(entryIterator.getKey()).append('=').append(entryIterator.getIntValue());
            if (!entryIterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n2 = this.missingValue;
        int n3 = object instanceof Object2IntHashMap ? ((Object2IntHashMap)object).missingValue : n2;
        int n4 = nArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            Object v2 = map.get(KArray[i2]);
            if (!(v2 instanceof Integer)) {
                return false;
            }
            int n6 = (Integer)v2;
            if (n3 != n6 && n5 == n6) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (this.missingValue == n4) continue;
            n2 += KArray[i2].hashCode() ^ Integer.hashCode(n4);
        }
        return n2;
    }

    @Override
    public int replace(K k2, int n2) {
        int n3;
        Objects.requireNonNull(k2);
        int n4 = this.missingValue;
        if (n4 == n2) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n5 = nArray.length - 1;
        int n6 = Hashing.hash(k2, n5);
        while (n4 != (n3 = nArray[n6])) {
            if (Objects.equals(KArray[n6], k2)) {
                nArray[n6] = n2;
                return n3;
            }
            ++n6;
            n6 &= n5;
        }
        return n4;
    }

    @Override
    public boolean replace(K k2, int n2, int n3) {
        int n4;
        Objects.requireNonNull(k2);
        int n5 = this.missingValue;
        if (n5 == n3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n6 = nArray.length - 1;
        int n7 = Hashing.hash(k2, n6);
        while (n5 != (n4 = nArray[n7])) {
            if (Objects.equals(KArray[n7], k2)) {
                if (n2 != n4) break;
                nArray[n7] = n3;
                return true;
            }
            ++n7;
            n7 &= n6;
        }
        return false;
    }

    public void replaceAllInt(ObjectIntToIntFunction<? super K> objectIntToIntFunction) {
        Objects.requireNonNull(objectIntToIntFunction);
        int n2 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n3 = nArray.length;
        int n4 = this.size;
        for (int i2 = 0; n4 > 0 && i2 < n3; ++i2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            int n6 = objectIntToIntFunction.apply(KArray[i2], n5);
            if (n2 == n6) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            nArray[i2] = n6;
            --n4;
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Integer> biConsumer) {
        this.forEachInt(biConsumer::accept);
    }

    public void forEachInt(ObjIntConsumer<? super K> objIntConsumer) {
        Objects.requireNonNull(objIntConsumer);
        int n2 = this.missingValue;
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n3 = nArray.length;
        int n4 = this.size;
        for (int i2 = 0; n4 > 0 && i2 < n3; ++i2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            objIntConsumer.accept(KArray[i2], n5);
            --n4;
        }
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.values.length << 1;
            if (n2 < 0) {
                throw new IllegalStateException("max capacity reached at size=" + this.size);
            }
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        Object[] objectArray = new Object[n2];
        int[] nArray = new int[n2];
        Arrays.fill(nArray, this.missingValue);
        K[] KArray = this.keys;
        int[] nArray2 = this.values;
        int n4 = nArray2.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = nArray2[i2];
            if (this.missingValue == n5) continue;
            K k2 = KArray[i2];
            int n6 = Hashing.hash(k2, n3);
            while (this.missingValue != nArray[n6]) {
                ++n6;
                n6 &= n3;
            }
            objectArray[n6] = k2;
            nArray[n6] = n5;
        }
        this.keys = objectArray;
        this.values = nArray;
    }

    private void compactChain(int n2) {
        K[] KArray = this.keys;
        int[] nArray = this.values;
        int n3 = nArray.length - 1;
        int n4 = n2;
        while (true) {
            ++n4;
            int n5 = nArray[n4 &= n3];
            if (this.missingValue == n5) break;
            K k2 = KArray[n4];
            int n6 = Hashing.hash(k2, n3);
            if ((n4 >= n6 || n6 > n2 && n2 > n4) && (n6 > n2 || n2 > n4)) continue;
            KArray[n2] = k2;
            nArray[n2] = n5;
            KArray[n4] = null;
            nArray[n4] = this.missingValue;
            n2 = n4;
        }
    }

    private Integer valueOrNull(int n2) {
        return n2 == this.missingValue ? null : Integer.valueOf(n2);
    }

    public final class KeySet
    extends AbstractSet<K> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Object2IntHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return Object2IntHashMap.this.missingValue != Object2IntHashMap.this.removeKey(object);
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Integer> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Object2IntHashMap.this.containsValue(object);
        }

        public boolean contains(int n2) {
            return Object2IntHashMap.this.containsValue(n2);
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }

        public boolean removeIfInt(IntPredicate intPredicate) {
            boolean bl2 = false;
            ValueIterator valueIterator = this.iterator();
            while (valueIterator.hasNext()) {
                if (!intPredicate.test(valueIterator.nextInt())) continue;
                valueIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<K, Integer>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Integer n2 = Object2IntHashMap.this.get(entry.getKey());
            return n2 != null && n2.equals(entry.getValue());
        }

        public boolean removeIfInt(ObjIntPredicate<? super K> objIntPredicate) {
            boolean bl2 = false;
            EntryIterator entryIterator = this.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.findNext();
                if (!objIntPredicate.test(entryIterator.getKey(), entryIterator.getIntValue())) continue;
                entryIterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= Object2IntHashMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), Object2IntHashMap.this.size);
            EntryIterator entryIterator = this.iterator();
            for (int i2 = 0; i2 < TArray2.length; ++i2) {
                if (!entryIterator.hasNext()) {
                    TArray2[i2] = null;
                    break;
                }
                entryIterator.next();
                TArray2[i2] = entryIterator.allocateDuplicateEntry();
            }
            return TArray2;
        }
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<K, Integer>>
    implements Map.Entry<K, Integer> {
        @Override
        public Map.Entry<K, Integer> next() {
            this.findNext();
            if (Object2IntHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, Integer> allocateDuplicateEntry() {
            return new MapEntry(this.getKey(), this.getIntValue());
        }

        @Override
        public K getKey() {
            return Object2IntHashMap.this.keys[this.position()];
        }

        public int getIntValue() {
            return Object2IntHashMap.this.values[this.position()];
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        @Override
        public Integer setValue(Integer n2) {
            return this.setValue((int)n2);
        }

        @Override
        public int setValue(int n2) {
            if (Object2IntHashMap.this.missingValue == n2) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int n3 = this.position();
            int n4 = Object2IntHashMap.this.values[n3];
            Object2IntHashMap.this.values[n3] = n2;
            return n4;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ Integer.hashCode(this.getIntValue());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && entry.getValue() instanceof Integer && this.getIntValue() == ((Integer)entry.getValue()).intValue();
        }

        public final class MapEntry
        implements Map.Entry<K, Integer> {
            private final K k;
            private int v;

            public MapEntry(K k2, int n2) {
                this.k = k2;
                this.v = n2;
            }

            @Override
            public K getKey() {
                return this.k;
            }

            @Override
            public Integer getValue() {
                return this.v;
            }

            @Override
            public Integer setValue(Integer n2) {
                Integer n3 = Object2IntHashMap.this.put(this.k, n2);
                this.v = n2;
                return n3;
            }

            @Override
            public int hashCode() {
                return this.getKey().hashCode() ^ Integer.hashCode(this.v);
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return Objects.equals(this.getKey(), entry.getKey()) && entry.getValue() instanceof Integer && this.v == (Integer)entry.getValue();
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeyIterator
    extends AbstractIterator<K> {
        @Override
        public K next() {
            this.findNext();
            return Object2IntHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Object2IntHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Object2IntHashMap.this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = Object2IntHashMap.this.missingValue;
            int[] nArray = Object2IntHashMap.this.values;
            int n3 = nArray.length - 1;
            for (int i2 = this.posCounter - 1; i2 >= this.stopCounter; --i2) {
                int n4 = i2 & n3;
                if (n2 == nArray[n4]) continue;
                this.posCounter = i2;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            int n2;
            if (this.isPositionValid) {
                n2 = this.position();
                Object2IntHashMap.this.values[n2] = Object2IntHashMap.this.missingValue;
                Object2IntHashMap.this.keys[n2] = null;
                --Object2IntHashMap.this.size;
            } else {
                throw new IllegalStateException();
            }
            Object2IntHashMap.this.compactChain(n2);
            this.isPositionValid = false;
        }

        final void reset() {
            int n2;
            this.remaining = Object2IntHashMap.this.size;
            int[] nArray = Object2IntHashMap.this.values;
            int n3 = n2 = nArray.length;
            if (Object2IntHashMap.this.missingValue != nArray[n2 - 1]) {
                for (n3 = 0; n3 < n2 && Object2IntHashMap.this.missingValue != nArray[n3]; ++n3) {
                }
            }
            this.stopCounter = n3;
            this.posCounter = n3 + n2;
            this.isPositionValid = false;
        }
    }
}

