/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongObjConsumer;
import org.agrona.collections.LongObjPredicate;
import org.agrona.collections.LongObjectToObjectFunction;

public class Long2ObjectHashMap<V>
implements Map<Long, V> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private long[] keys;
    private Object[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Long2ObjectHashMap() {
        this(8, 0.65f, true);
    }

    public Long2ObjectHashMap(int n2, float f2) {
        this(n2, f2, true);
    }

    public Long2ObjectHashMap(int n2, float f2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.shouldAvoidAllocation = bl2;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n3 * f2);
        this.keys = new long[n3];
        this.values = new Object[n3];
    }

    public Long2ObjectHashMap(Long2ObjectHashMap<V> long2ObjectHashMap) {
        this.loadFactor = long2ObjectHashMap.loadFactor;
        this.resizeThreshold = long2ObjectHashMap.resizeThreshold;
        this.size = long2ObjectHashMap.size;
        this.shouldAvoidAllocation = long2ObjectHashMap.shouldAvoidAllocation;
        this.keys = (long[])long2ObjectHashMap.keys.clone();
        this.values = (Object[])long2ObjectHashMap.values.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super V> biConsumer) {
        this.forEachLong(biConsumer::accept);
    }

    @Deprecated
    public void longForEach(LongObjConsumer<V> longObjConsumer) {
        this.forEachLong(longObjConsumer);
    }

    public void forEachLong(LongObjConsumer<V> longObjConsumer) {
        Objects.requireNonNull(longObjConsumer);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            longObjConsumer.accept(lArray[i2], this.unmapNullValue(object));
            --n3;
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey((Long)object);
    }

    public boolean containsKey(long l2) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        boolean bl2 = false;
        while (null != objectArray[n3]) {
            if (l2 == lArray[n3]) {
                bl2 = true;
                break;
            }
            ++n3;
            n3 &= n2;
        }
        return bl2;
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl2 = false;
        Object object2 = this.mapNullValue(object);
        if (null != object2) {
            Object[] objectArray = this.values;
            int n2 = objectArray.length;
            int n3 = this.size;
            for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
                Object object3 = objectArray[i2];
                if (null == object3) continue;
                if (Objects.equals(object3, object2)) {
                    bl2 = true;
                    break;
                }
                --n3;
            }
        }
        return bl2;
    }

    @Override
    public V get(Object object) {
        return this.get((Long)object);
    }

    public V get(long l2) {
        return this.unmapNullValue(this.getMapped(l2));
    }

    public V getOrDefault(long l2, V v2) {
        V v3 = this.getMapped(l2);
        return null != v3 ? this.unmapNullValue(v3) : v2;
    }

    protected V getMapped(long l2) {
        Object object;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3]) && l2 != lArray[n3]) {
            ++n3;
            n3 &= n2;
        }
        return (V)object;
    }

    @Override
    public V computeIfAbsent(Long l2, Function<? super Long, ? extends V> function) {
        return (V)this.computeIfAbsent((long)l2, function::apply);
    }

    public V computeIfAbsent(long l2, LongFunction<? extends V> longFunction) {
        Object object;
        Objects.requireNonNull(longFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3]) && l2 != lArray[n3]) {
            ++n3;
            n3 &= n2;
        }
        V v2 = this.unmapNullValue(object);
        if (null == v2 && (v2 = longFunction.apply(l2)) != null) {
            objectArray[n3] = v2;
            if (null == object) {
                lArray[n3] = l2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        }
        return v2;
    }

    @Override
    public V computeIfPresent(Long l2, BiFunction<? super Long, ? super V, ? extends V> biFunction) {
        return (V)this.computeIfPresent((long)l2, biFunction::apply);
    }

    public V computeIfPresent(long l2, LongObjectToObjectFunction<? super V, ? extends V> longObjectToObjectFunction) {
        Object object;
        Objects.requireNonNull(longObjectToObjectFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3]) && l2 != lArray[n3]) {
            ++n3;
            n3 &= n2;
        }
        V v2 = this.unmapNullValue(object);
        if (null != v2) {
            v2 = longObjectToObjectFunction.apply(l2, v2);
            objectArray[n3] = v2;
            if (null == v2) {
                --this.size;
                this.compactChain(n3);
            }
        }
        return v2;
    }

    @Override
    public V compute(Long l2, BiFunction<? super Long, ? super V, ? extends V> biFunction) {
        return (V)this.compute((long)l2, biFunction::apply);
    }

    public V compute(long l2, LongObjectToObjectFunction<? super V, ? extends V> longObjectToObjectFunction) {
        Object object;
        Objects.requireNonNull(longObjectToObjectFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3]) && l2 != lArray[n3]) {
            ++n3;
            n3 &= n2;
        }
        V v2 = longObjectToObjectFunction.apply(l2, this.unmapNullValue(object));
        if (null != v2) {
            objectArray[n3] = v2;
            if (null == object) {
                lArray[n3] = l2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != object) {
            objectArray[n3] = null;
            --this.size;
            this.compactChain(n3);
        }
        return v2;
    }

    @Override
    public V merge(Long l2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        return this.merge((long)l2, v2, biFunction);
    }

    @Override
    public V merge(long l2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v3;
        Object object;
        Objects.requireNonNull(v2);
        Objects.requireNonNull(biFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3]) && l2 != lArray[n3]) {
            ++n3;
            n3 &= n2;
        }
        V v4 = this.unmapNullValue(object);
        V v5 = v3 = null == v4 ? v2 : biFunction.apply(v4, v2);
        if (null != v3) {
            objectArray[n3] = v3;
            if (null == object) {
                lArray[n3] = l2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != object) {
            objectArray[n3] = null;
            --this.size;
            this.compactChain(n3);
        }
        return v3;
    }

    @Override
    public V put(Long l2, V v2) {
        return this.put((long)l2, v2);
    }

    @Override
    public V put(long l2, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3]) && l2 != lArray[n3]) {
            ++n3;
            n3 &= n2;
        }
        if (null == object) {
            ++this.size;
            lArray[n3] = l2;
        }
        objectArray[n3] = object2;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return this.unmapNullValue(object);
    }

    @Override
    public V remove(Object object) {
        return this.remove((Long)object);
    }

    public V remove(long l2) {
        Object object;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3])) {
            if (l2 == lArray[n3]) {
                objectArray[n3] = null;
                --this.size;
                this.compactChain(n3);
                break;
            }
            ++n3;
            n3 &= n2;
        }
        return this.unmapNullValue(object);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove((Long)object, object2);
    }

    public boolean remove(long l2, V v2) {
        Object object = this.mapNullValue(v2);
        if (null != object) {
            Object object2;
            long[] lArray = this.keys;
            Object[] objectArray = this.values;
            int n2 = objectArray.length - 1;
            int n3 = Hashing.hash(l2, n2);
            while (null != (object2 = objectArray[n3])) {
                if (l2 == lArray[n3]) {
                    if (!Objects.equals(this.unmapNullValue(object2), v2)) break;
                    objectArray[n3] = null;
                    --this.size;
                    this.compactChain(n3);
                    return true;
                }
                ++n3;
                n3 &= n2;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, null);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Long2ObjectHashMap<? extends V> long2ObjectHashMap) {
        EntryIterator entryIterator = long2ObjectHashMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            entryIterator.findNext();
            this.put(entryIterator.getLongKey(), (V)entryIterator.getValue());
        }
    }

    @Override
    public V putIfAbsent(long l2, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3]) && l2 != lArray[n3]) {
            ++n3;
            n3 &= n2;
        }
        V v3 = this.unmapNullValue(object);
        if (null == v3) {
            if (null == object) {
                ++this.size;
                lArray[n3] = l2;
            }
            objectArray[n3] = object2;
            if (this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return v3;
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder stringBuilder = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            stringBuilder.append(entryIterator.getLongKey()).append('=').append(this.unmapNullValue(entryIterator.getValue()));
            if (!entryIterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object v2;
            Object object2 = objectArray[i2];
            if (null == object2 || object2.equals(this.mapNullValue(v2 = map.get(lArray[i2])))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            n2 += Long.hashCode(lArray[i2]) ^ object.hashCode();
        }
        return n2;
    }

    protected Object mapNullValue(Object object) {
        return object;
    }

    protected V unmapNullValue(Object object) {
        return (V)object;
    }

    @Override
    public V replace(long l2, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3])) {
            if (l2 == lArray[n3]) {
                objectArray[n3] = object2;
                break;
            }
            ++n3;
            n3 &= n2;
        }
        return this.unmapNullValue(object);
    }

    @Override
    public boolean replace(long l2, V v2, V v3) {
        Object object;
        Object object2 = this.mapNullValue(v3);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.hash(l2, n2);
        while (null != (object = objectArray[n3])) {
            if (l2 == lArray[n3]) {
                if (!Objects.equals(this.unmapNullValue(object), v2)) break;
                objectArray[n3] = object2;
                return true;
            }
            ++n3;
            n3 &= n2;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super V, ? extends V> biFunction) {
        this.replaceAllLong(biFunction::apply);
    }

    public void replaceAllLong(LongObjectToObjectFunction<? super V, ? extends V> longObjectToObjectFunction) {
        Objects.requireNonNull(longObjectToObjectFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            Object object2 = this.mapNullValue(longObjectToObjectFunction.apply(lArray[i2], this.unmapNullValue(object)));
            Objects.requireNonNull(object2, "value cannot be null");
            objectArray[i2] = object2;
            --n3;
        }
    }

    private void increaseCapacity() {
        int n2 = this.values.length << 1;
        if (n2 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(n2);
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        long[] lArray = new long[n2];
        Object[] objectArray = new Object[n2];
        long[] lArray2 = this.keys;
        Object[] objectArray2 = this.values;
        int n4 = objectArray2.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object = objectArray2[i2];
            if (null == object) continue;
            long l2 = lArray2[i2];
            int n5 = Hashing.hash(l2, n3);
            while (null != objectArray[n5]) {
                ++n5;
                n5 &= n3;
            }
            lArray[n5] = l2;
            objectArray[n5] = object;
        }
        this.keys = lArray;
        this.values = objectArray;
    }

    private void compactChain(int n2) {
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = n2;
        while (true) {
            ++n4;
            Object object = objectArray[n4 &= n3];
            if (null == object) break;
            long l2 = lArray[n4];
            int n5 = Hashing.hash(l2, n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            lArray[n2] = l2;
            objectArray[n2] = object;
            objectArray[n4] = null;
            n2 = n4;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Long2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            long l2 = (Long)entry.getKey();
            Object v2 = Long2ObjectHashMap.this.getMapped(l2);
            return null != v2 && v2.equals(Long2ObjectHashMap.this.mapNullValue(entry.getValue()));
        }

        public boolean removeIfLong(LongObjPredicate<V> longObjPredicate) {
            boolean bl2 = false;
            EntryIterator entryIterator = this.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.findNext();
                if (!longObjPredicate.test(entryIterator.getLongKey(), entryIterator.getValue())) continue;
                entryIterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= Long2ObjectHashMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), Long2ObjectHashMap.this.size);
            EntryIterator entryIterator = this.iterator();
            for (int i2 = 0; i2 < TArray2.length; ++i2) {
                if (!entryIterator.hasNext()) {
                    TArray2[i2] = null;
                    break;
                }
                entryIterator.next();
                TArray2[i2] = entryIterator.allocateDuplicateEntry();
            }
            return TArray2;
        }
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<Long, V>>
    implements Map.Entry<Long, V> {
        @Override
        public Map.Entry<Long, V> next() {
            this.findNext();
            if (Long2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Long, V> allocateDuplicateEntry() {
            return new MapEntry(this.getLongKey(), this.getValue());
        }

        @Override
        public Long getKey() {
            return this.getLongKey();
        }

        public long getLongKey() {
            return Long2ObjectHashMap.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Long2ObjectHashMap.this.unmapNullValue(Long2ObjectHashMap.this.values[this.position()]);
        }

        @Override
        public V setValue(V v2) {
            Object object = Long2ObjectHashMap.this.mapNullValue(v2);
            Objects.requireNonNull(object, "value cannot be null");
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int n2 = this.position();
            Object[] objectArray = Long2ObjectHashMap.this.values;
            Object object2 = objectArray[n2];
            objectArray[n2] = object;
            return object2;
        }

        public final class MapEntry
        implements Map.Entry<Long, V> {
            private final long k;
            private final V v;

            public MapEntry(long l2, V v2) {
                this.k = l2;
                this.v = v2;
            }

            @Override
            public Long getKey() {
                return this.k;
            }

            @Override
            public V getValue() {
                return this.v;
            }

            @Override
            public V setValue(V v2) {
                return Long2ObjectHashMap.this.put(this.k, v2);
            }

            @Override
            public int hashCode() {
                return Long.hashCode(EntryIterator.this.getLongKey()) ^ (null != this.v ? this.v.hashCode() : 0);
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return entry.getKey() != null && entry.getKey().equals(this.k) && (entry.getValue() == null && this.v == null || entry.getValue().equals(this.v));
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeySet
    extends AbstractSet<Long> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Long2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Long2ObjectHashMap.this.containsKey(object);
        }

        public boolean contains(long l2) {
            return Long2ObjectHashMap.this.containsKey(l2);
        }

        @Override
        public boolean remove(Object object) {
            return null != Long2ObjectHashMap.this.remove(object);
        }

        public boolean remove(long l2) {
            return null != Long2ObjectHashMap.this.remove(l2);
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }

        public boolean removeIfLong(LongPredicate longPredicate) {
            boolean bl2 = false;
            KeyIterator keyIterator = this.iterator();
            while (keyIterator.hasNext()) {
                if (!longPredicate.test(keyIterator.nextLong())) continue;
                keyIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Long2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Long2ObjectHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super V> consumer) {
            int n2 = Long2ObjectHashMap.this.size;
            Object[] objectArray = Long2ObjectHashMap.this.values;
            int n3 = objectArray.length;
            for (int i2 = 0; n2 > 0 && i2 < n3; ++i2) {
                Object object = objectArray[i2];
                if (null == object) continue;
                consumer.accept(Long2ObjectHashMap.this.unmapNullValue(object));
                --n2;
            }
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Long2ObjectHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Long2ObjectHashMap.this.unmapNullValue(Long2ObjectHashMap.this.values[this.position()]);
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Long2ObjectHashMap.this.values.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = Long2ObjectHashMap.this.values;
            int n2 = objectArray.length - 1;
            int n3 = this.stopCounter;
            for (int i2 = this.posCounter - 1; i2 >= n3; --i2) {
                int n4 = i2 & n2;
                if (null == objectArray[n4]) continue;
                this.posCounter = i2;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            int n2;
            if (this.isPositionValid) {
                n2 = this.position();
                Long2ObjectHashMap.this.values[n2] = null;
                --Long2ObjectHashMap.this.size;
            } else {
                throw new IllegalStateException();
            }
            Long2ObjectHashMap.this.compactChain(n2);
            this.isPositionValid = false;
        }

        final void reset() {
            int n2;
            this.remaining = Long2ObjectHashMap.this.size;
            Object[] objectArray = Long2ObjectHashMap.this.values;
            int n3 = n2 = objectArray.length;
            if (null != objectArray[n2 - 1]) {
                for (n3 = 0; n3 < n2 && null != objectArray[n3]; ++n3) {
                }
            }
            this.stopCounter = n3;
            this.posCounter = n3 + n2;
            this.isPositionValid = false;
        }
    }
}

