/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongConsumer;

public class Long2LongCounterMap {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long initialValue;
    private int resizeThreshold;
    private int size = 0;
    private long[] entries;

    public Long2LongCounterMap(long l2) {
        this(8, 0.65f, l2);
    }

    public Long2LongCounterMap(int n2, float f2, long l2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.initialValue = l2;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public long initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public long get(long l2) {
        long l3;
        long l4 = this.initialValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l4 != (l3 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongCounterMap.next(n3, n2);
        }
        return l3;
    }

    public long put(long l2, long l3) {
        long l4;
        long l5 = this.initialValue;
        if (l5 == l3) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l5 != (l4 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongCounterMap.next(n3, n2);
        }
        if (l5 == l4) {
            ++this.size;
            lArray[n3] = l2;
        }
        lArray[n3 + 1] = l3;
        this.increaseCapacity();
        return l4;
    }

    public long incrementAndGet(long l2) {
        return this.addAndGet(l2, 1L);
    }

    public long decrementAndGet(long l2) {
        return this.addAndGet(l2, -1L);
    }

    public long addAndGet(long l2, long l3) {
        return this.getAndAdd(l2, l3) + l3;
    }

    public long getAndIncrement(long l2) {
        return this.getAndAdd(l2, 1L);
    }

    public long getAndDecrement(long l2) {
        return this.getAndAdd(l2, -1L);
    }

    public long getAndAdd(long l2, long l3) {
        long l4;
        long l5 = this.initialValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l5 != (l4 = lArray[n3 + 1]) && l2 != lArray[n3]) {
            n3 = Long2LongCounterMap.next(n3, n2);
        }
        if (l3 != 0L) {
            long l6;
            lArray[n3 + 1] = l6 = l4 + l3;
            if (l5 == l4) {
                ++this.size;
                lArray[n3] = l2;
                this.increaseCapacity();
            } else if (l5 == l6) {
                --this.size;
                this.compactChain(n3);
            }
        }
        return l4;
    }

    public void forEach(LongLongConsumer longLongConsumer) {
        long l2 = this.initialValue;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        int n3 = this.size;
        for (int i2 = 1; n3 > 0 && i2 < n2; i2 += 2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            longLongConsumer.accept(lArray[i2 - 1], l3);
            --n3;
        }
    }

    public boolean containsKey(long l2) {
        return this.initialValue != this.get(l2);
    }

    public boolean containsValue(long l2) {
        boolean bl2 = false;
        if (this.initialValue != l2) {
            long[] lArray = this.entries;
            int n2 = lArray.length;
            for (int i2 = 1; i2 < n2; i2 += 2) {
                if (l2 != lArray[i2]) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public long computeIfAbsent(long l2, LongUnaryOperator longUnaryOperator) {
        long l3 = this.get(l2);
        if (this.initialValue == l3 && this.initialValue != (l3 = longUnaryOperator.applyAsLong(l2))) {
            this.put(l2, l3);
        }
        return l3;
    }

    public long remove(long l2) {
        long l3;
        long l4 = this.initialValue;
        long[] lArray = this.entries;
        int n2 = lArray.length - 1;
        int n3 = Hashing.evenHash(l2, n2);
        while (l4 != (l3 = lArray[n3 + 1])) {
            if (l2 == lArray[n3]) {
                lArray[n3 + 1] = l4;
                --this.size;
                this.compactChain(n3);
                break;
            }
            n3 = Long2LongCounterMap.next(n3, n2);
        }
        return l3;
    }

    public long minValue() {
        long l2 = this.initialValue;
        long l3 = 0 == this.size ? l2 : Long.MAX_VALUE;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            long l4 = lArray[i2];
            if (l2 == l4) continue;
            l3 = Math.min(l3, l4);
        }
        return l3;
    }

    public long maxValue() {
        long l2 = this.initialValue;
        long l3 = 0 == this.size ? l2 : Long.MIN_VALUE;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            long l4 = lArray[i2];
            if (l2 == l4) continue;
            l3 = Math.max(l3, l4);
        }
        return l3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        long l2 = this.initialValue;
        long[] lArray = this.entries;
        int n2 = lArray.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            stringBuilder.append(lArray[i2 - 1]).append('=').append(l3).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static int next(int n2, int n3) {
        return n2 + 2 & n3;
    }

    private void compactChain(int n2) {
        long l2;
        long l3 = this.initialValue;
        long[] lArray = this.entries;
        int n3 = lArray.length - 1;
        int n4 = n2;
        while (l3 != (l2 = lArray[(n4 = Long2LongCounterMap.next(n4, n3)) + 1])) {
            long l4 = lArray[n4];
            int n5 = Hashing.evenHash(l4, n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            lArray[n2] = l4;
            lArray[n2 + 1] = l2;
            lArray[n4 + 1] = l3;
            n2 = n4;
        }
    }

    private void capacity(int n2) {
        int n3 = n2 * 2;
        if (n3 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        this.entries = new long[n3];
        Arrays.fill(this.entries, this.initialValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.entries.length;
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        long l2 = this.initialValue;
        long[] lArray = this.entries;
        int n3 = lArray.length;
        this.capacity(n2);
        long[] lArray2 = this.entries;
        int n4 = lArray2.length - 1;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            long l4 = lArray[i2 - 1];
            int n5 = Hashing.evenHash(l4, n4);
            while (l2 != lArray2[n5 + 1]) {
                n5 = Long2LongCounterMap.next(n5, n4);
            }
            lArray2[n5] = l4;
            lArray2[n5 + 1] = l3;
        }
    }
}

