/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import org.agrona.AbstractMutableDirectBuffer;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;

public class ExpandableDirectByteBuffer
extends AbstractMutableDirectBuffer {
    public static final int MAX_BUFFER_LENGTH = 0x7FFFFFF7;
    public static final int INITIAL_CAPACITY = 128;
    private ByteBuffer byteBuffer;

    public ExpandableDirectByteBuffer() {
        this(128);
    }

    public ExpandableDirectByteBuffer(int n2) {
        this.byteBuffer = ByteBuffer.allocateDirect(n2);
        this.addressOffset = BufferUtil.address(this.byteBuffer);
        this.capacity = n2;
    }

    @Override
    public void wrap(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer byteBuffer, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer directBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer directBuffer, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long l2, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] byteArray() {
        return null;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public int wrapAdjustment() {
        return 0;
    }

    @Override
    public void checkLimit(int n2) {
        this.ensureCapacity(n2, 0);
    }

    public String toString() {
        return "ExpandableDirectByteBuffer{address=" + this.addressOffset + ", capacity=" + this.capacity + ", byteBuffer=" + this.byteBuffer + "}";
    }

    @Override
    protected final void ensureCapacity(int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException("negative value: index=" + n2 + " length=" + n3);
        }
        long l2 = (long)n2 + (long)n3;
        int n4 = this.capacity;
        if (l2 > (long)n4) {
            if (l2 > 0x7FFFFFF7L) {
                throw new IndexOutOfBoundsException("index=" + n2 + " length=" + n3 + " maxCapacity=2147483639");
            }
            int n5 = ExpandableDirectByteBuffer.calculateExpansion(n4, l2);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
            long l3 = BufferUtil.address(byteBuffer);
            this.getBytes(0, byteBuffer, 0, n4);
            this.byteBuffer = byteBuffer;
            this.addressOffset = l3;
            this.capacity = n5;
        }
    }

    private static int calculateExpansion(int n2, long l2) {
        long l3 = Math.max(n2, 2);
        while (l3 < l2) {
            if ((l3 += l3 >> 1) <= 0x7FFFFFF7L) continue;
            l3 = 0x7FFFFFF7L;
        }
        return (int)l3;
    }
}

