/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.util.Random;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Sink;
import okio.Timeout;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    final Buffer sinkBuffer;
    boolean writerClosed;
    final Buffer buffer = new Buffer();
    final FrameSink frameSink = new FrameSink();
    boolean activeWriter;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    WebSocketWriter(boolean bl2, BufferedSink bufferedSink, Random random) {
        if (bufferedSink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = bl2;
        this.sink = bufferedSink;
        this.sinkBuffer = bufferedSink.buffer();
        this.random = random;
        this.maskKey = bl2 ? new byte[4] : null;
        this.maskCursor = bl2 ? new Buffer.UnsafeCursor() : null;
    }

    void writePing(ByteString byteString) throws IOException {
        this.writeControlFrame(9, byteString);
    }

    void writePong(ByteString byteString) throws IOException {
        this.writeControlFrame(10, byteString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClose(int n2, ByteString byteString) throws IOException {
        ByteString byteString2 = ByteString.EMPTY;
        if (n2 != 0 || byteString != null) {
            if (n2 != 0) {
                WebSocketProtocol.validateCloseCode(n2);
            }
            Buffer buffer = new Buffer();
            buffer.writeShort(n2);
            if (byteString != null) {
                buffer.write(byteString);
            }
            byteString2 = buffer.readByteString();
        }
        try {
            this.writeControlFrame(8, byteString2);
        }
        finally {
            this.writerClosed = true;
        }
    }

    private void writeControlFrame(int n2, ByteString byteString) throws IOException {
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n3 = byteString.size();
        if ((long)n3 > 125L) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        int n4 = 0x80 | n2;
        this.sinkBuffer.writeByte(n4);
        int n5 = n3;
        if (this.isClient) {
            this.sinkBuffer.writeByte(n5 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (n3 > 0) {
                long l2 = this.sinkBuffer.size();
                this.sinkBuffer.write(byteString);
                this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(l2);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.writeByte(n5);
            this.sinkBuffer.write(byteString);
        }
        this.sink.flush();
    }

    Sink newMessageSink(int n2, long l2) {
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = n2;
        this.frameSink.contentLength = l2;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    void writeMessageFrame(int n2, long l2, boolean bl2, boolean bl3) throws IOException {
        int n3;
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n4 = n3 = bl2 ? n2 : 0;
        if (bl3) {
            n3 |= 0x80;
        }
        this.sinkBuffer.writeByte(n3);
        int n5 = 0;
        if (this.isClient) {
            n5 |= 0x80;
        }
        if (l2 <= 125L) {
            this.sinkBuffer.writeByte(n5 |= (int)l2);
        } else if (l2 <= 65535L) {
            this.sinkBuffer.writeByte(n5 |= 0x7E);
            this.sinkBuffer.writeShort((int)l2);
        } else {
            this.sinkBuffer.writeByte(n5 |= 0x7F);
            this.sinkBuffer.writeLong(l2);
        }
        if (this.isClient) {
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (l2 > 0L) {
                long l3 = this.sinkBuffer.size();
                this.sinkBuffer.write(this.buffer, l2);
                this.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(l3);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.write(this.buffer, l2);
        }
        this.sink.emit();
    }

    final class FrameSink
    implements Sink {
        int formatOpcode;
        long contentLength;
        boolean isFirstFrame;
        boolean closed;

        FrameSink() {
        }

        @Override
        public void write(Buffer buffer, long l2) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.buffer.write(buffer, l2);
            boolean bl2 = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
            long l3 = WebSocketWriter.this.buffer.completeSegmentByteCount();
            if (l3 > 0L && !bl2) {
                WebSocketWriter.this.writeMessageFrame(this.formatOpcode, l3, this.isFirstFrame, false);
                this.isFirstFrame = false;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, true);
            this.closed = true;
            WebSocketWriter.this.activeWriter = false;
        }
    }
}

