/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

public abstract class Lift {
    public void forwardTrans(double[] dArray) {
        int n2;
        for (int i2 = n2 = dArray.length; i2 > 1; i2 >>= 1) {
            this.split(dArray, i2);
            this.predict(dArray, i2, Direction.forward);
            this.update(dArray, i2, Direction.forward);
        }
    }

    public void inverseTrans(double[] dArray) {
        int n2 = dArray.length;
        for (int i2 = 2; i2 <= n2; i2 <<= 1) {
            this.update(dArray, i2, Direction.inverse);
            this.predict(dArray, i2, Direction.inverse);
            this.merge(dArray, i2);
        }
    }

    protected void merge(double[] dArray, int n2) {
        int n3 = n2 >> 1;
        int n4 = n3 - 1;
        int n5 = n3;
        while (n4 > 0) {
            for (int i2 = n4; i2 < n5; i2 += 2) {
                double d2 = dArray[i2];
                dArray[i2] = dArray[i2 + 1];
                dArray[i2 + 1] = d2;
            }
            --n4;
            ++n5;
        }
    }

    protected abstract void predict(double[] var1, int var2, Direction var3);

    protected void split(double[] dArray, int n2) {
        int n3 = 1;
        for (int i2 = n2 - 1; n3 < i2; ++n3, --i2) {
            for (int i3 = n3; i3 < i2; i3 += 2) {
                double d2 = dArray[i3];
                dArray[i3] = dArray[i3 + 1];
                dArray[i3 + 1] = d2;
            }
        }
    }

    protected abstract void update(double[] var1, int var2, Direction var3);

    protected static enum Direction {
        forward,
        inverse;

    }
}

