/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.BandPassTransform;
import io.fair_acc.math.filter.iir.BandStopTransform;
import io.fair_acc.math.filter.iir.Cascade;
import io.fair_acc.math.filter.iir.HighPassTransform;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.LowPassTransform;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.FastMath;

public class ChebyshevII
extends Cascade {
    public void bandPass(int n2, double d2, double d3, double d4, double d5) {
        this.setupBandPass(n2, d2, d3, d4, d5, 1);
    }

    public void bandPass(int n2, double d2, double d3, double d4, double d5, int n3) {
        this.setupBandPass(n2, d2, d3, d4, d5, n3);
    }

    public void bandStop(int n2, double d2, double d3, double d4, double d5) {
        this.setupBandStop(n2, d2, d3, d4, d5, 1);
    }

    public void bandStop(int n2, double d2, double d3, double d4, double d5, int n3) {
        this.setupBandStop(n2, d2, d3, d4, d5, n3);
    }

    public void highPass(int n2, double d2, double d3, double d4) {
        this.setupHighPass(n2, d2, d3, d4, 1);
    }

    public void highPass(int n2, double d2, double d3, double d4, int n3) {
        this.setupHighPass(n2, d2, d3, d4, n3);
    }

    public void lowPass(int n2, double d2, double d3, double d4) {
        this.setupLowPass(n2, d2, d3, d4, 1);
    }

    public void lowPass(int n2, double d2, double d3, double d4, int n3) {
        this.setupLowPass(n2, d2, d3, d4, n3);
    }

    private void setupBandPass(int n2, double d2, double d3, double d4, double d5, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design(d5);
        LayoutBase layoutBase = new LayoutBase(n2 * 2);
        BandPassTransform.transform(d3 / d2, d4 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupBandStop(int n2, double d2, double d3, double d4, double d5, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design(d5);
        LayoutBase layoutBase = new LayoutBase(n2 * 2);
        BandStopTransform.transform(d3 / d2, d4 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupHighPass(int n2, double d2, double d3, double d4, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design(d4);
        LayoutBase layoutBase = new LayoutBase(n2);
        HighPassTransform.transform(d3 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupLowPass(int n2, double d2, double d3, double d4, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design(d4);
        LayoutBase layoutBase = new LayoutBase(n2);
        LowPassTransform.transform(d3 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private static class AnalogLowPass
    extends LayoutBase {
        private final int nPoles;

        public AnalogLowPass(int n2) {
            super(n2);
            this.nPoles = n2;
        }

        public void design(double d2) {
            this.reset();
            double d3 = Math.sqrt(1.0 / (Math.exp(d2 * 0.1 * Math.log(10.0)) - 1.0));
            double d4 = FastMath.asinh((double)(1.0 / d3)) / (double)this.nPoles;
            double d5 = -Math.sinh(d4);
            double d6 = Math.cosh(d4);
            double d7 = Math.PI / (double)(2 * this.nPoles);
            int n2 = 1;
            int n3 = this.nPoles / 2;
            while (--n3 >= 0) {
                double d8 = d5 * Math.cos((double)(n2 - this.nPoles) * d7);
                double d9 = d6 * Math.sin((double)(n2 - this.nPoles) * d7);
                double d10 = d8 * d8 + d9 * d9;
                double d11 = 1.0 / Math.cos((double)n2 * d7);
                Complex complex = new Complex(d8 / d10, d9 / d10);
                Complex complex2 = new Complex(0.0, d11);
                this.addPoleZeroConjugatePairs(complex, complex2);
                n2 += 2;
            }
            if ((this.nPoles & 1) == 1) {
                this.add(new Complex(1.0 / d5), new Complex(Double.POSITIVE_INFINITY));
            }
            this.setNormal(0.0, 1.0);
        }
    }
}

