/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayLong
extends MultiArray<long[]> {
    public static MultiArrayLong wrap(long[] lArray) {
        return MultiArrayLong.wrap(lArray, 0, lArray.length);
    }

    public static MultiArrayLong wrap(long[] lArray, int n2, int n3) {
        return new MultiArray1DLong(lArray, new int[]{n3}, n2);
    }

    public static MultiArrayLong wrap(long[] lArray, int[] nArray) {
        return MultiArrayLong.wrap(lArray, 0, nArray);
    }

    public static MultiArrayLong wrap(long[] lArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, lArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DLong(lArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DLong(lArray, nArray, n2);
            }
        }
        return new MultiArrayLong(lArray, nArray, n2);
    }

    public static MultiArrayLong allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DLong(new long[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DLong(new long[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayLong(new long[n2], nArray, 0);
    }

    protected MultiArrayLong(long[] lArray, int[] nArray, int n2) {
        super(lArray, nArray, n2);
    }

    public void setStrided(int n2, long l2) {
        ((long[])this.elements)[n2 + this.offset] = l2;
    }

    public void set(int[] nArray, long l2) {
        ((long[])this.elements)[this.getIndex((int[])nArray)] = l2;
    }

    public long getStrided(int n2) {
        return ((long[])this.elements)[n2 + this.offset];
    }

    public long get(int[] nArray) {
        return ((long[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayLong)) {
            return false;
        }
        MultiArrayLong multiArrayLong = (MultiArrayLong)object;
        return Arrays.equals(this.dimensions, multiArrayLong.dimensions) && Arrays.equals((long[])this.elements, this.offset, this.offset + this.getElementsCount(), (long[])multiArrayLong.elements, multiArrayLong.offset, multiArrayLong.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Long.hashCode(((long[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DLong
    extends MultiArrayLong {
        protected MultiArray1DLong(long[] lArray, int[] nArray, int n2) {
            super(lArray, nArray, n2);
        }

        public long get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, long l2) {
            this.setStrided(n2, l2);
        }
    }

    public static class MultiArray2DLong
    extends MultiArrayLong {
        private final int stride;

        protected MultiArray2DLong(long[] lArray, int[] nArray, int n2) {
            super(lArray, nArray, n2);
            this.stride = nArray[1];
        }

        public long get(int n2, int n3) {
            return ((long[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, long l2) {
            ((long[])this.elements)[this.offset + n3 + n2 * this.stride] = l2;
        }

        public long[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((long[])this.elements, n3, n3 + this.stride);
        }
    }
}

