/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.DoubleDataSet;
import io.fair_acc.dataset.spi.FragmentedDataSet;

public class RollingDataSet
extends FragmentedDataSet {
    private static final long serialVersionUID = -3110510420345581034L;
    private double lastLength;
    private int depth = 0;

    public RollingDataSet(String string) {
        super(string);
    }

    @Override
    public void add(DataSet dataSet) {
        while (!this.list.isEmpty() && this.list.size() >= this.depth) {
            DataSet dataSet2 = (DataSet)this.list.remove(0);
            this.dataCount -= dataSet2.getDataCount();
        }
        for (DataSet dataSet3 : this.list) {
            ((InternalDataSet)dataSet3).shift(-this.lastLength);
        }
        this.list.add(new InternalDataSet(dataSet));
        this.dataCount += dataSet.getDataCount();
        this.lastLength = dataSet.getAxisDescription(0).getMax();
        this.getAxisDescriptions().forEach(AxisDescription::clear);
        this.fireInvalidated(ChartBits.DataSetDataAdded);
    }

    public int getDepth() {
        return this.depth;
    }

    public double getLastLength() {
        return this.lastLength;
    }

    public void setDepth(int n2) {
        this.depth = n2;
    }

    private static class InternalDataSet
    extends DoubleDataSet {
        private static final long serialVersionUID = 1L;

        public InternalDataSet(DataSet dataSet) {
            super(dataSet);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        }

        public void shift(double d2) {
            this.lock().writeLockGuard(() -> {
                int n2 = 0;
                while (n2 < this.xValues.size()) {
                    double[] dArray = this.getValues(0);
                    int n3 = n2++;
                    dArray[n3] = dArray[n3] + d2;
                }
            });
            this.fireInvalidated(ChartBits.DataSetData);
        }
    }
}

