/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractErrorDataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.trees.IndexedNavigableSet;
import io.fair_acc.dataset.utils.trees.IndexedTreeSet;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class LimitedIndexedTreeDataSet
extends AbstractErrorDataSet<LimitedIndexedTreeDataSet>
implements DataSet {
    private static final long serialVersionUID = -6372417982869679455L;
    protected transient IndexedNavigableSet<DataAtom> data = new IndexedTreeSet<DataAtom>();
    protected int maxQueueSize;
    protected double maxLength = Double.MAX_VALUE;
    protected boolean subtractOffset = false;
    protected boolean isSortedByX = true;

    public LimitedIndexedTreeDataSet(String string) {
        super(string, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        this.maxQueueSize = 1000;
    }

    public LimitedIndexedTreeDataSet(String string, int n2) {
        super(string, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        this.maxQueueSize = n2;
    }

    public LimitedIndexedTreeDataSet(String string, int n2, double d2) {
        super(string, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        this.maxQueueSize = n2;
        this.maxLength = d2;
    }

    public LimitedIndexedTreeDataSet add(double d2, double d3) {
        return this.add(d2, d3, 0.0, 0.0, new String[0]);
    }

    public LimitedIndexedTreeDataSet add(double d2, double d3, double d4, double d5, String ... stringArray) {
        this.lock().writeLockGuard(() -> {
            this.data.add(new DataAtom(d2, d3, d4, d5, stringArray));
            this.getAxisDescription(0).add(d2 - d4);
            this.getAxisDescription(0).add(d2 + d4);
            this.getAxisDescription(1).add(d3 - d5);
            this.getAxisDescription(1).add(d3 + d5);
            this.expire();
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (LimitedIndexedTreeDataSet)this.getThis();
    }

    public LimitedIndexedTreeDataSet add(double[] dArray, double[] dArray2) {
        return this.add(dArray, dArray2, new double[dArray2.length], new double[dArray2.length], new String[0]);
    }

    public LimitedIndexedTreeDataSet add(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String ... stringArray) {
        AssertUtils.notNull("X data", dArray);
        AssertUtils.notNull("X error data", dArray3);
        AssertUtils.notNull("Y data", dArray2);
        AssertUtils.notNull("Y error data", dArray2);
        this.lock().writeLockGuard(() -> {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                double d2 = dArray[i2];
                double d3 = dArray2[i2];
                double d4 = dArray3[i2];
                double d5 = dArray4[i2];
                this.data.add(new DataAtom(d2, d3, d4, d5, stringArray));
                this.getAxisDescription(0).add(d2 - d4);
                this.getAxisDescription(0).add(d2 + d4);
                this.getAxisDescription(1).add(d3 - d5);
                this.getAxisDescription(1).add(d3 + d5);
            }
            this.expire();
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (LimitedIndexedTreeDataSet)this.getThis();
    }

    @Override
    public String addDataLabel(int n2, String string) {
        String string2 = this.data.get((int)n2).label;
        this.data.get((int)n2).label = string;
        return string2;
    }

    @Override
    public String addDataStyle(int n2, String string) {
        String string2 = this.data.get((int)n2).style;
        this.data.get((int)n2).style = string;
        return string2;
    }

    public LimitedIndexedTreeDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (LimitedIndexedTreeDataSet)this.getThis();
    }

    public void expire() {
        this.lock().writeLockGuard(() -> this.expire(((DataAtom)this.data.last()).getX()));
    }

    public void expire(double d2) {
        this.lock().writeLockGuard(() -> {
            try {
                DataAtom dataAtom = (DataAtom)this.data.first();
                if (dataAtom == null) {
                    return;
                }
                while (this.data.size() > this.maxQueueSize || d2 - dataAtom.getX() > this.maxLength) {
                    this.data.remove(dataAtom);
                    dataAtom = (DataAtom)this.data.first();
                }
                this.getAxisDescriptions().forEach(AxisDescription::clear);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        });
    }

    @Override
    public double get(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.subtractOffset ? this.data.get(n3).getX() - this.data.get(this.data.size() - 1).getX() : this.data.get(n3).getX();
            }
            case 1: {
                return this.data.get(n3).getY();
            }
        }
        throw new IndexOutOfBoundsException("dimIndex out of bound 2");
    }

    public IndexedNavigableSet<DataAtom> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int n2) {
        String string = this.data.get(n2).getLabel();
        if (string != null) {
            return string;
        }
        return super.getDataLabel(n2);
    }

    @Override
    public double getErrorNegative(int n2, int n3) {
        return n2 == 0 ? this.data.get(n3).getErrorX() : this.data.get(n3).getErrorY();
    }

    @Override
    public double getErrorPositive(int n2, int n3) {
        return n2 == 0 ? this.data.get(n3).getErrorX() : this.data.get(n3).getErrorY();
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @Override
    public String getStyle(int n2) {
        return this.data.get(n2).getStyle();
    }

    public boolean isSortedByX() {
        return this.isSortedByX;
    }

    public boolean isSubtractOffset() {
        return this.subtractOffset;
    }

    public LimitedIndexedTreeDataSet remove(int n2, int n3) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(n2, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(n3, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(n2, "fromIndex", n3, "toIndex");
            ArrayList<DataAtom> arrayList = new ArrayList<DataAtom>();
            for (int i2 = n2; i2 < n3; ++i2) {
                arrayList.add(this.data.get(i2));
            }
            this.data.removeAll(arrayList);
            this.getAxisDescription(0).setMax(Double.NaN);
            this.getAxisDescription(1).setMax(Double.NaN);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (LimitedIndexedTreeDataSet)this.getThis();
    }

    public LimitedIndexedTreeDataSet remove(int[] nArray) {
        AssertUtils.notNull("Indices array", nArray);
        if (nArray.length == 0) {
            return this;
        }
        this.lock().writeLockGuard(() -> {
            ArrayList<DataAtom> arrayList = new ArrayList<DataAtom>();
            for (int n2 : nArray) {
                arrayList.add(this.data.get(n2));
            }
            this.data.removeAll(arrayList);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (LimitedIndexedTreeDataSet)this.getThis();
    }

    @Override
    public String removeDataLabel(int n2) {
        String string = this.data.get((int)n2).label;
        this.data.get((int)n2).label = "";
        return string;
    }

    @Override
    public String removeStyle(int n2) {
        String string = this.data.get((int)n2).style;
        this.data.get((int)n2).style = "";
        return string;
    }

    public LimitedIndexedTreeDataSet reset() {
        this.lock().writeLockGuard(() -> this.getData().clear());
        return this;
    }

    public LimitedIndexedTreeDataSet set(double[] dArray, double[] dArray2) {
        int n2 = dArray.length;
        return this.set(dArray, dArray2, new double[n2], new double[n2], n2);
    }

    public LimitedIndexedTreeDataSet set(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
        AssertUtils.notNull("X coordinates", dArray);
        AssertUtils.notNull("Y coordinates", dArray2);
        if (dArray.length < n2 || dArray2.length < n2 || dArray3.length < n2 || dArray4.length < n2) {
            throw new IllegalArgumentException("Arrays with coordinates must have length >= count!");
        }
        this.lock().writeLockGuard(() -> {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                double d2 = dArray[i2];
                double d3 = dArray2[i2];
                double d4 = dArray3[i2];
                double d5 = dArray4[i2];
                this.getAxisDescription(0).add(d2 - d4);
                this.getAxisDescription(0).add(d2 + d4);
                this.getAxisDescription(1).add(d3 - d5);
                this.getAxisDescription(1).add(d3 + d5);
                this.data.add(new DataAtom(d2, d3, d4, d5, new String[0]));
            }
            this.expire();
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (LimitedIndexedTreeDataSet)this.getThis();
    }

    public LimitedIndexedTreeDataSet set(double[] dArray, double[] dArray2, double[] dArray3, int n2) {
        return this.set(dArray, dArray2, new double[n2], dArray3, n2);
    }

    public LimitedIndexedTreeDataSet set(double[] dArray, double[] dArray2, int n2) {
        return this.set(dArray, dArray2, new double[n2], new double[n2], n2);
    }

    public LimitedIndexedTreeDataSet set(int n2, double d2, double d3) {
        return this.set(n2, d2, d3, 0.0, 0.0);
    }

    public LimitedIndexedTreeDataSet set(int n2, double d2, double d3, double d4, double d5) {
        this.lock().writeLockGuard(() -> {
            this.data.get(n2).set(d2, d3, d5, d5, new String[0]);
            this.getAxisDescription(0).add(d2 - d4);
            this.getAxisDescription(0).add(d2 + d4);
            this.getAxisDescription(1).add(d3 - d5);
            this.getAxisDescription(1).add(d3 + d5);
            this.expire();
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (LimitedIndexedTreeDataSet)this.getThis();
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        if (dataSet == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        this.lock().writeLockGuard(() -> dataSet.lock().readLockGuard(() -> {
            this.clearData();
            if (dataSet instanceof DataSetError) {
                DataSetError dataSetError = (DataSetError)dataSet;
                for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
                    double d2 = Math.abs(Math.max(dataSetError.getErrorNegative(0, i2), dataSetError.getErrorPositive(0, i2)));
                    double d3 = Math.abs(Math.max(dataSetError.getErrorNegative(1, i2), dataSetError.getErrorPositive(1, i2)));
                    this.add(dataSetError.get(0, i2), dataSetError.get(1, i2), d2, d3, new String[0]);
                }
            } else {
                for (int i3 = 0; i3 < dataSet.getDataCount(); ++i3) {
                    this.add(dataSet.get(0, i3), dataSet.get(1, i3));
                }
            }
            super.copyDataLabelsAndStyles(dataSet, bl2);
            super.copyMetaData(dataSet);
            super.copyAxisDescription(dataSet);
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return this.getThis();
    }

    public LimitedIndexedTreeDataSet setMaxLength(double d2) {
        this.maxLength = d2;
        return this;
    }

    public LimitedIndexedTreeDataSet setMaxQueueSize(int n2) {
        this.maxQueueSize = n2;
        return this;
    }

    public void setSortedByX(boolean bl2) {
        this.isSortedByX = bl2;
    }

    public void setSubtractOffset(boolean bl2) {
        this.subtractOffset = bl2;
    }

    protected class DataAtom
    implements Comparable<DataAtom> {
        protected double x;
        protected double y;
        protected double ex;
        protected double ey;
        protected String label;
        protected String style;

        protected DataAtom(double d2, double d3, double d4, double d5, String ... stringArray) {
            this.set(d2, d3, d4, d5, stringArray);
        }

        @Override
        public int compareTo(DataAtom dataAtom) {
            if (this == dataAtom) {
                return 0;
            }
            if (LimitedIndexedTreeDataSet.this.isSortedByX) {
                if (this.getX() < dataAtom.getX()) {
                    return -1;
                }
                if (this.getX() > dataAtom.getX()) {
                    return 1;
                }
            } else {
                if (this.getY() < dataAtom.getY()) {
                    return -1;
                }
                if (this.getY() > dataAtom.getY()) {
                    return 1;
                }
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DataAtom)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return ((DataAtom)object).getX() == this.getX();
        }

        public int hashCode() {
            return Double.hashCode(this.getX());
        }

        protected double getErrorX() {
            return this.ex;
        }

        protected double getErrorY() {
            return this.ey;
        }

        protected String getLabel() {
            return this.label;
        }

        protected String getStyle() {
            return this.style;
        }

        protected double getX() {
            return this.x;
        }

        protected double getY() {
            return this.y;
        }

        protected final void set(double d2, double d3, double d4, double d5, String ... stringArray) {
            this.x = d2;
            this.y = d3;
            this.ex = d4;
            this.ey = d5;
            if (stringArray == null) {
                return;
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (i2 == 0) {
                    this.label = stringArray[i2];
                }
                if (i2 != 1) continue;
                this.style = stringArray[i2];
            }
        }
    }
}

