/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.Histogram;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public abstract class AbstractHistogram
extends AbstractDataSet<AbstractHistogram>
implements Histogram {
    private static final long serialVersionUID = -6455271782865323112L;
    protected final double[] data;
    protected final double[][] axisBins;
    private final boolean equidistant;
    private final HistogramOuterBounds boundsType;

    public AbstractHistogram(String string, double[] dArray) {
        super(string, 2);
        this.equidistant = false;
        this.boundsType = HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY;
        int n2 = dArray.length - 1;
        int n3 = n2 + 2;
        this.data = new double[n3];
        this.axisBins = new double[][]{new double[n3], new double[0]};
        this.axisBins[0][0] = -1.7976931348623157E308;
        this.axisBins[0][n3 - 1] = Double.MAX_VALUE;
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        Arrays.sort(dArray2);
        System.arraycopy(dArray2, 0, this.axisBins[0], 1, dArray2.length);
        this.getAxisDescription(0).set(this.axisBins[0][1], this.axisBins[0][n2 + 1]);
        this.getAxisDescription(1).clear();
    }

    public AbstractHistogram(String string, int n2, double d2, double d3, HistogramOuterBounds histogramOuterBounds) {
        super(string, 2);
        this.equidistant = true;
        this.boundsType = histogramOuterBounds;
        int n3 = n2 + 2;
        this.data = new double[n3];
        this.axisBins = new double[][]{new double[n3], new double[0]};
        this.fillEquidistantAxisBinning(this.axisBins[0], d2, d3, this.boundsType);
        this.getAxisDescription(0).set(this.axisBins[0][1], this.axisBins[0][n3 - 1]);
        this.getAxisDescription(1).clear();
    }

    protected void fillEquidistantAxisBinning(double[] dArray, double d2, double d3, HistogramOuterBounds histogramOuterBounds) {
        double d4 = histogramOuterBounds == HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY ? 0.0 : (d3 - d2) / (double)((dArray.length - 3) * 2);
        double d5 = (d3 - d2 + 2.0 * d4) / (double)(dArray.length - 2);
        double d6 = d2 - d4;
        dArray[0] = -1.7976931348623157E308;
        dArray[dArray.length - 1] = Double.MAX_VALUE;
        for (int i2 = 0; i2 < dArray.length - 1; ++i2) {
            dArray[i2 + 1] = d6 + d5 * (double)i2;
        }
    }

    public AbstractHistogram(String string, int n2, double d2, double d3, int n3, double d4, double d5, HistogramOuterBounds histogramOuterBounds) {
        super(string, 3);
        this.equidistant = true;
        this.boundsType = histogramOuterBounds;
        int n4 = n2 + 2;
        int n5 = n3 + 2;
        this.axisBins = new double[][]{new double[n4], new double[n5], new double[0]};
        this.fillEquidistantAxisBinning(this.axisBins[0], d2, d3, this.boundsType);
        this.fillEquidistantAxisBinning(this.axisBins[1], d4, d5, this.boundsType);
        this.data = new double[n4 * n5];
        this.getAxisDescription(0).set(this.axisBins[0][1], this.axisBins[0][n4 - 1]);
        this.getAxisDescription(1).set(this.axisBins[1][1], this.axisBins[1][n5 - 1]);
        this.getAxisDescription(2).clear();
    }

    @Override
    public void addBinContent(int n2) {
        this.addBinContent(n2, 1.0);
    }

    @Override
    public void addBinContent(int n2, double d2) {
        this.lock().writeLockGuard(() -> {
            this.data[n2] = this.data[n2] + d2;
            this.getAxisDescription(this.getDimension() - 1).add(this.data[n2]);
        });
        this.fireInvalidated(ChartBits.DataSetData);
    }

    @Override
    public int findBin(double d2, double d3) {
        int n2 = this.findBin(0, d2);
        int n3 = this.findBin(1, d3);
        return this.getDataCount() * n3 + n2;
    }

    @Override
    public int findBin(double d2, double d3, double d4) {
        int n2 = this.findBin(0, d2);
        int n3 = this.findBin(1, d3);
        int n4 = this.findBin(2, d4);
        return this.getDataCount() * (n3 + this.getDataCount() * n4) + n2;
    }

    @Override
    public int findBin(int n2, double d2) {
        if (this.getAxisDescription(n2).getLength() == 0.0) {
            return 0;
        }
        if (!this.getAxisDescription(n2).contains(d2)) {
            if (d2 < this.axisBins[n2][1]) {
                return 0;
            }
            return this.axisBins[n2].length - 1;
        }
        return this.findNextLargerIndex(this.axisBins[n2], d2);
    }

    protected int findNextLargerIndex(double[] dArray, double d2) {
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (!(d2 < dArray[i2])) continue;
            return i2 - 1;
        }
        return dArray.length - 1;
    }

    @Override
    public double getBinCenter(int n2, int n3) {
        if (this.getAxisDescription(n2).getLength() == 0.0) {
            return this.axisBins[n2][1];
        }
        if (n3 == 0 || n3 == this.axisBins[n2].length - 1) {
            return Double.NaN;
        }
        return 0.5 * (this.getBinLimits(n2, Histogram.Boundary.LOWER, n3) + this.getBinLimits(n2, Histogram.Boundary.UPPER, n3));
    }

    @Override
    public int getBinCount(int n2) {
        return this.axisBins[n2].length;
    }

    @Override
    public double getBinContent(int n2) {
        return this.data[n2];
    }

    @Override
    public int getDataCount() {
        return Math.max(this.axisBins[0].length, this.axisBins[1].length) - 2;
    }

    @Override
    public boolean isEquiDistant() {
        return this.equidistant;
    }

    @Override
    public DataSet recomputeLimits(int n2) {
        if (n2 < this.getDimension()) {
            return this;
        }
        DataRange dataRange = new DataRange();
        int n3 = this.getDataCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            dataRange.add(this.getBinContent(i2 + 1));
        }
        this.getAxisDescription(n2).set(dataRange.getMin(), dataRange.getMax());
        return this;
    }

    @Override
    public double getBinLimits(int n2, Histogram.Boundary boundary, int n3) {
        if (n3 <= 0 && boundary == Histogram.Boundary.LOWER) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n3 >= this.axisBins[n2].length - 1 && boundary == Histogram.Boundary.UPPER) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.getAxisDescription(n2).getLength() == 0.0) {
            return this.axisBins[n2][1];
        }
        return boundary == Histogram.Boundary.UPPER ? this.axisBins[n2][n3 + 1] : this.axisBins[n2][n3];
    }

    public HistogramOuterBounds getBoundsType() {
        return this.boundsType;
    }

    @Override
    public double getValue(int n2, double ... dArray) {
        int n3 = this.getDimension() - 1;
        AssertUtils.checkArrayDimension("x", dArray, n3);
        switch (n3) {
            case 3: {
                return this.getBinContent(this.findBin(dArray[0], dArray[1], dArray[2]));
            }
            case 2: {
                return this.getBinContent(this.findBin(dArray[0], dArray[1]));
            }
        }
        return this.getBinContent(this.findBin(0, dArray[0]));
    }

    @Override
    public void reset() {
        Arrays.fill(this.data, 0.0);
        this.getDataStyleMap().clear();
        this.getDataLabelMap().clear();
        this.getAxisDescription(this.getDimension() - 1).clear();
    }

    protected static <T> void swap(T[] TArray, int n2, int n3) {
        T t2 = TArray[n2];
        TArray[n2] = TArray[n3];
        TArray[n3] = t2;
    }

    public static enum HistogramOuterBounds {
        BINS_CENTERED_ON_BOUNDARY,
        BINS_ALIGNED_WITH_BOUNDARY;

    }
}

