/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.dataset.events.StateListener;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FXUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FXUtils.class);

    public static void assertJavaFxThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("access JavaFX from non-JavaFX thread - please fix");
        }
    }

    public static void keepJavaFxAlive() {
        Platform.setImplicitExit((boolean)false);
    }

    public static void runAndWait(Runnable runnable) throws Exception {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            try {
                CompletableFuture.runAsync(runnable, Platform::runLater).get();
            }
            catch (ExecutionException executionException) {
                throw FXUtils.unwrapExecutionException(executionException);
            }
        }
    }

    public static <R> R runAndWait(Supplier<R> supplier) throws Exception {
        try {
            return Platform.isFxApplicationThread() ? supplier.get() : CompletableFuture.supplyAsync(supplier, Platform::runLater).get();
        }
        catch (ExecutionException executionException) {
            throw FXUtils.unwrapExecutionException(executionException);
        }
    }

    public static <T, R> R runAndWait(T t2, Function<T, R> function) throws Exception {
        try {
            return (R)(Platform.isFxApplicationThread() ? function.apply(t2) : CompletableFuture.supplyAsync(() -> function.apply(t2), Platform::runLater).get());
        }
        catch (ExecutionException executionException) {
            throw FXUtils.unwrapExecutionException(executionException);
        }
    }

    private static Exception unwrapExecutionException(ExecutionException executionException) {
        if (executionException.getCause() instanceof Exception) {
            return (Exception)executionException.getCause();
        }
        return executionException;
    }

    public static void runFX(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static boolean waitForFxTicks(Scene scene, int n2) {
        return FXUtils.waitForFxTicks(scene, n2, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForFxTicks(Scene scene, int n2, long l2) {
        if (Platform.isFxApplicationThread()) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Platform.requestNextPulse();
            }
            return true;
        }
        Timer timer = new Timer("FXUtils-thread", true);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        final ReentrantLock reentrantLock = new ReentrantLock();
        final Condition condition = reentrantLock.newCondition();
        Runnable runnable = () -> {
            if (atomicInteger.incrementAndGet() >= n2) {
                reentrantLock.lock();
                try {
                    atomicBoolean.getAndSet(false);
                    condition.signal();
                }
                finally {
                    atomicBoolean.getAndSet(false);
                    reentrantLock.unlock();
                }
            }
            Platform.requestNextPulse();
        };
        reentrantLock.lock();
        try {
            FXUtils.runAndWait(() -> scene.addPostLayoutPulseListener(runnable));
        }
        catch (Exception exception) {
            LOGGER.atError().setCause(exception).log("addPostLayoutPulseListener interrupted");
        }
        try {
            Platform.requestNextPulse();
            if (l2 > 0L) {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        LOGGER.atWarn().log("FXUtils::waitForTicks(..) interrupted by timeout");
                        reentrantLock.lock();
                        try {
                            atomicBoolean.getAndSet(false);
                            condition.signal();
                        }
                        finally {
                            atomicBoolean.getAndSet(false);
                            reentrantLock.unlock();
                        }
                    }
                }, l2);
            }
            while (atomicBoolean.get()) {
                condition.await();
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.atError().setCause(interruptedException).log("await interrupted");
        }
        finally {
            reentrantLock.unlock();
            timer.cancel();
        }
        try {
            FXUtils.runAndWait(() -> scene.removePostLayoutPulseListener(runnable));
        }
        catch (Exception exception) {
            LOGGER.atError().setCause(exception).log("removePostLayoutPulseListener interrupted");
        }
        return atomicInteger.get() >= n2;
    }

    public static <NODE extends Node> NODE setConstraint(NODE NODE, Object object, Object object2) {
        if (object2 == null) {
            NODE.getProperties().remove(object);
        } else {
            Object object3 = NODE.getProperties().put(object, object2);
            if (Objects.equals(object3, object2)) {
                return NODE;
            }
        }
        if (NODE.getParent() != null) {
            NODE.getParent().requestLayout();
        }
        return NODE;
    }

    public static Object getConstraint(Node node, Object object) {
        Object object2;
        if (node.hasProperties() && (object2 = node.getProperties().get(object)) != null) {
            return object2;
        }
        return null;
    }

    public static <T> List<T> sizedList(List<T> list, int n2, Supplier<T> supplier) {
        int n3 = n2 - list.size();
        if (n3 == 0) {
            return list;
        }
        while (n3 > 0) {
            list.add(supplier.get());
            --n3;
        }
        while (n3 < 0) {
            list.remove(list.size() - 1);
            ++n3;
        }
        return list;
    }

    public static StateListener runOnFxThread(StateListener stateListener) {
        return (bitState, n2) -> {
            if (Platform.isFxApplicationThread()) {
                stateListener.accept(bitState, n2);
            } else {
                Platform.runLater(() -> stateListener.accept(bitState, n2));
            }
        };
    }

    public static BooleanProperty bindManagedToVisible(Node node) {
        node.managedProperty().bind((ObservableValue)node.visibleProperty());
        return node.visibleProperty();
    }

    public static ObservableBooleanValue getShowingBinding(Node node) {
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty();
        Runnable runnable = () -> FXUtils.lambda$getShowingBinding$7((BooleanProperty)simpleBooleanProperty, node);
        runnable.run();
        ChangeListener changeListener = (observableValue, bl2, bl3) -> runnable.run();
        ChangeListener changeListener2 = (observableValue, window, window2) -> {
            if (window != null) {
                window.showingProperty().removeListener(changeListener);
            }
            if (window2 != null) {
                window2.showingProperty().addListener(changeListener);
            }
            runnable.run();
        };
        node.sceneProperty().addListener((observableValue, scene, scene2) -> {
            if (scene != null) {
                scene.windowProperty().removeListener(changeListener2);
            }
            if (scene2 != null) {
                scene2.windowProperty().addListener(changeListener2);
            }
            runnable.run();
        });
        return simpleBooleanProperty;
    }

    public static Optional<Chart> tryGetChartParent(Node node) {
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Chart)) continue;
            return Optional.of((Chart)parent);
        }
        return Optional.empty();
    }

    public static void registerLayoutHooks(Node node, Runnable runnable, Runnable runnable2) {
        AssertUtils.notNull("preLayoutAction", runnable);
        AssertUtils.notNull("postLayoutAction", runnable2);
        node.sceneProperty().addListener((observableValue, scene, scene2) -> {
            if (scene != null) {
                scene.removePreLayoutPulseListener(runnable);
                scene.removePostLayoutPulseListener(runnable2);
            }
            if (scene2 != null) {
                scene2.addPreLayoutPulseListener(runnable);
                scene2.addPostLayoutPulseListener(runnable2);
                runnable.run();
            }
        });
    }

    public static Group createUnmanagedGroup() {
        Group group = new Group();
        group.setManaged(false);
        group.relocate(0.0, 0.0);
        return group;
    }

    private static /* synthetic */ void lambda$getShowingBinding$7(BooleanProperty booleanProperty, Node node) {
        booleanProperty.set(Optional.ofNullable(node.getScene()).flatMap(scene -> Optional.ofNullable(scene.getWindow())).map(Window::isShowing).orElse(false).booleanValue());
    }
}

