/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi.format;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.format.AbstractFormatter;
import io.fair_acc.chartfx.axes.spi.format.DefaultTimeTickUnitSupplier;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class DefaultTimeFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTimeTickUnitSupplier();
    private static final DateTimeFormatter HIGHRES_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss +SSS", Locale.ENGLISH);
    protected final DateTimeFormatter[] dateFormat;
    protected int oldIndex = -1;
    protected int formatterIndex;
    protected ObjectProperty<ZoneOffset> timeZone = new SimpleObjectProperty((Object)ZoneOffset.UTC);

    public DefaultTimeFormatter() {
        this(null);
    }

    public DefaultTimeFormatter(Axis axis) {
        super(axis);
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
        this.dateFormat = new DateTimeFormatter[DefaultTimeTickUnitSupplier.TICK_UNIT_FORMATTER_DEFAULTS.length];
        for (int i2 = 0; i2 < this.dateFormat.length; ++i2) {
            String string = DefaultTimeTickUnitSupplier.TICK_UNIT_FORMATTER_DEFAULTS[i2];
            this.dateFormat[i2] = string.contains("HIGHRES") ? HIGHRES_FORMATTER : DateTimeFormatter.ofPattern(string, Locale.ENGLISH);
        }
    }

    public String formatHighResString(Number number) {
        double d2 = Math.abs(number.doubleValue());
        long l2 = (long)((double)TimeUnit.SECONDS.toMicros(1L) * d2);
        long l3 = Math.abs(number.longValue());
        int n2 = (int)((d2 - (double)l3) * 1.0E9);
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l3, n2, this.getTimeZoneOffset());
        return localDateTime.format(HIGHRES_FORMATTER).concat(Long.toString(l2 % 1000L)).concat("us").replaceAll(" ", System.lineSeparator());
    }

    @Override
    public Number fromString(String string) {
        return null;
    }

    public String getCurrentLocalDateTimeStamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    private String getTimeString(Number number) {
        if (this.formatterIndex <= 3) {
            return this.formatHighResString(number);
        }
        long l2 = number.longValue();
        int n2 = (int)((number.doubleValue() - (double)l2) * 1.0E9);
        if (n2 < 0) {
            --l2;
            n2 += 1000000000;
        }
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l2, n2, this.getTimeZoneOffset());
        return localDateTime.format(this.dateFormat[this.formatterIndex]).replaceAll(" ", System.lineSeparator());
    }

    public ZoneOffset getTimeZoneOffset() {
        return (ZoneOffset)this.timeZoneOffsetProperty().get();
    }

    @Override
    protected void rangeUpdated() {
        this.formatterIndex = DefaultTimeTickUnitSupplier.getTickIndex(this.getRange());
        if (this.oldIndex != this.formatterIndex) {
            this.labelCache.clear();
            this.oldIndex = this.formatterIndex;
        }
    }

    public void setTimeZoneOffset(ZoneOffset zoneOffset) {
        if (zoneOffset != null) {
            this.timeZoneOffsetProperty().set((Object)zoneOffset);
            return;
        }
        this.timeZoneOffsetProperty().set((Object)ZoneOffset.UTC);
    }

    public ObjectProperty<ZoneOffset> timeZoneOffsetProperty() {
        return this.timeZone;
    }

    @Override
    public String toString(Number number) {
        return this.labelCache.computeIfAbsent(number, this::getTimeString);
    }
}

