/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.ErrorCode;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.media.DynamicSndMultiDestination;
import io.aeron.driver.media.ManualSndMultiDestination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.MdcDestinations;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import io.aeron.status.ChannelEndpointStatus;
import io.aeron.status.LocalSocketAddressStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Hashing;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class SendChannelEndpoint
extends UdpChannelTransport {
    static final long DESTINATION_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private int refCount = 0;
    private long timeOfLastResolutionNs;
    private final Long2ObjectHashMap<NetworkPublication> publicationBySessionAndStreamId = new Long2ObjectHashMap();
    private final MultiSndDestination multiSndDestination;
    private final AtomicCounter statusMessagesReceived;
    private final AtomicCounter nakMessagesReceived;
    private final AtomicCounter statusIndicator;
    private final boolean isChannelSendTimestampEnabled;
    private final EpochNanoClock sendTimestampClock;
    private final UnsafeBuffer bufferForTimestamping = new UnsafeBuffer();
    private AtomicCounter localSocketAddressIndicator;
    private AtomicCounter mdcDestinationsCounter;

    public SendChannelEndpoint(UdpChannel udpChannel, AtomicCounter atomicCounter, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteControl(), udpChannel.localControl(), udpChannel.hasExplicitControl() || udpChannel.isManualControlMode() ? null : udpChannel.remoteData(), context);
        this.nakMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.NAK_MESSAGES_RECEIVED);
        this.statusMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.STATUS_MESSAGES_RECEIVED);
        this.statusIndicator = atomicCounter;
        MultiSndDestination multiSndDestination = null;
        if (udpChannel.isManualControlMode()) {
            multiSndDestination = new ManualSndMultiDestination(context.senderCachedNanoClock());
        } else if (udpChannel.isDynamicControlMode() || udpChannel.hasExplicitControl()) {
            multiSndDestination = new DynamicSndMultiDestination(context.senderCachedNanoClock());
        }
        this.multiSndDestination = multiSndDestination;
        this.isChannelSendTimestampEnabled = udpChannel.isChannelSendTimestampEnabled();
        this.sendTimestampClock = context.channelSendTimestampClock();
    }

    public void localSocketAddressIndicator(AtomicCounter atomicCounter) {
        this.localSocketAddressIndicator = atomicCounter;
    }

    public void decRef() {
        --this.refCount;
    }

    public void incRef() {
        ++this.refCount;
    }

    public void openChannel(DriverConductorProxy driverConductorProxy) {
        if (driverConductorProxy.notConcurrent()) {
            this.openDatagramChannel(this.statusIndicator);
        } else {
            try {
                this.openDatagramChannel(this.statusIndicator);
            }
            catch (Exception exception) {
                driverConductorProxy.channelEndpointError(this.statusIndicator.id(), exception);
                throw exception;
            }
        }
        LocalSocketAddressStatus.updateBindAddress(Objects.requireNonNull(this.localSocketAddressIndicator, "localSocketAddressIndicator not allocated"), this.bindAddressAndPort(), this.context.countersMetaDataBuffer());
        this.localSocketAddressIndicator.setOrdered(1L);
    }

    public String originalUriString() {
        return this.udpChannel().originalUriString();
    }

    public int statusIndicatorCounterId() {
        return this.statusIndicator.id();
    }

    public void indicateActive() {
        long l2 = this.statusIndicator.get();
        if (l2 != 0L) {
            throw new IllegalStateException("channel cannot be registered unless INITIALIZING: status=" + ChannelEndpointStatus.status(l2));
        }
        this.statusIndicator.appendToLabel(this.bindAddressAndPort());
        this.statusIndicator.setOrdered(1L);
    }

    public void closeIndicators() {
        CloseHelper.close(this.statusIndicator);
        CloseHelper.close(this.localSocketAddressIndicator);
        CloseHelper.close(this.mdcDestinationsCounter);
    }

    public boolean shouldBeClosed() {
        return 0 == this.refCount && !this.statusIndicator.isClosed();
    }

    public void registerForSend(NetworkPublication networkPublication) {
        this.publicationBySessionAndStreamId.put(Hashing.compoundKey(networkPublication.sessionId(), networkPublication.streamId()), networkPublication);
    }

    public void unregisterForSend(NetworkPublication networkPublication) {
        this.publicationBySessionAndStreamId.remove(Hashing.compoundKey(networkPublication.sessionId(), networkPublication.streamId()));
    }

    public int send(ByteBuffer byteBuffer) {
        int n2 = 0;
        if (this.isChannelSendTimestampEnabled) {
            this.applyChannelSendTimestamp(byteBuffer);
        }
        if (null != this.sendDatagramChannel) {
            int n3 = byteBuffer.remaining();
            if (null == this.multiSndDestination) {
                try {
                    this.sendHook(byteBuffer, this.connectAddress);
                    if (this.sendDatagramChannel.isConnected()) {
                        n2 = this.sendDatagramChannel.write(byteBuffer);
                    }
                }
                catch (PortUnreachableException portUnreachableException) {
                }
                catch (IOException iOException) {
                    SendChannelEndpoint.sendError(n3, iOException, this.connectAddress);
                }
            } else {
                n2 = this.multiSndDestination.send(this.sendDatagramChannel, byteBuffer, this, n3);
            }
        }
        return n2;
    }

    public void checkForReResolution(long l2, DriverConductorProxy driverConductorProxy) {
        if (this.udpChannel.isManualControlMode()) {
            this.multiSndDestination.checkForReResolution(this, l2, driverConductorProxy);
        } else if (this.udpChannel.hasExplicitEndpoint() && !this.udpChannel.isMulticast() && this.statusMessageTimeout(l2) && this.timeOfLastResolutionNs + DESTINATION_TIMEOUT - l2 < 0L) {
            this.timeOfLastResolutionNs = l2;
            String string = this.udpChannel.channelUri().get("endpoint");
            driverConductorProxy.reResolveEndpoint(string, this, this.udpChannel.remoteData());
        }
    }

    public void onStatusMessage(StatusMessageFlyweight statusMessageFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress) {
        NetworkPublication networkPublication;
        int n3 = statusMessageFlyweight.sessionId();
        int n4 = statusMessageFlyweight.streamId();
        this.statusMessagesReceived.incrementOrdered();
        if (null != this.multiSndDestination) {
            this.multiSndDestination.onStatusMessage(statusMessageFlyweight, inetSocketAddress);
        }
        if (null != (networkPublication = this.publicationBySessionAndStreamId.get(Hashing.compoundKey(n3, n4)))) {
            if (128 == (statusMessageFlyweight.flags() & 0x80)) {
                networkPublication.triggerSendSetupFrame();
            } else {
                networkPublication.onStatusMessage(statusMessageFlyweight, inetSocketAddress);
            }
        }
    }

    public void onNakMessage(NakFlyweight nakFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress) {
        long l2 = Hashing.compoundKey(nakFlyweight.sessionId(), nakFlyweight.streamId());
        NetworkPublication networkPublication = this.publicationBySessionAndStreamId.get(l2);
        if (null != networkPublication) {
            networkPublication.onNak(nakFlyweight.termId(), nakFlyweight.termOffset(), nakFlyweight.length());
            this.nakMessagesReceived.incrementOrdered();
        }
    }

    public void onRttMeasurement(RttMeasurementFlyweight rttMeasurementFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress) {
        long l2 = Hashing.compoundKey(rttMeasurementFlyweight.sessionId(), rttMeasurementFlyweight.streamId());
        NetworkPublication networkPublication = this.publicationBySessionAndStreamId.get(l2);
        if (null != networkPublication) {
            networkPublication.onRttMeasurement(rttMeasurementFlyweight, inetSocketAddress);
        }
    }

    public void validateAllowsManualControl() {
        if (!(this.multiSndDestination instanceof ManualSndMultiDestination)) {
            throw new ControlProtocolException(ErrorCode.INVALID_CHANNEL, "channel does not allow manual control");
        }
    }

    public void addDestination(ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        this.multiSndDestination.addDestination(channelUri, inetSocketAddress);
    }

    public void removeDestination(ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        this.multiSndDestination.removeDestination(channelUri, inetSocketAddress);
    }

    public void resolutionChange(String string, InetSocketAddress inetSocketAddress) {
        if (null != this.multiSndDestination) {
            this.multiSndDestination.updateDestination(string, inetSocketAddress);
        } else {
            this.updateEndpoint(inetSocketAddress, this.statusIndicator);
        }
    }

    public void allocateDestinationsCounterForMdc(MutableDirectBuffer mutableDirectBuffer, CountersManager countersManager, long l2, String string) {
        if (null != this.multiSndDestination) {
            this.mdcDestinationsCounter = MdcDestinations.allocate(mutableDirectBuffer, countersManager, l2, string);
            this.multiSndDestination.destinationsCounter(this.mdcDestinationsCounter);
        }
    }

    private boolean statusMessageTimeout(long l2) {
        for (NetworkPublication networkPublication : this.publicationBySessionAndStreamId.values()) {
            if (networkPublication.timeOfLastStatusMessageNs() + DESTINATION_TIMEOUT - l2 < 0L) continue;
            return false;
        }
        return true;
    }

    private void applyChannelSendTimestamp(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        if (n2 >= 32) {
            int n3;
            this.bufferForTimestamping.wrap(byteBuffer, byteBuffer.position(), n2);
            int n4 = this.bufferForTimestamping.getShort(6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            if (1 == n4 && !DataHeaderFlyweight.isHeartbeat(this.bufferForTimestamping, n2) && 32 + (n3 = this.udpChannel.channelSendTimestampOffset()) + 8 <= n2) {
                this.bufferForTimestamping.putLong(32 + n3, this.sendTimestampClock.nanoTime(), ByteOrder.LITTLE_ENDIAN);
            }
        }
    }
}

