/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.RawLog;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;

class MappedRawLog
implements RawLog {
    private static final int ONE_GIG = 0x40000000;
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);
    private static final EnumSet<StandardOpenOption> SPARSE_FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
    private final int termLength;
    private final UnsafeBuffer[] termBuffers = new UnsafeBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final ErrorHandler errorHandler;
    private File logFile;
    private MappedByteBuffer[] mappedBuffers;

    MappedRawLog(File file, boolean bl2, long l2, int n2, int n3, ErrorHandler errorHandler) {
        this.termLength = n2;
        this.errorHandler = errorHandler;
        this.logFile = file;
        EnumSet<StandardOpenOption> enumSet = bl2 ? SPARSE_FILE_OPTIONS : FILE_OPTIONS;
        try (FileChannel fileChannel = FileChannel.open(this.logFile.toPath(), enumSet, new FileAttribute[0]);){
            fileChannel.truncate(l2);
            if (l2 <= Integer.MAX_VALUE) {
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l2);
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mappedBuffers = new MappedByteBuffer[]{mappedByteBuffer};
                for (int i2 = 0; i2 < 3; ++i2) {
                    this.termBuffers[i2] = new UnsafeBuffer(mappedByteBuffer, i2 * n2, n2);
                }
                this.logMetaDataBuffer = new UnsafeBuffer(mappedByteBuffer, (int)(l2 - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
            } else {
                int n4;
                this.mappedBuffers = new MappedByteBuffer[4];
                for (n4 = 0; n4 < 3; ++n4) {
                    MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, (long)n2 * (long)n4, n2);
                    mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.mappedBuffers[n4] = mappedByteBuffer;
                    this.termBuffers[n4] = new UnsafeBuffer(mappedByteBuffer, 0, n2);
                }
                n4 = BitUtil.align(LogBufferDescriptor.LOG_META_DATA_LENGTH, n3);
                long l3 = (long)n2 * 3L;
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l3, n4);
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mappedBuffers[3] = mappedByteBuffer;
                this.logMetaDataBuffer = new UnsafeBuffer(mappedByteBuffer, n4 - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
            }
            if (!bl2) {
                MappedRawLog.preTouchPages(this.termBuffers, n2, n3);
            }
        }
        catch (IOException iOException) {
            IoUtil.delete(this.logFile, true);
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public int termLength() {
        return this.termLength;
    }

    @Override
    public boolean free() {
        MappedByteBuffer[] mappedByteBufferArray = this.mappedBuffers;
        if (null != mappedByteBufferArray) {
            int n2;
            this.mappedBuffers = null;
            for (n2 = 0; n2 < mappedByteBufferArray.length; ++n2) {
                BufferUtil.free(mappedByteBufferArray[n2]);
            }
            this.logMetaDataBuffer.wrap(0L, 0);
            for (n2 = 0; n2 < this.termBuffers.length; ++n2) {
                this.termBuffers[n2].wrap(0L, 0);
            }
        }
        if (null != this.logFile) {
            if (!this.logFile.delete() && this.logFile.exists()) {
                return false;
            }
            this.logFile = null;
        }
        return true;
    }

    @Override
    public void close() {
        if (!this.free()) {
            this.errorHandler.onError(new AeronException("unable to delete " + this.logFile, AeronException.Category.WARN));
        }
    }

    @Override
    public UnsafeBuffer[] termBuffers() {
        return this.termBuffers;
    }

    @Override
    public UnsafeBuffer metaData() {
        return this.logMetaDataBuffer;
    }

    @Override
    public ByteBuffer[] sliceTerms() {
        ByteBuffer[] byteBufferArray = new ByteBuffer[3];
        if (this.termLength < 0x40000000) {
            MappedByteBuffer mappedByteBuffer = this.mappedBuffers[0];
            for (int i2 = 0; i2 < 3; ++i2) {
                mappedByteBuffer.limit(this.termLength * i2 + this.termLength).position(this.termLength * i2);
                byteBufferArray[i2] = mappedByteBuffer.slice();
            }
        } else {
            for (int i3 = 0; i3 < 3; ++i3) {
                byteBufferArray[i3] = this.mappedBuffers[i3].duplicate();
            }
        }
        return byteBufferArray;
    }

    @Override
    public String fileName() {
        return this.logFile.getAbsolutePath();
    }

    private static void preTouchPages(UnsafeBuffer[] unsafeBufferArray, int n2, int n3) {
        for (UnsafeBuffer unsafeBuffer : unsafeBufferArray) {
            for (long i2 = 0L; i2 < (long)n2; i2 += (long)n3) {
                unsafeBuffer.putByte((int)i2, (byte)0);
            }
        }
    }
}

