/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.NetworkPublication;

final class PublicationLink
implements DriverManagedResource {
    private final long registrationId;
    private final Object publication;
    private final AeronClient client;
    private boolean reachedEndOfLife = false;

    PublicationLink(long l2, AeronClient aeronClient, NetworkPublication networkPublication) {
        this.registrationId = l2;
        this.client = aeronClient;
        this.publication = networkPublication;
        networkPublication.incRef();
    }

    PublicationLink(long l2, AeronClient aeronClient, IpcPublication ipcPublication) {
        this.registrationId = l2;
        this.client = aeronClient;
        this.publication = ipcPublication;
        ipcPublication.incRef();
    }

    @Override
    public void close() {
        if (this.publication instanceof NetworkPublication) {
            ((NetworkPublication)this.publication).decRef();
        } else {
            ((IpcPublication)this.publication).decRef();
        }
    }

    @Override
    public void onTimeEvent(long l2, long l3, DriverConductor driverConductor) {
        if (this.client.hasTimedOut()) {
            this.reachedEndOfLife = true;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    long registrationId() {
        return this.registrationId;
    }
}

