/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.CongestionControl;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.LossDetector;
import io.aeron.driver.LossHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PublicationImagePadding3;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermGapFiller;
import io.aeron.logbuffer.TermRebuilder;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.MemoryAccess;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class PublicationImage
extends PublicationImagePadding3
implements LossHandler,
DriverManagedResource,
Subscribable {
    private static final long SM_EOS_MULTIPLE = 5L;
    private static final AtomicLongFieldUpdater<PublicationImage> BEGIN_SM_CHANGE_UPDATER = AtomicLongFieldUpdater.newUpdater(PublicationImage.class, "beginSmChange");
    private static final AtomicLongFieldUpdater<PublicationImage> END_SM_CHANGE_UPDATER = AtomicLongFieldUpdater.newUpdater(PublicationImage.class, "endSmChange");
    private volatile long beginSmChange = -1L;
    private volatile long endSmChange = -1L;
    private long nextSmPosition;
    private int nextSmReceiverWindowLength;
    private long lastSmChangeNumber = -1L;
    private long lastSmPosition;
    private long lastOverrunThreshold;
    private long timeOfLastSmNs;
    private final long smTimeoutNs;
    private final long maxReceiverWindowLength;
    private volatile long beginLossChange = -1L;
    private volatile long endLossChange = -1L;
    private int lossTermId;
    private int lossTermOffset;
    private int lossLength;
    private long lastLossChangeNumber = -1L;
    private volatile long timeOfLastStateChangeNs;
    private final long correlationId;
    private final long imageLivenessTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final int sessionId;
    private final int streamId;
    private final int positionBitsToShift;
    private final int termLengthMask;
    private final int initialTermId;
    private final boolean isReliable;
    private boolean isRebuilding = true;
    private volatile boolean isReceiverReleaseTriggered = false;
    private volatile boolean hasReceiverReleased = false;
    private volatile State state = State.INIT;
    private final CachedNanoClock cachedNanoClock;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final UnsafeBuffer[] termBuffers;
    private final Position hwmPosition;
    private final LossDetector lossDetector;
    private final CongestionControl congestionControl;
    private final ErrorHandler errorHandler;
    private final Position rebuildPosition;
    private final InetSocketAddress sourceAddress;
    private final String sourceIdentity;
    private final AtomicCounter heartbeatsReceived;
    private final AtomicCounter statusMessagesSent;
    private final AtomicCounter nakMessagesSent;
    private final AtomicCounter flowControlUnderRuns;
    private final AtomicCounter flowControlOverRuns;
    private final AtomicCounter lossGapFills;
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final RawLog rawLog;

    PublicationImage(long l2, MediaDriver.Context context, ReceiveChannelEndpoint receiveChannelEndpoint, int n2, InetSocketAddress inetSocketAddress, int n3, int n4, int n5, int n6, int n7, RawLog rawLog, FeedbackDelayGenerator feedbackDelayGenerator, ArrayList<SubscriberPosition> arrayList, Position position, Position position2, InetSocketAddress inetSocketAddress2, String string, CongestionControl congestionControl) {
        long l3;
        long l4;
        this.correlationId = l2;
        this.imageLivenessTimeoutNs = context.imageLivenessTimeoutNs();
        this.untetheredWindowLimitTimeoutNs = context.untetheredWindowLimitTimeoutNs();
        this.untetheredRestingTimeoutNs = context.untetheredRestingTimeoutNs();
        this.smTimeoutNs = context.statusMessageTimeoutNs();
        this.channelEndpoint = receiveChannelEndpoint;
        this.sessionId = n3;
        this.streamId = n4;
        this.rawLog = rawLog;
        this.hwmPosition = position;
        this.rebuildPosition = position2;
        this.sourceAddress = inetSocketAddress2;
        this.sourceIdentity = string;
        this.initialTermId = n5;
        this.congestionControl = congestionControl;
        this.errorHandler = context.errorHandler();
        this.lossReport = context.lossReport();
        this.nanoClock = context.nanoClock();
        this.epochClock = context.epochClock();
        this.cachedNanoClock = context.receiverCachedNanoClock();
        this.timeOfLastStateChangeNs = l4 = this.cachedNanoClock.nanoTime();
        this.timeOfLastPacketNs = l4;
        this.subscriberPositions = this.positionArray(arrayList, l4);
        this.isReliable = arrayList.get(0).subscription().isReliable();
        SystemCounters systemCounters = context.systemCounters();
        this.heartbeatsReceived = systemCounters.get(SystemCounterDescriptor.HEARTBEATS_RECEIVED);
        this.statusMessagesSent = systemCounters.get(SystemCounterDescriptor.STATUS_MESSAGES_SENT);
        this.nakMessagesSent = systemCounters.get(SystemCounterDescriptor.NAK_MESSAGES_SENT);
        this.flowControlUnderRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_UNDER_RUNS);
        this.flowControlOverRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_OVER_RUNS);
        this.lossGapFills = systemCounters.get(SystemCounterDescriptor.LOSS_GAP_FILLS);
        this.imageConnections = ArrayUtil.ensureCapacity(this.imageConnections, n2 + 1);
        this.imageConnections[n2] = new ImageConnection(l4, inetSocketAddress);
        this.termBuffers = rawLog.termBuffers();
        this.lossDetector = new LossDetector(feedbackDelayGenerator, this);
        int n8 = rawLog.termLength();
        this.termLengthMask = n8 - 1;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(n8);
        this.nextSmReceiverWindowLength = congestionControl.initialWindowLength();
        this.maxReceiverWindowLength = congestionControl.maxWindowLength();
        this.nextSmPosition = l3 = LogBufferDescriptor.computePosition(n6, n7, this.positionBitsToShift, n5);
        this.lastSmPosition = l3;
        this.lastOverrunThreshold = l3 + (long)this.nextSmReceiverWindowLength;
        this.cleanPosition = l3;
        position.setOrdered(l3);
        position2.setOrdered(l3);
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        CloseHelper.close(this.errorHandler, this.hwmPosition);
        CloseHelper.close(this.errorHandler, this.rebuildPosition);
        CloseHelper.closeAll(this.errorHandler, (AutoCloseable[])this.subscriberPositions);
        int n2 = this.untetheredSubscriptions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UntetheredSubscription untetheredSubscription = (UntetheredSubscription)this.untetheredSubscriptions.get(i2);
            if (UntetheredSubscription.State.RESTING != untetheredSubscription.state) continue;
            CloseHelper.close(this.errorHandler, untetheredSubscription.position);
        }
        CloseHelper.close(this.errorHandler, this.congestionControl);
    }

    public long correlationId() {
        return this.correlationId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public String channel() {
        return this.channelEndpoint.originalUriString();
    }

    @Override
    public long subscribableRegistrationId() {
        return this.correlationId;
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition readablePosition, long l2) {
        this.subscriberPositions = ArrayUtil.add(this.subscriberPositions, readablePosition);
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, readablePosition, l2));
        }
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition readablePosition) {
        this.subscriberPositions = ArrayUtil.remove(this.subscriberPositions, readablePosition);
        readablePosition.close();
        if (!subscriptionLink.isTether()) {
            int n2;
            for (int i2 = n2 = this.untetheredSubscriptions.size() - 1; i2 >= 0; --i2) {
                if (((UntetheredSubscription)this.untetheredSubscriptions.get((int)i2)).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove(this.untetheredSubscriptions, i2, n2);
                break;
            }
        }
        if (this.subscriberPositions.length == 0) {
            this.isRebuilding = false;
        }
    }

    @Override
    public void onGapDetected(int n2, int n3, int n4) {
        long l2;
        this.beginLossChange = l2 = this.beginLossChange + 1L;
        this.lossTermId = n2;
        this.lossTermOffset = n3;
        this.lossLength = n4;
        this.endLossChange = l2;
        if (null != this.reportEntry) {
            this.reportEntry.recordObservation(n4, this.epochClock.time());
        } else if (null != this.lossReport) {
            this.reportEntry = this.lossReport.createEntry(n4, this.epochClock.time(), this.sessionId, this.streamId, this.channel(), this.sourceIdentity);
            if (null == this.reportEntry) {
                this.lossReport = null;
            }
        }
    }

    InetSocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    String sourceIdentity() {
        return this.sourceIdentity;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    void removeFromDispatcher() {
        this.channelEndpoint.dispatcher().removePublicationImage(this);
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    void activate() {
        this.timeOfLastStateChangeNs = this.cachedNanoClock.nanoTime();
        this.state = State.ACTIVE;
    }

    void deactivate() {
        if (State.ACTIVE == this.state) {
            long l2 = this.cachedNanoClock.nanoTime();
            this.isRebuilding = false;
            this.timeOfLastStateChangeNs = l2;
            if (!this.isSendingEosSm) {
                boolean bl2 = this.isSendingEosSm = !this.isEndOfStream || this.rebuildPosition.getVolatile() == this.hwmPosition.get();
            }
            if (this.isSendingEosSm) {
                this.timeOfLastSmNs = l2 - this.smTimeoutNs - 1L;
            }
            this.state = State.DRAINING;
        }
    }

    void receiverRelease() {
        this.hasReceiverReleased = true;
    }

    void addDestination(int n2, ReceiveDestinationTransport receiveDestinationTransport) {
        this.imageConnections = ArrayUtil.ensureCapacity(this.imageConnections, n2 + 1);
        if (receiveDestinationTransport.isMulticast()) {
            this.imageConnections[n2] = new ImageConnection(this.cachedNanoClock.nanoTime(), receiveDestinationTransport.udpChannel().remoteControl());
        } else if (receiveDestinationTransport.hasExplicitControl()) {
            this.imageConnections[n2] = new ImageConnection(this.cachedNanoClock.nanoTime(), receiveDestinationTransport.explicitControlAddress());
        }
    }

    void removeDestination(int n2) {
        this.imageConnections[n2] = null;
        this.updateActiveTransportCount();
    }

    void addDestinationConnectionIfUnknown(int n2, InetSocketAddress inetSocketAddress) {
        this.trackConnection(n2, inetSocketAddress, this.cachedNanoClock.nanoTime());
    }

    int trackRebuild(long l2) {
        int n2 = 0;
        if (this.isRebuilding) {
            long l3 = this.hwmPosition.getVolatile();
            long l4 = Long.MAX_VALUE;
            long l5 = 0L;
            for (ReadablePosition readablePosition : this.subscriberPositions) {
                long l6 = readablePosition.getVolatile();
                l4 = Math.min(l4, l6);
                l5 = Math.max(l5, l6);
            }
            long l7 = Math.max(this.rebuildPosition.get(), l5);
            long l8 = this.lossDetector.scan(this.termBuffers[LogBufferDescriptor.indexByPosition(l7, this.positionBitsToShift)], l7, l3, l2, this.termLengthMask, this.positionBitsToShift, this.initialTermId);
            int n3 = (int)l7 & this.termLengthMask;
            long l9 = l7 - (long)n3 + (long)LossDetector.rebuildOffset(l8);
            this.rebuildPosition.proposeMaxOrdered(l9);
            long l10 = this.congestionControl.onTrackRebuild(l2, l4, this.nextSmPosition, l3, l7, l9, LossDetector.lossFound(l8));
            int n4 = CongestionControl.receiverWindowLength(l10);
            int n5 = CongestionControl.threshold(n4);
            if (CongestionControl.shouldForceStatusMessage(l10) || l4 > this.nextSmPosition + (long)n5 || n4 != this.nextSmReceiverWindowLength) {
                this.cleanBufferTo(l4 - (long)(this.termLengthMask + 1));
                this.scheduleStatusMessage(l4, n4);
                ++n2;
            }
        }
        return n2;
    }

    int insertPacket(int n2, int n3, UnsafeBuffer unsafeBuffer, int n4, int n5, InetSocketAddress inetSocketAddress) {
        long l2;
        boolean bl2 = DataHeaderFlyweight.isHeartbeat(unsafeBuffer, n4);
        long l3 = LogBufferDescriptor.computePosition(n2, n3, this.positionBitsToShift, this.initialTermId);
        long l4 = l2 = bl2 ? l3 : l3 + (long)n4;
        if (!this.isFlowControlOverRun(l2)) {
            if (!this.isFlowControlUnderRun(l3)) {
                long l5;
                this.timeOfLastPacketNs = l5 = this.cachedNanoClock.nanoTime();
                this.trackConnection(n5, inetSocketAddress, l5);
                if (bl2) {
                    if (DataHeaderFlyweight.isEndOfStream(unsafeBuffer) && !this.isEndOfStream && this.allEos(n5)) {
                        LogBufferDescriptor.endOfStreamPosition(this.rawLog.metaData(), l2);
                        this.isEndOfStream = true;
                    }
                    this.heartbeatsReceived.incrementOrdered();
                } else {
                    UnsafeBuffer unsafeBuffer2 = this.termBuffers[LogBufferDescriptor.indexByPosition(l3, this.positionBitsToShift)];
                    TermRebuilder.insert(unsafeBuffer2, n3, unsafeBuffer, n4);
                }
                this.hwmPosition.proposeMaxOrdered(l2);
            } else if (l3 >= this.lastSmPosition - this.maxReceiverWindowLength) {
                this.trackConnection(n5, inetSocketAddress, this.cachedNanoClock.nanoTime());
            }
        }
        return n4;
    }

    boolean isConnected(long l2) {
        return this.timeOfLastPacketNs + this.imageLivenessTimeoutNs - l2 >= 0L && !this.channelEndpoint.isClosed() && (!this.isEndOfStream || !this.isReceiverReleaseTriggered);
    }

    void checkEosForDrainTransition(long l2) {
        if (!this.isSendingEosSm && this.isEndOfStream && this.rebuildPosition.getVolatile() == this.hwmPosition.get() && State.ACTIVE == this.state) {
            this.isRebuilding = false;
            this.timeOfLastStateChangeNs = l2;
            this.isSendingEosSm = true;
            this.timeOfLastSmNs = l2 - this.smTimeoutNs - 1L;
            this.state = State.DRAINING;
        }
    }

    int sendPendingStatusMessage(long l2) {
        int n2 = 0;
        long l3 = this.endSmChange;
        if (l3 != this.lastSmChangeNumber || this.timeOfLastSmNs + this.smTimeoutNs - l2 < 0L) {
            long l4 = this.nextSmPosition;
            int n3 = this.nextSmReceiverWindowLength;
            MemoryAccess.acquireFence();
            if (l3 == this.beginSmChange) {
                int n4 = LogBufferDescriptor.computeTermIdFromPosition(l4, this.positionBitsToShift, this.initialTermId);
                int n5 = (int)l4 & this.termLengthMask;
                short s2 = this.isSendingEosSm ? (short)64 : 0;
                this.channelEndpoint.sendStatusMessage(this.imageConnections, this.sessionId, this.streamId, n4, n5, n3, s2);
                this.statusMessagesSent.incrementOrdered();
                this.lastSmPosition = l4;
                this.lastOverrunThreshold = l4 + this.maxReceiverWindowLength;
                this.lastSmChangeNumber = l3;
                this.timeOfLastSmNs = l2;
                this.updateActiveTransportCount();
            }
            n2 = 1;
        }
        return n2;
    }

    int processPendingLoss() {
        int n2 = 0;
        long l2 = this.endLossChange;
        if (l2 != this.lastLossChangeNumber) {
            int n3 = this.lossTermId;
            int n4 = this.lossTermOffset;
            int n5 = this.lossLength;
            MemoryAccess.acquireFence();
            if (l2 == this.beginLossChange) {
                if (this.isReliable) {
                    this.channelEndpoint.sendNakMessage(this.imageConnections, this.sessionId, this.streamId, n3, n4, n5);
                    this.nakMessagesSent.incrementOrdered();
                } else {
                    UnsafeBuffer unsafeBuffer = this.termBuffers[LogBufferDescriptor.indexByTerm(this.initialTermId, n3)];
                    if (TermGapFiller.tryFillGap(this.rawLog.metaData(), unsafeBuffer, n3, n4, n5)) {
                        this.lossGapFills.incrementOrdered();
                    }
                }
                this.lastLossChangeNumber = l2;
            }
            n2 = 1;
        }
        return n2;
    }

    int initiateAnyRttMeasurements(long l2) {
        int n2 = 0;
        if (this.congestionControl.shouldMeasureRtt(l2)) {
            long l3 = this.nanoClock.nanoTime();
            this.channelEndpoint.sendRttMeasurement(this.imageConnections, this.sessionId, this.streamId, l3, 0L, true);
            this.congestionControl.onRttMeasurementSent(l3);
            n2 = 1;
        }
        return n2;
    }

    void onRttMeasurement(RttMeasurementFlyweight rttMeasurementFlyweight, int n2, InetSocketAddress inetSocketAddress) {
        long l2 = this.nanoClock.nanoTime();
        long l3 = l2 - rttMeasurementFlyweight.echoTimestampNs() - rttMeasurementFlyweight.receptionDelta();
        this.congestionControl.onRttMeasurement(l2, l3, inetSocketAddress);
    }

    boolean isAcceptingSubscriptions() {
        return this.subscriberPositions.length > 0 && (State.INIT == this.state || State.ACTIVE == this.state || State.DRAINING == this.state && !this.isDrained());
    }

    long joinPosition() {
        long l2 = this.rebuildPosition.get();
        for (ReadablePosition readablePosition : this.subscriberPositions) {
            l2 = Math.min(readablePosition.getVolatile(), l2);
        }
        return l2;
    }

    @Override
    public void onTimeEvent(long l2, long l3, DriverConductor driverConductor) {
        switch (this.state) {
            case ACTIVE: {
                this.checkUntetheredSubscriptions(l2, driverConductor);
                break;
            }
            case DRAINING: {
                if (!this.isDrained() || this.timeOfLastStateChangeNs + 5L * this.smTimeoutNs - l2 >= 0L) break;
                driverConductor.transitionToLinger(this);
                this.channelEndpoint.decRefImages();
                driverConductor.tryCloseReceiveChannelEndpoint(this.channelEndpoint);
                this.timeOfLastStateChangeNs = l2;
                this.isReceiverReleaseTriggered = true;
                this.state = State.LINGER;
                break;
            }
            case LINGER: {
                if (!this.hasNoSubscribers() && this.timeOfLastStateChangeNs + this.imageLivenessTimeoutNs - l2 >= 0L) break;
                driverConductor.cleanupImage(this);
                this.timeOfLastStateChangeNs = l2;
                this.state = State.DONE;
                break;
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.hasReceiverReleased && State.DONE == this.state;
    }

    private boolean isDrained() {
        long l2 = this.rebuildPosition.get();
        for (ReadablePosition readablePosition : this.subscriberPositions) {
            if (readablePosition.getVolatile() >= l2) continue;
            return false;
        }
        return true;
    }

    private boolean hasNoSubscribers() {
        return this.subscriberPositions.length == 0;
    }

    private boolean isFlowControlUnderRun(long l2) {
        boolean bl2;
        boolean bl3 = bl2 = l2 < this.lastSmPosition;
        if (bl2) {
            this.flowControlUnderRuns.incrementOrdered();
        }
        return bl2;
    }

    private boolean isFlowControlOverRun(long l2) {
        boolean bl2;
        boolean bl3 = bl2 = l2 > this.lastOverrunThreshold;
        if (bl2) {
            this.flowControlOverRuns.incrementOrdered();
        }
        return bl2;
    }

    private void cleanBufferTo(long l2) {
        long l3 = this.cleanPosition;
        if (l2 > l3) {
            int n2 = (int)(l2 - l3);
            UnsafeBuffer unsafeBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition(l3, this.positionBitsToShift)];
            int n3 = (int)l3 & this.termLengthMask;
            int n4 = Math.min(n2, unsafeBuffer.capacity() - n3);
            unsafeBuffer.setMemory(n3, n4 - 8, (byte)0);
            unsafeBuffer.putLongOrdered(n3 + (n4 - 8), 0L);
            this.cleanPosition = l3 + (long)n4;
        }
    }

    private void trackConnection(int n2, InetSocketAddress inetSocketAddress, long l2) {
        this.imageConnections = ArrayUtil.ensureCapacity(this.imageConnections, n2 + 1);
        ImageConnection imageConnection = this.imageConnections[n2];
        if (null == imageConnection) {
            this.imageConnections[n2] = imageConnection = new ImageConnection(l2, inetSocketAddress);
        }
        imageConnection.timeOfLastActivityNs = l2;
        imageConnection.timeOfLastFrameNs = l2;
    }

    private boolean allEos(int n2) {
        this.imageConnections[n2].isEos = true;
        int n3 = this.imageConnections.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            ImageConnection imageConnection = this.imageConnections[i2];
            if (null != imageConnection && !imageConnection.isEos) {
                return false;
            }
            if (null != imageConnection || !this.channelEndpoint.hasDestination(i2)) continue;
            return false;
        }
        return true;
    }

    private void scheduleStatusMessage(long l2, int n2) {
        long l3 = this.beginSmChange + 1L;
        BEGIN_SM_CHANGE_UPDATER.lazySet(this, l3);
        MemoryAccess.releaseFence();
        this.nextSmPosition = l2;
        this.nextSmReceiverWindowLength = n2;
        END_SM_CHANGE_UPDATER.lazySet(this, l3);
    }

    private void checkUntetheredSubscriptions(long l2, DriverConductor driverConductor) {
        ArrayList arrayList = this.untetheredSubscriptions;
        int n2 = arrayList.size();
        if (n2 > 0) {
            int n3;
            long l3 = 0L;
            for (ReadablePosition readablePosition : this.subscriberPositions) {
                long l4 = readablePosition.getVolatile();
                if (l4 <= l3) continue;
                l3 = l4;
            }
            int n4 = this.nextSmReceiverWindowLength;
            long l5 = l3 - (long)n4 + (long)(n4 >> 2);
            for (int i2 = n3 = n2 - 1; i2 >= 0; --i2) {
                UntetheredSubscription untetheredSubscription = (UntetheredSubscription)arrayList.get(i2);
                if (UntetheredSubscription.State.ACTIVE == untetheredSubscription.state) {
                    if (untetheredSubscription.position.getVolatile() > l5) {
                        untetheredSubscription.timeOfLastUpdateNs = l2;
                        continue;
                    }
                    if (untetheredSubscription.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - l2 > 0L) continue;
                    driverConductor.notifyUnavailableImageLink(this.correlationId, untetheredSubscription.subscriptionLink);
                    untetheredSubscription.state(UntetheredSubscription.State.LINGER, l2, this.streamId, this.sessionId);
                    continue;
                }
                if (UntetheredSubscription.State.LINGER == untetheredSubscription.state) {
                    if (untetheredSubscription.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - l2 > 0L) continue;
                    this.subscriberPositions = ArrayUtil.remove(this.subscriberPositions, untetheredSubscription.position);
                    untetheredSubscription.state(UntetheredSubscription.State.RESTING, l2, this.streamId, this.sessionId);
                    continue;
                }
                if (UntetheredSubscription.State.RESTING != untetheredSubscription.state || untetheredSubscription.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - l2 > 0L) continue;
                this.subscriberPositions = ArrayUtil.add(this.subscriberPositions, untetheredSubscription.position);
                driverConductor.notifyAvailableImageLink(this.correlationId, this.sessionId, untetheredSubscription.subscriptionLink, untetheredSubscription.position.id(), this.joinPosition(), this.rawLog.fileName(), this.sourceIdentity);
                untetheredSubscription.state(UntetheredSubscription.State.ACTIVE, l2, this.streamId, this.sessionId);
            }
        }
    }

    private void updateActiveTransportCount() {
        long l2 = this.cachedNanoClock.nanoTime();
        int n2 = 0;
        for (ImageConnection imageConnection : this.imageConnections) {
            if (null == imageConnection || imageConnection.timeOfLastFrameNs + this.imageLivenessTimeoutNs - l2 <= 0L) continue;
            ++n2;
        }
        UnsafeBuffer unsafeBuffer = this.rawLog.metaData();
        if (unsafeBuffer.getInt(LogBufferDescriptor.LOG_ACTIVE_TRANSPORT_COUNT) != n2) {
            LogBufferDescriptor.activeTransportCount(unsafeBuffer, n2);
        }
    }

    private ReadablePosition[] positionArray(ArrayList<SubscriberPosition> arrayList, long l2) {
        int n2 = arrayList.size();
        ReadablePosition[] readablePositionArray = new ReadablePosition[arrayList.size()];
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriberPosition subscriberPosition = arrayList.get(i2);
            readablePositionArray[i2] = subscriberPosition.position();
            if (subscriberPosition.subscription().isTether()) continue;
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriberPosition.subscription(), subscriberPosition.position(), l2));
        }
        return readablePositionArray;
    }

    static enum State {
        INIT,
        ACTIVE,
        DRAINING,
        LINGER,
        DONE;

    }
}

