/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class TerminateDriverFlyweight
extends CorrelatedMessageFlyweight {
    private static final int TOKEN_LENGTH_OFFSET = 16;
    static final int TOKEN_BUFFER_OFFSET = 20;
    private static final int MINIMUM_LENGTH = 20;

    @Override
    public TerminateDriverFlyweight wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        super.wrap(mutableDirectBuffer, n2);
        return this;
    }

    public int tokenBufferOffset() {
        return 20;
    }

    public int tokenBufferLength() {
        return this.buffer.getInt(this.offset + 16);
    }

    public TerminateDriverFlyweight tokenBuffer(DirectBuffer directBuffer, int n2, int n3) {
        this.buffer.putInt(this.offset + 16, n3);
        if (null != directBuffer && n3 > 0) {
            this.buffer.putBytes(this.offset + this.tokenBufferOffset(), directBuffer, n2, n3);
        }
        return this;
    }

    public int length() {
        return 20 + this.tokenBufferLength();
    }

    @Override
    public void validateLength(int n2, int n3) {
        if (n3 < 20) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short: length=" + n3);
        }
        if (n3 - 20 < this.buffer.getInt(this.offset + 16)) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short for token buffer: length=" + n3);
        }
    }

    public static int computeLength(int n2) {
        if (n2 < 0) {
            throw new ConfigurationException("token length must be >= 0: " + n2);
        }
        return 20 + n2;
    }
}

