/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools.rectangle.change;

import impl.org.controlsfx.tools.MathTools;
import impl.org.controlsfx.tools.rectangle.change.AbstractPreviousRectangleChangeStrategy;
import java.util.Objects;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

public class MoveChangeStrategy
extends AbstractPreviousRectangleChangeStrategy {
    private final Rectangle2D bounds;
    private Point2D startingPoint;

    public MoveChangeStrategy(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        super(rectangle2D, false, 0.0);
        Objects.requireNonNull(rectangle2D2, "The specified bounds must not be null.");
        this.bounds = rectangle2D2;
    }

    public MoveChangeStrategy(Rectangle2D rectangle2D, double d2, double d3) {
        super(rectangle2D, false, 0.0);
        if (d2 < rectangle2D.getWidth()) {
            throw new IllegalArgumentException("The specified maximal x-coordinate must be greater than or equal to the previous rectangle's width.");
        }
        if (d3 < rectangle2D.getHeight()) {
            throw new IllegalArgumentException("The specified maximal y-coordinate must be greater than or equal to the previous rectangle's height.");
        }
        this.bounds = new Rectangle2D(0.0, 0.0, d2, d3);
    }

    private final Rectangle2D moveRectangleToPoint(Point2D point2D) {
        double d2 = point2D.getX() - this.startingPoint.getX();
        double d3 = point2D.getY() - this.startingPoint.getY();
        double d4 = this.getPrevious().getMinX() + d2;
        double d5 = this.getPrevious().getMinY() + d3;
        double d6 = this.bounds.getMaxX() - this.getPrevious().getWidth();
        double d7 = this.bounds.getMaxY() - this.getPrevious().getHeight();
        double d8 = MathTools.inInterval(this.bounds.getMinX(), d4, d6);
        double d9 = MathTools.inInterval(this.bounds.getMinY(), d5, d7);
        return new Rectangle2D(d8, d9, this.getPrevious().getWidth(), this.getPrevious().getHeight());
    }

    @Override
    protected Rectangle2D doBegin(Point2D point2D) {
        this.startingPoint = point2D;
        return this.getPrevious();
    }

    @Override
    protected Rectangle2D doContinue(Point2D point2D) {
        return this.moveRectangleToPoint(point2D);
    }

    @Override
    protected Rectangle2D doEnd(Point2D point2D) {
        return this.moveRectangleToPoint(point2D);
    }
}

