/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.SortUtils;
import impl.org.controlsfx.tableview2.TableHeaderRow2;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SortEvent;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.tableview2.FilteredTableColumn;
import org.controlsfx.control.tableview2.FilteredTableView;
import org.controlsfx.control.tableview2.TableColumn2;
import org.controlsfx.control.tableview2.TableView2;

public class RowHeader<S>
extends StackPane {
    private final TableView2<S> tableView;
    private TableView2Skin<S> skin;
    private TableView2Skin<S> innerSkin;
    private double tableColumnHeaderHeight;
    private final TableView2<S> innerTableView;
    private final DoubleProperty innerRowHeaderWidth = new SimpleDoubleProperty();
    private Rectangle clip;
    private ListChangeListener<Integer> tableSelectionListener;
    private ListChangeListener<Integer> rowHeaderSelectionListener;
    private boolean sorting;
    private final InvalidationListener layout = observable -> this.requestLayout();

    public RowHeader(TableView2<S> tableView2) {
        this.tableView = tableView2;
        this.getStyleClass().add((Object)"row-header");
        this.innerTableView = tableView2 instanceof FilteredTableView ? new FilteredTableView() : new TableView2();
        this.innerTableView.setColumnFixingEnabled(false);
        this.innerTableView.setRowHeaderVisible(false);
        this.innerTableView.setEditable(false);
        this.innerTableView.setPlaceholder((Node)new Label());
        this.innerTableView.setSortPolicy(tableView -> false);
    }

    void init(TableView2Skin<S> tableView2Skin, TableHeaderRow2 tableHeaderRow2) {
        this.skin = tableView2Skin;
        tableHeaderRow2.heightProperty().addListener((observableValue, number, number2) -> {
            this.tableColumnHeaderHeight = number2.doubleValue();
            this.requestLayout();
        });
        this.clip = new Rectangle(this.getRowHeaderWidth(), this.snapSize(this.tableView.getHeight() - this.tableView.snappedTopInset() - this.tableView.snappedBottomInset()));
        this.clip.relocate(this.snappedTopInset(), this.snappedLeftInset());
        this.clip.setSmooth(false);
        this.clip.heightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.tableView.getHeight() - this.tableView.snappedTopInset() - this.tableView.snappedBottomInset(), (Observable[])new Observable[]{this.tableView.heightProperty()}));
        this.clip.widthProperty().bind((ObservableValue)this.innerRowHeaderWidth);
        this.setClip((Node)this.clip);
        this.tableView.rowHeaderVisibleProperty().addListener(this.layout);
        this.tableView.getFixedRows().addListener(this.layout);
        this.tableView.rowHeaderWidthProperty().addListener(this.layout);
        this.tableView.heightProperty().addListener(this.layout);
        tableView2Skin.getHBar().visibleProperty().addListener(this.layout);
        this.tableView.fixedCellSizeProperty().addListener(observable -> {
            this.innerTableView.refresh();
            this.innerTableView.requestLayout();
        });
        this.tableView.rowFixingEnabledProperty().addListener(observable -> {
            this.innerTableView.setRowFixingEnabled(this.tableView.isRowFixingEnabled());
            this.innerTableView.refresh();
            this.innerTableView.requestLayout();
        });
        this.tableView.getVisibleLeafColumns().addListener(observable -> {
            if (this.tableView.getVisibleLeafColumns().isEmpty() != this.innerTableView.getColumns().isEmpty()) {
                this.setContent();
            }
        });
        this.tableView.rowHeaderProperty().addListener(observable -> this.setContent());
        this.setContent();
        this.innerTableView.itemsProperty().bind((ObservableValue)this.tableView.itemsProperty());
        this.innerTableView.getFixedRows().setAll((Collection)this.tableView.getFixedRows().stream().collect(Collectors.toList()));
        this.tableView.getFixedRows().addListener(observable -> this.innerTableView.getFixedRows().setAll((Collection)this.tableView.getFixedRows().stream().collect(Collectors.toList())));
        this.innerTableView.skinProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RowHeader.this.innerSkin = (TableView2Skin)RowHeader.this.innerTableView.getSkin();
                RowHeader.this.setScrollbars();
                RowHeader.this.innerTableView.skinProperty().removeListener((InvalidationListener)this);
            }
        });
        this.innerTableView.getSelectionModel().selectionModeProperty().bind((ObservableValue)this.tableView.getSelectionModel().selectionModeProperty());
        this.rowHeaderSelectionListener = change -> {
            tableView2Skin.getSelectedRows().removeListener(this.tableSelectionListener);
            while (change.next()) {
                change.getRemoved().forEach(n2 -> {
                    if (this.tableView.getSelectionModel().isCellSelectionEnabled()) {
                        this.tableView.getVisibleLeafColumns().forEach(tableColumn -> this.tableView.getSelectionModel().clearSelection(n2.intValue(), tableColumn));
                    } else {
                        this.tableView.getSelectionModel().clearSelection(n2.intValue());
                    }
                });
                change.getAddedSubList().forEach(n2 -> this.tableView.getSelectionModel().select(n2.intValue()));
            }
            tableView2Skin.getSelectedRows().addListener(this.tableSelectionListener);
        };
        this.tableSelectionListener = change -> {
            this.innerTableView.getSelectionModel().getSelectedIndices().removeListener(this.rowHeaderSelectionListener);
            while (change.next()) {
                change.getRemoved().forEach(n2 -> this.innerTableView.getSelectionModel().clearSelection(n2.intValue()));
                change.getAddedSubList().forEach(n2 -> this.innerTableView.getSelectionModel().select(n2.intValue()));
            }
            if (!this.sorting) {
                this.innerTableView.getSelectionModel().getSelectedIndices().addListener(this.rowHeaderSelectionListener);
            }
        };
        ChangeListener changeListener = (observableValue, bl2, bl3) -> {
            if (!this.tableView.isFocused() && !this.innerTableView.isFocused()) {
                this.tableView.setStyle("-fx-selection-bar-non-focused: lightgrey;");
                this.innerTableView.setStyle("-fx-selection-bar-non-focused: lightgrey;");
            } else {
                this.innerTableView.setStyle("-fx-selection-bar-non-focused: -fx-accent;");
                this.tableView.setStyle("-fx-selection-bar-non-focused: -fx-accent;");
            }
        };
        this.innerTableView.getSelectionModel().getSelectedIndices().addListener(this.rowHeaderSelectionListener);
        tableView2Skin.getSelectedRows().addListener(this.tableSelectionListener);
        this.tableView.addEventHandler(SortEvent.ANY, sortEvent -> {
            if (sortEvent != null && SortUtils.SortStartedEvent.SORT_STARTED_EVENT.equals((Object)sortEvent.getEventType())) {
                this.sorting = true;
                this.innerTableView.getSelectionModel().getSelectedIndices().removeListener(this.rowHeaderSelectionListener);
            } else if (sortEvent != null && SortUtils.SortEndedEvent.SORT_ENDED_EVENT.equals((Object)sortEvent.getEventType())) {
                this.sorting = false;
                if (this.innerSkin != null) {
                    this.innerSkin.getFlow().rebuildFixedCells();
                }
                this.innerTableView.getSelectionModel().clearSelection();
                if (this.innerTableView.getItems() != null) {
                    tableView2Skin.getSelectedRows().forEach(n2 -> this.innerTableView.getSelectionModel().select(n2.intValue()));
                }
                this.innerTableView.getSelectionModel().getSelectedIndices().addListener(this.rowHeaderSelectionListener);
            }
        });
        this.innerTableView.southHeaderBlendedProperty().bind((ObservableValue)this.tableView.southHeaderBlendedProperty());
        this.tableView.focusedProperty().addListener(changeListener);
        this.innerTableView.focusedProperty().addListener(changeListener);
    }

    public double getRowHeaderWidth() {
        return this.innerRowHeaderWidth.get();
    }

    public ReadOnlyDoubleProperty rowHeaderWidthProperty() {
        return this.innerRowHeaderWidth;
    }

    public double computeHeaderWidth() {
        double d2 = 0.0;
        if (this.tableView.isRowHeaderVisible()) {
            d2 += this.tableView.getRowHeaderWidth();
        }
        return d2;
    }

    public TableView2<S> getParentTableView() {
        return this.tableView;
    }

    protected void layoutChildren() {
        if (this.tableView.isRowHeaderVisible()) {
            Label label;
            TableHeaderRow2 tableHeaderRow2;
            double d2 = this.snappedLeftInset();
            this.innerRowHeaderWidth.setValue((Number)this.tableView.getRowHeaderWidth());
            if (this.getChildren().isEmpty()) {
                this.getChildren().setAll((Object[])new Node[]{this.innerTableView});
            }
            if (this.innerSkin != null) {
                tableHeaderRow2 = this.innerSkin.getTableHeaderRow2();
                tableHeaderRow2.setPrefHeight(this.tableColumnHeaderHeight);
            }
            double d3 = (tableHeaderRow2 = this.skin.getHBar()).isVisible() && this.tableView.getItems() != null && !this.tableView.getItems().isEmpty() ? this.snapSize(tableHeaderRow2.getHeight()) : 0.0;
            this.innerTableView.resizeRelocate(d2, 0.0, this.innerRowHeaderWidth.get(), this.tableView.getHeight() - d3 - this.tableView.snappedTopInset() - this.tableView.snappedBottomInset());
            if (!this.innerTableView.getColumns().isEmpty()) {
                ((TableColumn)this.innerTableView.getColumns().get(0)).setPrefWidth(this.innerRowHeaderWidth.get());
            }
            if (this.getChildren().size() == 1) {
                label = new Label("");
                label.getStyleClass().setAll((Object[])new String[]{"hbar"});
                this.getChildren().add((Object)label);
            } else {
                label = (Label)this.getChildren().get(1);
            }
            label.resizeRelocate(this.snappedLeftInset(), this.getHeight() - this.snappedBottomInset() - d3, this.innerRowHeaderWidth.get(), d3);
        } else {
            this.getChildren().clear();
            this.innerRowHeaderWidth.setValue((Number)0);
        }
    }

    private void setContent() {
        this.innerTableView.getColumns().clear();
        if (this.tableView.getVisibleLeafColumns().isEmpty()) {
            return;
        }
        if (this.tableView.getRowHeader() != null) {
            this.innerTableView.getColumns().add(this.tableView.getRowHeader());
        } else {
            this.innerTableView.getColumns().add(this.getDefaultTableColumn());
        }
    }

    private TableColumn2<S, String> getDefaultTableColumn() {
        TableColumn2 tableColumn2;
        if (this.tableView instanceof FilteredTableView) {
            tableColumn2 = new FilteredTableColumn();
            ((FilteredTableColumn)tableColumn2).setOnFilterAction((EventHandler<ActionEvent>)((EventHandler)event -> {
                if (((FilteredTableView)this.tableView).getPredicate() != null) {
                    ((FilteredTableView)this.tableView).resetFilter();
                }
            }));
        } else {
            tableColumn2 = new TableColumn2();
        }
        tableColumn2.setSortable(false);
        tableColumn2.setCellValueFactory(cellDataFeatures -> new SimpleStringProperty(String.valueOf(cellDataFeatures.getTableView().getItems().indexOf(cellDataFeatures.getValue()) + 1)));
        return tableColumn2;
    }

    private void setScrollbars() {
        ScrollBar scrollBar = this.skin.getVBar();
        ScrollBar scrollBar2 = this.innerSkin.getVBar();
        scrollBar2.setMin(scrollBar.getMin());
        scrollBar2.setMax(scrollBar.getMax());
        scrollBar2.valueProperty().bindBidirectional((Property)scrollBar.valueProperty());
        this.innerSkin.getFlow().adjustedPixelsProperty().bindBidirectional((Property)this.skin.getFlow().adjustedPixelsProperty());
    }
}

