/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import java.util.Iterator;
import java.util.Stack;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.Picker;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalPicker
extends StackPane {
    private static final String PICKER_INDEX = "PickerIndex";
    private final HorizontalHeader horizontalHeader;
    private final SpreadsheetView spv;
    private final Stack<Label> pickerPile;
    private final Stack<Label> pickerUsed;
    private final InnerHorizontalPicker innerPicker = new InnerHorizontalPicker();
    private final EventHandler<MouseEvent> pickerMouseEvent = mouseEvent -> {
        Label label = (Label)mouseEvent.getSource();
        ((Picker)label.getProperties().get((Object)PICKER_INDEX)).onClick();
    };
    private final InvalidationListener layoutListener = observable -> this.innerPicker.requestLayout();

    public HorizontalPicker(HorizontalHeader horizontalHeader, SpreadsheetView spreadsheetView) {
        this.horizontalHeader = horizontalHeader;
        this.spv = spreadsheetView;
        this.pickerPile = new Stack();
        this.pickerUsed = new Stack();
        Rectangle rectangle = new Rectangle();
        rectangle.setSmooth(true);
        rectangle.setHeight(16.0);
        rectangle.widthProperty().bind((ObservableValue)horizontalHeader.widthProperty());
        this.setClip((Node)rectangle);
        this.getChildren().add((Object)this.innerPicker);
        horizontalHeader.getRootHeader().getColumnHeaders().addListener(this.layoutListener);
        spreadsheetView.getColumnPickers().addListener(this.layoutListener);
    }

    protected void layoutChildren() {
        this.innerPicker.relocate(this.horizontalHeader.getRootHeader().getLayoutX(), this.snappedTopInset());
        Iterator iterator = this.pickerUsed.iterator();
        while (iterator.hasNext()) {
            Label label;
            label.setVisible((label = (Label)iterator.next()).getLayoutX() + this.innerPicker.getLayoutX() + label.getWidth() > this.horizontalHeader.gridViewSkin.fixedColumnWidth);
        }
    }

    public void updateScrollX() {
        this.requestLayout();
    }

    private Label getPicker(Picker picker) {
        Label label;
        if (this.pickerPile.isEmpty()) {
            label = new Label();
            label.getStyleClass().addListener(this.layoutListener);
            label.setOnMouseClicked(this.pickerMouseEvent);
        } else {
            label = this.pickerPile.pop();
        }
        this.pickerUsed.push(label);
        label.getStyleClass().setAll(picker.getStyleClass());
        label.getProperties().put((Object)PICKER_INDEX, (Object)picker);
        return label;
    }

    private class InnerHorizontalPicker
    extends Region {
        private InnerHorizontalPicker() {
        }

        protected void layoutChildren() {
            HorizontalPicker.this.pickerPile.addAll(HorizontalPicker.this.pickerUsed.subList(0, HorizontalPicker.this.pickerUsed.size()));
            for (Label label : HorizontalPicker.this.pickerUsed) {
                label.layoutXProperty().unbind();
                label.setVisible(true);
            }
            HorizontalPicker.this.pickerUsed.clear();
            this.getChildren().clear();
            int n2 = 0;
            for (TableColumnHeader tableColumnHeader : HorizontalPicker.this.horizontalHeader.getRootHeader().getColumnHeaders()) {
                int n3 = HorizontalPicker.this.spv.getModelColumn(n2);
                if (HorizontalPicker.this.spv.getColumnPickers().containsKey((Object)n3)) {
                    Label label = HorizontalPicker.this.getPicker((Picker)HorizontalPicker.this.spv.getColumnPickers().get((Object)n3));
                    label.resize(tableColumnHeader.getWidth(), 16.0);
                    label.layoutXProperty().bind((ObservableValue)tableColumnHeader.layoutXProperty());
                    this.getChildren().add(0, (Object)label);
                }
                ++n2;
            }
        }
    }
}

