/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import java.util.Collections;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.Rating;
import org.controlsfx.tools.Utils;

public class RatingSkin
extends SkinBase<Rating> {
    private static final String STRONG = "strong";
    private boolean updateOnHover;
    private boolean partialRating;
    private Pane backgroundContainer;
    private Pane foregroundContainer;
    private double rating = -1.0;
    private Rectangle forgroundClipRect;
    private final EventHandler<MouseEvent> mouseMoveHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (RatingSkin.this.updateOnHover) {
                RatingSkin.this.updateRatingFromMouseEvent(mouseEvent);
            }
        }
    };
    private final EventHandler<MouseEvent> mouseClickHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (!RatingSkin.this.updateOnHover) {
                RatingSkin.this.updateRatingFromMouseEvent(mouseEvent);
            }
        }
    };

    private void updateRatingFromMouseEvent(MouseEvent mouseEvent) {
        Rating rating = (Rating)this.getSkinnable();
        if (!rating.ratingProperty().isBound()) {
            Point2D point2D = new Point2D(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            rating.setRating(this.calculateRating(point2D));
        }
    }

    public RatingSkin(Rating rating) {
        super((Control)rating);
        this.updateOnHover = rating.isUpdateOnHover();
        this.partialRating = rating.isPartialRating();
        this.recreateButtons();
        this.updateRating();
        this.registerChangeListener((ObservableValue)rating.ratingProperty(), observableValue -> this.updateRating());
        this.registerChangeListener((ObservableValue)rating.maxProperty(), observableValue -> this.recreateButtons());
        this.registerChangeListener((ObservableValue)rating.orientationProperty(), observableValue -> this.recreateButtons());
        this.registerChangeListener((ObservableValue)rating.updateOnHoverProperty(), observableValue -> {
            this.updateOnHover = ((Rating)this.getSkinnable()).isUpdateOnHover();
            this.recreateButtons();
        });
        this.registerChangeListener((ObservableValue)rating.partialRatingProperty(), observableValue -> {
            this.partialRating = ((Rating)this.getSkinnable()).isPartialRating();
            this.recreateButtons();
        });
        this.registerChangeListener((ObservableValue)rating.boundsInLocalProperty(), observableValue -> {
            if (this.partialRating) {
                this.updateClip();
            }
        });
    }

    private void recreateButtons() {
        this.backgroundContainer = null;
        this.foregroundContainer = null;
        this.backgroundContainer = this.isVertical() ? new VBox() : new HBox();
        this.backgroundContainer.getStyleClass().add((Object)"container");
        this.getChildren().setAll((Object[])new Node[]{this.backgroundContainer});
        if (this.updateOnHover || this.partialRating) {
            this.foregroundContainer = this.isVertical() ? new VBox() : new HBox();
            this.foregroundContainer.getStyleClass().add((Object)"container");
            this.foregroundContainer.setMouseTransparent(true);
            this.getChildren().add((Object)this.foregroundContainer);
            this.forgroundClipRect = new Rectangle();
            this.foregroundContainer.setClip((Node)this.forgroundClipRect);
        }
        for (int i2 = 0; i2 <= ((Rating)this.getSkinnable()).getMax(); ++i2) {
            Node node = this.createButton();
            if (i2 <= 0) continue;
            if (this.isVertical()) {
                this.backgroundContainer.getChildren().add(0, (Object)node);
            } else {
                this.backgroundContainer.getChildren().add((Object)node);
            }
            if (!this.partialRating) continue;
            Node node2 = this.createButton();
            node2.getStyleClass().add((Object)STRONG);
            node2.setMouseTransparent(true);
            if (this.isVertical()) {
                this.foregroundContainer.getChildren().add(0, (Object)node2);
                continue;
            }
            this.foregroundContainer.getChildren().add((Object)node2);
        }
        this.updateRating();
    }

    private double calculateRating(Point2D point2D) {
        Point2D point2D2 = this.backgroundContainer.sceneToLocal(point2D);
        double d2 = point2D2.getX();
        double d3 = point2D2.getY();
        Rating rating = (Rating)this.getSkinnable();
        int n2 = rating.getMax();
        double d4 = rating.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double d5 = rating.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double d6 = -1.0;
        d6 = this.isVertical() ? (d5 - d3) / d5 * (double)n2 : d2 / d4 * (double)n2;
        if (!this.partialRating) {
            d6 = Utils.clamp(1.0, Math.ceil(d6), rating.getMax());
        }
        return d6;
    }

    private void updateClip() {
        Rating rating = (Rating)this.getSkinnable();
        double d2 = rating.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double d3 = rating.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        if (this.isVertical()) {
            double d4 = d2 * this.rating / (double)rating.getMax();
            this.forgroundClipRect.relocate(0.0, d2 - d4);
            this.forgroundClipRect.setWidth(rating.getWidth());
            this.forgroundClipRect.setHeight(d4);
        } else {
            double d5 = d3 * this.rating / (double)rating.getMax();
            this.forgroundClipRect.setWidth(d5);
            this.forgroundClipRect.setHeight(rating.getHeight());
        }
    }

    protected Node createButtonNode() {
        return new Region();
    }

    private Node createButton() {
        Node node = this.createButtonNode();
        node.getStyleClass().add((Object)"button");
        node.setOnMouseMoved(this.mouseMoveHandler);
        node.setOnMouseClicked(this.mouseClickHandler);
        return node;
    }

    private void updateRating() {
        double d2 = ((Rating)this.getSkinnable()).getRating();
        if (d2 == this.rating) {
            return;
        }
        this.rating = Utils.clamp(0.0, d2, ((Rating)this.getSkinnable()).getMax());
        if (this.partialRating) {
            this.updateClip();
        } else {
            this.updateButtonStyles();
        }
    }

    private void updateButtonStyles() {
        int n2 = ((Rating)this.getSkinnable()).getMax();
        ArrayList arrayList = new ArrayList(this.backgroundContainer.getChildren());
        if (this.isVertical()) {
            Collections.reverse(arrayList);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)arrayList.get(i2);
            ObservableList observableList = node.getStyleClass();
            boolean bl2 = observableList.contains(STRONG);
            if ((double)i2 < this.rating) {
                if (bl2) continue;
                observableList.add(STRONG);
                continue;
            }
            if (!bl2) continue;
            observableList.remove(STRONG);
        }
    }

    private boolean isVertical() {
        return ((Rating)this.getSkinnable()).getOrientation() == Orientation.VERTICAL;
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefWidth(d2, d3, d4, d5, d6);
    }
}

