/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.controlsfx.control.HiddenSidesPane;

public class HiddenSidesPaneSkin
extends SkinBase<HiddenSidesPane> {
    private static final String SHOW = "showPane";
    private final StackPane stackPane;
    private final EventHandler<MouseEvent> exitedHandler;
    private boolean mousePressed;
    private final MapChangeListener<Object, Object> propertiesMapListener = change -> {
        if (change.wasAdded() && SHOW.equals(change.getKey())) {
            Object object = change.getValueAdded();
            if (object == null) {
                this.hide();
            } else if (object instanceof Side) {
                this.show((Side)object);
            }
            ((HiddenSidesPane)this.getSkinnable()).getProperties().remove((Object)SHOW);
        }
    };
    private DoubleProperty[] visibility = new SimpleDoubleProperty[Side.values().length];
    private Timeline showTimeline;
    private Timeline hideTimeline;

    public HiddenSidesPaneSkin(HiddenSidesPane hiddenSidesPane) {
        super((Control)hiddenSidesPane);
        this.exitedHandler = mouseEvent -> {
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null && !this.mousePressed) {
                this.hide();
            }
        };
        this.stackPane = new StackPane();
        this.getChildren().add((Object)this.stackPane);
        this.updateStackPane();
        InvalidationListener invalidationListener = observable -> this.updateStackPane();
        hiddenSidesPane.contentProperty().addListener(invalidationListener);
        hiddenSidesPane.topProperty().addListener(invalidationListener);
        hiddenSidesPane.rightProperty().addListener(invalidationListener);
        hiddenSidesPane.bottomProperty().addListener(invalidationListener);
        hiddenSidesPane.leftProperty().addListener(invalidationListener);
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_MOVED, mouseEvent -> {
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null) {
                Side side = this.getSide((MouseEvent)mouseEvent);
                if (side != null) {
                    this.show(side);
                } else if (this.isMouseMovedOutsideSides((MouseEvent)mouseEvent)) {
                    this.hide();
                }
            }
        });
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.mousePressed = true;
        });
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.mousePressed = false;
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null) {
                Side side = this.getSide((MouseEvent)mouseEvent);
                if (side != null) {
                    this.show(side);
                } else {
                    this.hide();
                }
            }
        });
        for (Side side : Side.values()) {
            this.visibility[side.ordinal()] = new SimpleDoubleProperty(0.0);
            this.visibility[side.ordinal()].addListener(observable -> ((HiddenSidesPane)this.getSkinnable()).requestLayout());
        }
        Side side = ((HiddenSidesPane)this.getSkinnable()).getPinnedSide();
        if (side != null) {
            this.show(side);
        }
        hiddenSidesPane.pinnedSideProperty().addListener(observable -> this.show(((HiddenSidesPane)this.getSkinnable()).getPinnedSide()));
        ObservableMap observableMap = hiddenSidesPane.getProperties();
        observableMap.remove((Object)SHOW);
        observableMap.addListener(this.propertiesMapListener);
        Rectangle rectangle = new Rectangle();
        rectangle.setX(0.0);
        rectangle.setY(0.0);
        rectangle.widthProperty().bind((ObservableValue)((HiddenSidesPane)this.getSkinnable()).widthProperty());
        rectangle.heightProperty().bind((ObservableValue)((HiddenSidesPane)this.getSkinnable()).heightProperty());
        ((HiddenSidesPane)this.getSkinnable()).setClip((Node)rectangle);
    }

    private boolean isMouseMovedOutsideSides(MouseEvent mouseEvent) {
        if (((HiddenSidesPane)this.getSkinnable()).getLeft() != null && ((HiddenSidesPane)this.getSkinnable()).getLeft().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            return false;
        }
        if (((HiddenSidesPane)this.getSkinnable()).getTop() != null && ((HiddenSidesPane)this.getSkinnable()).getTop().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            return false;
        }
        if (((HiddenSidesPane)this.getSkinnable()).getRight() != null && ((HiddenSidesPane)this.getSkinnable()).getRight().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            return false;
        }
        return ((HiddenSidesPane)this.getSkinnable()).getBottom() == null || !((HiddenSidesPane)this.getSkinnable()).getBottom().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean isMouseEnabled() {
        return ((HiddenSidesPane)this.getSkinnable()).getTriggerDistance() > 0.0;
    }

    private Side getSide(MouseEvent mouseEvent) {
        if (this.stackPane.getBoundsInLocal().contains(mouseEvent.getX(), mouseEvent.getY())) {
            double d2 = ((HiddenSidesPane)this.getSkinnable()).getTriggerDistance();
            if (mouseEvent.getX() <= d2) {
                return Side.LEFT;
            }
            if (mouseEvent.getX() > ((HiddenSidesPane)this.getSkinnable()).getWidth() - d2) {
                return Side.RIGHT;
            }
            if (mouseEvent.getY() <= d2) {
                return Side.TOP;
            }
            if (mouseEvent.getY() > ((HiddenSidesPane)this.getSkinnable()).getHeight() - d2) {
                return Side.BOTTOM;
            }
        }
        return null;
    }

    private void show(Side side) {
        if (this.hideTimeline != null) {
            this.hideTimeline.stop();
        }
        if (this.showTimeline != null && this.showTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        KeyValue[] keyValueArray = new KeyValue[Side.values().length];
        for (Side side2 : Side.values()) {
            keyValueArray[side2.ordinal()] = new KeyValue((WritableValue)this.visibility[side2.ordinal()], (Object)(side2.equals((Object)side) ? 1 : 0));
        }
        Duration duration = ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() != null ? ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() : Duration.millis((double)300.0);
        Duration duration2 = ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() != null ? ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() : Duration.millis((double)200.0);
        KeyFrame keyFrame = new KeyFrame(duration2, keyValueArray);
        this.showTimeline = new Timeline(new KeyFrame[]{keyFrame});
        this.showTimeline.setDelay(duration);
        this.showTimeline.play();
    }

    private void hide() {
        if (this.showTimeline != null) {
            this.showTimeline.stop();
        }
        if (this.hideTimeline != null && this.hideTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        boolean bl2 = false;
        for (Side side : Side.values()) {
            if (!(this.visibility[side.ordinal()].get() > 0.0)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return;
        }
        Side[] sideArray = new KeyValue[Side.values().length];
        for (Side side : Side.values()) {
            sideArray[side.ordinal()] = new KeyValue((WritableValue)this.visibility[side.ordinal()], (Object)0);
        }
        Duration duration = ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() != null ? ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() : Duration.millis((double)300.0);
        Duration duration2 = ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() != null ? ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() : Duration.millis((double)200.0);
        KeyFrame keyFrame = new KeyFrame(duration2, (KeyValue[])sideArray);
        this.hideTimeline = new Timeline(new KeyFrame[]{keyFrame});
        this.hideTimeline.setDelay(duration);
        this.hideTimeline.play();
    }

    private void updateStackPane() {
        this.stackPane.getChildren().clear();
        if (((HiddenSidesPane)this.getSkinnable()).getContent() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getContent());
        }
        if (((HiddenSidesPane)this.getSkinnable()).getTop() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getTop());
            ((HiddenSidesPane)this.getSkinnable()).getTop().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getTop().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getTop().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getRight() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getRight());
            ((HiddenSidesPane)this.getSkinnable()).getRight().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getRight().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getRight().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getBottom() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getBottom());
            ((HiddenSidesPane)this.getSkinnable()).getBottom().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getBottom().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getBottom().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getLeft() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getLeft());
            ((HiddenSidesPane)this.getSkinnable()).getLeft().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getLeft().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getLeft().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        Node node;
        Node node2;
        double d6;
        Node node3;
        double d7;
        super.layoutChildren(d2, d3, d4, d5);
        Node node4 = ((HiddenSidesPane)this.getSkinnable()).getBottom();
        if (node4 != null) {
            double d8 = node4.prefHeight(-1.0);
            d7 = d8 * this.visibility[Side.BOTTOM.ordinal()].get();
            node4.resizeRelocate(d2, d3 + d5 - d7, d4, d8);
            node4.setVisible(this.visibility[Side.BOTTOM.ordinal()].get() > 0.0);
        }
        if ((node3 = ((HiddenSidesPane)this.getSkinnable()).getLeft()) != null) {
            double d9 = node3.prefWidth(-1.0);
            d6 = d9 * this.visibility[Side.LEFT.ordinal()].get();
            node3.resizeRelocate(d2 - (d9 - d6), d3, d9, d5);
            node3.setVisible(this.visibility[Side.LEFT.ordinal()].get() > 0.0);
        }
        if ((node2 = ((HiddenSidesPane)this.getSkinnable()).getRight()) != null) {
            d7 = node2.prefWidth(-1.0);
            double d10 = d7 * this.visibility[Side.RIGHT.ordinal()].get();
            node2.resizeRelocate(d2 + d4 - d10, d3, d7, d5);
            node2.setVisible(this.visibility[Side.RIGHT.ordinal()].get() > 0.0);
        }
        if ((node = ((HiddenSidesPane)this.getSkinnable()).getTop()) != null) {
            d6 = node.prefHeight(-1.0);
            double d11 = d6 * this.visibility[Side.TOP.ordinal()].get();
            node.resizeRelocate(d2, d3 - (d6 - d11), d4, d6);
            node.setVisible(this.visibility[Side.TOP.ordinal()].get() > 0.0);
        }
    }
}

