/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.StackPane;
import javafx.scene.text.HitInfo;

public abstract class CustomTextFieldSkin
extends TextFieldSkin {
    private static final PseudoClass HAS_NO_SIDE_NODE = PseudoClass.getPseudoClass((String)"no-side-nodes");
    private static final PseudoClass HAS_LEFT_NODE = PseudoClass.getPseudoClass((String)"left-node-visible");
    private static final PseudoClass HAS_RIGHT_NODE = PseudoClass.getPseudoClass((String)"right-node-visible");
    private Node left;
    private StackPane leftPane;
    private Node right;
    private StackPane rightPane;
    private final TextField control;

    public CustomTextFieldSkin(TextField textField) {
        super(textField);
        this.control = textField;
        this.updateChildren();
        this.registerChangeListener((ObservableValue)this.leftProperty(), observableValue -> this.updateChildren());
        this.registerChangeListener((ObservableValue)this.rightProperty(), observableValue -> this.updateChildren());
    }

    public abstract ObjectProperty<Node> leftProperty();

    public abstract ObjectProperty<Node> rightProperty();

    private void updateChildren() {
        Node node = (Node)this.leftProperty().get();
        this.getChildren().remove((Object)this.leftPane);
        if (node != null) {
            this.leftPane = new StackPane(new Node[]{node});
            this.leftPane.setManaged(false);
            this.leftPane.setAlignment(Pos.CENTER_LEFT);
            this.leftPane.getStyleClass().add((Object)"left-pane");
            this.getChildren().add((Object)this.leftPane);
            this.left = node;
        } else {
            this.leftPane = null;
            this.left = null;
        }
        Node node2 = (Node)this.rightProperty().get();
        this.getChildren().remove((Object)this.rightPane);
        if (node2 != null) {
            this.rightPane = new StackPane(new Node[]{node2});
            this.rightPane.setManaged(false);
            this.rightPane.setAlignment(Pos.CENTER_RIGHT);
            this.rightPane.getStyleClass().add((Object)"right-pane");
            this.getChildren().add((Object)this.rightPane);
            this.right = node2;
        } else {
            this.rightPane = null;
            this.right = null;
        }
        this.control.pseudoClassStateChanged(HAS_LEFT_NODE, this.left != null);
        this.control.pseudoClassStateChanged(HAS_RIGHT_NODE, this.right != null);
        this.control.pseudoClassStateChanged(HAS_NO_SIDE_NODE, this.left == null && this.right == null);
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d5 + this.snappedTopInset() + this.snappedBottomInset();
        double d8 = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(d7));
        double d9 = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(d7));
        double d10 = this.snapPosition(d2) + this.snapSize(d8);
        double d11 = d4 - this.snapSize(d8) - this.snapSize(d9);
        super.layoutChildren(d10, 0.0, d11, d7);
        if (this.leftPane != null) {
            d6 = 0.0;
            this.leftPane.resizeRelocate(0.0, 0.0, d8, d7);
        }
        if (this.rightPane != null) {
            d6 = this.rightPane == null ? 0.0 : d4 - d9 + this.snappedLeftInset();
            this.rightPane.resizeRelocate(d6, 0.0, d9, d7);
        }
    }

    public HitInfo getIndex(double d2, double d3) {
        double d4 = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(((TextField)this.getSkinnable()).getHeight()));
        return super.getIndex(d2 - d4, d3);
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computePrefWidth(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(d2));
        double d9 = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(d2));
        return d7 + d8 + d9;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computePrefHeight(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefHeight(-1.0));
        double d9 = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefHeight(-1.0));
        return Math.max(d7, Math.max(d8, d9));
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computeMinWidth(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.minWidth(d2));
        double d9 = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.minWidth(d2));
        return d7 + d8 + d9;
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computeMinHeight(d2, d3, d4, d5, d6);
        double d8 = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.minHeight(-1.0));
        double d9 = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.minHeight(-1.0));
        return Math.max(d7, Math.max(d8, d9));
    }
}

