/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;
import org.controlsfx.control.BreadCrumbBar;

public class BreadCrumbBarSkin<T>
extends SkinBase<BreadCrumbBar<T>> {
    private static final String STYLE_CLASS_FIRST = "first";
    private final ChangeListener<TreeItem<T>> selectedPathChangeListener = (observableValue, treeItem, treeItem2) -> this.updateSelectedPath((TreeItem<T>)treeItem2, (TreeItem<T>)treeItem);
    private final EventHandler<TreeItem.TreeModificationEvent<Object>> treeChildrenModifiedHandler = treeModificationEvent -> this.updateBreadCrumbs();

    public BreadCrumbBarSkin(BreadCrumbBar<T> breadCrumbBar) {
        super(breadCrumbBar);
        breadCrumbBar.selectedCrumbProperty().addListener(this.selectedPathChangeListener);
        this.updateSelectedPath((TreeItem)((BreadCrumbBar)this.getSkinnable()).selectedCrumbProperty().get(), null);
    }

    private void updateSelectedPath(TreeItem<T> treeItem, TreeItem<T> treeItem2) {
        if (treeItem2 != null) {
            treeItem2.removeEventHandler(TreeItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        if (treeItem != null) {
            treeItem.addEventHandler(TreeItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        this.updateBreadCrumbs();
    }

    private void updateBreadCrumbs() {
        BreadCrumbBar breadCrumbBar = (BreadCrumbBar)this.getSkinnable();
        TreeItem treeItem = breadCrumbBar.getSelectedCrumb();
        Callback callback = breadCrumbBar.getCrumbFactory();
        this.getChildren().clear();
        if (treeItem != null) {
            List list = this.constructFlatPath(treeItem);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Button button = this.createCrumb(callback, list.get(i2));
                button.setMnemonicParsing(false);
                if (i2 == 0) {
                    if (!button.getStyleClass().contains((Object)STYLE_CLASS_FIRST)) {
                        button.getStyleClass().add((Object)STYLE_CLASS_FIRST);
                    }
                } else {
                    button.getStyleClass().remove((Object)STYLE_CLASS_FIRST);
                }
                this.getChildren().add((Object)button);
            }
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
            Node node = (Node)this.getChildren().get(i2);
            double d6 = this.snapSizeX(node.prefWidth(d5));
            double d7 = this.snapSizeY(node.prefHeight(-1.0));
            if (i2 > 0) {
                double d8 = node instanceof BreadCrumbBar.BreadCrumbButton ? ((BreadCrumbBar.BreadCrumbButton)node).getArrowWidth() : 0.0;
                d2 = this.snapPositionX(d2 - d8);
            }
            node.resize(d6, d7);
            node.relocate(d2, d3);
            d2 += d6;
        }
    }

    private List<TreeItem<T>> constructFlatPath(TreeItem<T> treeItem) {
        ArrayList<TreeItem<T>> arrayList = new ArrayList<TreeItem<T>>();
        TreeItem treeItem2 = treeItem;
        do {
            arrayList.add(treeItem2);
        } while ((treeItem2 = treeItem2.getParent()) != null);
        Collections.reverse(arrayList);
        return arrayList;
    }

    private Button createCrumb(Callback<TreeItem<T>, Button> callback, TreeItem<T> treeItem) {
        Button button = (Button)callback.call(treeItem);
        button.getStyleClass().add((Object)"crumb");
        button.setOnAction(actionEvent -> this.onBreadCrumbAction(treeItem));
        return button;
    }

    protected void onBreadCrumbAction(TreeItem<T> treeItem) {
        BreadCrumbBar breadCrumbBar = (BreadCrumbBar)this.getSkinnable();
        Event.fireEvent((EventTarget)breadCrumbBar, new BreadCrumbBar.BreadCrumbActionEvent<T>(treeItem));
        if (breadCrumbBar.isAutoNavigationEnabled()) {
            breadCrumbBar.setSelectedCrumb(treeItem);
        }
    }
}

