/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.layout.Region;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Optional<NestedTableColumnHeader> getRootHeaderFrom(TableHeaderRow tableHeaderRow) {
        try {
            Method method = tableHeaderRow.getClass().getDeclaredMethod("getRootHeader", new Class[0]);
            method.setAccessible(true);
            return Optional.of((NestedTableColumnHeader)method.invoke((Object)tableHeaderRow, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<Region> columnReorderLine(NestedTableColumnHeader nestedTableColumnHeader) {
        try {
            Field field = nestedTableColumnHeader.getClass().getDeclaredField("columnReorderLine");
            field.setAccessible(true);
            return Optional.of((Region)field.get(nestedTableColumnHeader));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<TableHeaderRow> getTableHeaderRowFrom(TableViewSkin<?> tableViewSkin) {
        try {
            Method method = tableViewSkin.getClass().getSuperclass().getDeclaredMethod("getTableHeaderRow", new Class[0]);
            method.setAccessible(true);
            return Optional.of((TableHeaderRow)method.invoke(tableViewSkin, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<TableViewSkinBase<?, ?, ?, ?, TableColumnBase<?, ?>>> getTableSkin(NestedTableColumnHeader nestedTableColumnHeader) {
        try {
            Method method = nestedTableColumnHeader.getClass().getDeclaredMethod("getTableSkin", new Class[0]);
            method.setAccessible(true);
            return Optional.of((TableViewSkinBase)method.invoke((Object)nestedTableColumnHeader, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return Optional.empty();
        }
    }

    public static VirtualFlow getVirtualFlow(TableViewSkinBase tableViewSkinBase) {
        Class<?> clazz = tableViewSkinBase.getClass();
        try {
            Field field = clazz.getDeclaredField("flow");
            field.setAccessible(true);
            return (VirtualFlow)field.get(tableViewSkinBase);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new RuntimeException("Cannot fetch VirtualFlow from TableViewSkinBase");
        }
    }

    public static Integer onScroll(TableViewSkinBase tableViewSkinBase, String string, Boolean bl2) {
        Class<?> clazz = tableViewSkinBase.getClass();
        try {
            Method method = clazz.getDeclaredMethod(string, Boolean.class);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)tableViewSkinBase, bl2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return -1;
        }
    }

    public static void callMethod(Object object, String string, Object ... objectArray) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getDeclaredMethod(string, (Class[])Arrays.stream(objectArray).map(Object::getClass).toArray(Class[]::new));
            method.setAccessible(true);
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("Cannot call method " + string + " on " + object.getClass());
        }
    }
}

