/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.utils.JFXNodeUtils;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXTreeCell<T>
extends TreeCell<T> {
    protected JFXRippler cellRippler = new JFXRippler((Node)this){

        @Override
        protected Node getMask() {
            Region region = new Region();
            JFXNodeUtils.updateBackground(JFXTreeCell.this.getBackground(), region);
            double d2 = this.control.getLayoutBounds().getWidth();
            double d3 = this.control.getLayoutBounds().getHeight();
            region.resize(d2, d3);
            return region;
        }

        @Override
        protected void positionControl(Node node) {
        }
    };
    private HBox hbox;
    private StackPane selectedPane = new StackPane();
    private InvalidationListener treeItemGraphicInvalidationListener = observable -> this.updateDisplay(this.getItem(), this.isEmpty());
    private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicInvalidationListener);
    private WeakReference<TreeItem<T>> treeItemRef;

    public JFXTreeCell() {
        this.selectedPane.getStyleClass().add((Object)"selection-bar");
        this.selectedPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.RED, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.selectedPane.setPrefWidth(3.0);
        this.selectedPane.setMouseTransparent(true);
        this.selectedProperty().addListener((observableValue, bl2, bl3) -> this.selectedPane.setVisible(bl3 != false));
        InvalidationListener invalidationListener = observable -> {
            TreeItem treeItem;
            TreeItem treeItem2;
            TreeItem treeItem3 = treeItem2 = this.treeItemRef == null ? null : (TreeItem)this.treeItemRef.get();
            if (treeItem2 != null) {
                treeItem2.graphicProperty().removeListener((InvalidationListener)this.weakTreeItemGraphicListener);
            }
            if ((treeItem = this.getTreeItem()) != null) {
                treeItem.graphicProperty().addListener((InvalidationListener)this.weakTreeItemGraphicListener);
                this.treeItemRef = new WeakReference<TreeItem>(treeItem);
            }
        };
        WeakInvalidationListener weakInvalidationListener = new WeakInvalidationListener(invalidationListener);
        this.treeItemProperty().addListener((InvalidationListener)weakInvalidationListener);
        if (this.getTreeItem() != null) {
            this.getTreeItem().graphicProperty().addListener((InvalidationListener)this.weakTreeItemGraphicListener);
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (!this.getChildren().contains((Object)this.selectedPane)) {
            this.getChildren().add(0, (Object)this.cellRippler);
            this.cellRippler.rippler.clear();
            this.getChildren().add(0, (Object)this.selectedPane);
        }
        this.cellRippler.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        this.cellRippler.releaseRipple();
        this.selectedPane.resizeRelocate(0.0, 0.0, this.selectedPane.prefWidth(-1.0), this.getHeight());
        this.selectedPane.setVisible(this.isSelected());
    }

    private void updateDisplay(T t2, boolean bl2) {
        if (t2 == null || bl2) {
            this.hbox = null;
            this.setText(null);
            this.setGraphic(null);
        } else {
            TreeItem treeItem = this.getTreeItem();
            if (treeItem != null && treeItem.getGraphic() != null) {
                if (t2 instanceof Node) {
                    this.setText(null);
                    if (this.hbox == null) {
                        this.hbox = new HBox(3.0);
                    }
                    this.hbox.getChildren().setAll((Object[])new Node[]{treeItem.getGraphic(), (Node)t2});
                    this.setGraphic((Node)this.hbox);
                } else {
                    this.hbox = null;
                    this.setText(t2.toString());
                    this.setGraphic(treeItem.getGraphic());
                }
            } else {
                this.hbox = null;
                if (t2 instanceof Node) {
                    this.setText(null);
                    this.setGraphic((Node)t2);
                } else {
                    this.setText(t2.toString());
                    this.setGraphic(null);
                }
            }
        }
    }

    protected void updateItem(T t2, boolean bl2) {
        super.updateItem(t2, bl2);
        this.updateDisplay(t2, bl2);
        this.setMouseTransparent(t2 == null || bl2);
    }
}

