/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXListCell;
import com.jfoenix.skins.JFXListViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.SizeConverter;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;

public class JFXListView<T>
extends ListView<T> {
    private ObjectProperty<Integer> depthProperty = new SimpleObjectProperty((Object)0);
    private ReadOnlyDoubleWrapper currentVerticalGapProperty = new ReadOnlyDoubleWrapper();
    private BooleanProperty showTooltip = new SimpleBooleanProperty(false);
    @Deprecated
    private ObjectProperty<Node> groupnode = new SimpleObjectProperty((Object)new Label("GROUP"));
    @Deprecated
    private ReadOnlyObjectWrapper<Integer> overAllIndexProperty = new ReadOnlyObjectWrapper((Object)-1);
    @Deprecated
    private ObjectProperty<ObservableList<JFXListView<?>>> sublistsProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    @Deprecated
    private LinkedHashMap<Integer, JFXListView<?>> sublistsIndices = new LinkedHashMap();
    private static final String DEFAULT_STYLE_CLASS = "jfx-list-view";
    private boolean allowClear = true;
    private StyleableDoubleProperty verticalGap = new SimpleStyleableDoubleProperty(StyleableProperties.access$000(), (Object)this, "verticalGap", Double.valueOf(0.0));
    private StyleableBooleanProperty expanded = new SimpleStyleableBooleanProperty(StyleableProperties.access$100(), (Object)this, "expanded", false);

    public JFXListView() {
        this.setCellFactory(listView -> new JFXListCell());
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXListViewSkin(this);
    }

    public ObjectProperty<Integer> depthProperty() {
        return this.depthProperty;
    }

    public int getDepth() {
        return (Integer)this.depthProperty.get();
    }

    public void setDepth(int n2) {
        this.depthProperty.set((Object)n2);
    }

    ReadOnlyDoubleProperty currentVerticalGapProperty() {
        return this.currentVerticalGapProperty.getReadOnlyProperty();
    }

    private void expand() {
        this.currentVerticalGapProperty.set(this.verticalGap.get());
    }

    private void collapse() {
        this.currentVerticalGapProperty.set(0.0);
    }

    public final BooleanProperty showTooltipProperty() {
        return this.showTooltip;
    }

    public final boolean isShowTooltip() {
        return this.showTooltipProperty().get();
    }

    public final void setShowTooltip(boolean bl2) {
        this.showTooltipProperty().set(bl2);
    }

    @Deprecated
    public Node getGroupnode() {
        return (Node)this.groupnode.get();
    }

    @Deprecated
    public void setGroupnode(Node node) {
        this.groupnode.set((Object)node);
    }

    @Deprecated
    public ReadOnlyObjectProperty<Integer> overAllIndexProperty() {
        return this.overAllIndexProperty.getReadOnlyProperty();
    }

    @Deprecated
    void addSublist(JFXListView<?> jFXListView, int n2) {
        if (!((ObservableList)this.sublistsProperty.get()).contains(jFXListView)) {
            ((ObservableList)this.sublistsProperty.get()).add(jFXListView);
            this.sublistsIndices.put(n2, jFXListView);
            jFXListView.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, number2) -> {
                if (number2.intValue() != -1) {
                    this.updateOverAllSelectedIndex();
                }
            });
        }
    }

    private void updateOverAllSelectedIndex() {
        if (this.getSelectionModel().getSelectedIndex() != -1) {
            int n2 = this.getSelectionModel().getSelectedIndex();
            Iterator<Map.Entry<Integer, JFXListView<?>>> iterator = this.sublistsIndices.entrySet().iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                Map.Entry<Integer, JFXListView<?>> entry = iterator.next();
                if (entry.getKey() >= n2) continue;
                n3 += entry.getValue().getItems().size() - 1;
            }
            this.overAllIndexProperty.set((Object)(n2 + n3));
        } else {
            Iterator<Map.Entry<Integer, JFXListView<?>>> iterator = this.sublistsIndices.entrySet().iterator();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (iterator.hasNext()) {
                Map.Entry<Integer, JFXListView<?>> entry = iterator.next();
                if (entry.getValue().getSelectionModel().getSelectedIndex() == -1) continue;
                arrayList.add(entry.getKey());
            }
            if (arrayList.size() > 0) {
                iterator = this.sublistsIndices.entrySet().iterator();
                int n4 = 0;
                while (iterator.hasNext()) {
                    Map.Entry<Integer, JFXListView<?>> entry = iterator.next();
                    if (entry.getKey() >= (Integer)arrayList.get(0)) continue;
                    n4 += entry.getValue().getItems().size() - 1;
                }
                this.overAllIndexProperty.set((Object)(n4 + (Integer)arrayList.get(0) + this.sublistsIndices.get(arrayList.get(0)).getSelectionModel().getSelectedIndex()));
            } else {
                this.overAllIndexProperty.set((Object)-1);
            }
        }
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.expanded.addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.expand();
            } else {
                this.collapse();
            }
        });
        this.verticalGap.addListener((observableValue, number, number2) -> {
            if (this.isExpanded().booleanValue()) {
                this.expand();
            } else {
                this.collapse();
            }
        });
        ((ObservableList)this.sublistsProperty.get()).addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded() && !change.wasUpdated() && !change.wasReplaced()) continue;
                if (((ObservableList)this.sublistsProperty.get()).size() == 1) {
                    this.getSelectionModel().selectedItemProperty().addListener((observableValue, object, object2) -> this.clearSelection(this));
                    this.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, Event::consume);
                }
                change.getAddedSubList().forEach(jFXListView -> jFXListView.getSelectionModel().selectedItemProperty().addListener((observableValue, object, object2) -> this.clearSelection((JFXListView<?>)((Object)((Object)jFXListView)))));
            }
        });
        this.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, number2) -> {
            if (number2.intValue() != -1) {
                this.updateOverAllSelectedIndex();
            }
        });
    }

    private void clearSelection(JFXListView<?> jFXListView) {
        if (this.allowClear) {
            this.allowClear = false;
            if (this != jFXListView) {
                this.getSelectionModel().clearSelection();
            }
            for (int i2 = 0; i2 < ((ObservableList)this.sublistsProperty.get()).size(); ++i2) {
                if (((ObservableList)this.sublistsProperty.get()).get(i2) == jFXListView) continue;
                ((JFXListView)((Object)((ObservableList)this.sublistsProperty.get()).get(i2))).getSelectionModel().clearSelection();
            }
            this.allowClear = true;
        }
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, mouseEvent -> {
            mouseEvent.consume();
            this.getParent().fireEvent(mouseEvent);
        });
    }

    public Double getVerticalGap() {
        return this.verticalGap == null ? 0.0 : this.verticalGap.get();
    }

    public StyleableDoubleProperty verticalGapProperty() {
        return this.verticalGap;
    }

    public void setVerticalGap(Double d2) {
        this.verticalGap.set(d2.doubleValue());
    }

    public Boolean isExpanded() {
        return this.expanded != null && this.expanded.get();
    }

    public StyleableBooleanProperty expandedProperty() {
        return this.expanded;
    }

    public void setExpanded(Boolean bl2) {
        this.expanded.set(bl2.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXListView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXListView<?>, Number> VERTICAL_GAP = new CssMetaData<JFXListView<?>, Number>("-jfx-vertical-gap", SizeConverter.getInstance(), 0){

            public boolean isSettable(JFXListView<?> jFXListView) {
                return ((JFXListView)jFXListView).verticalGap == null || !((JFXListView)jFXListView).verticalGap.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXListView<?> jFXListView) {
                return jFXListView.verticalGapProperty();
            }
        };
        private static final CssMetaData<JFXListView<?>, Boolean> EXPANDED = new CssMetaData<JFXListView<?>, Boolean>("-jfx-expanded", BooleanConverter.getInstance(), false){

            public boolean isSettable(JFXListView<?> jFXListView) {
                return jFXListView.getHeight() == 0.0 && (((JFXListView)jFXListView).expanded == null || !((JFXListView)jFXListView).expanded.isBound());
            }

            public StyleableBooleanProperty getStyleableProperty(JFXListView<?> jFXListView) {
                return jFXListView.expandedProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return VERTICAL_GAP;
        }

        static /* synthetic */ CssMetaData access$100() {
            return EXPANDED;
        }

        static {
            ArrayList arrayList = new ArrayList(ListView.getClassCssMetaData());
            Collections.addAll(arrayList, VERTICAL_GAP, EXPANDED);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

