/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.cache;

import com.jfoenix.transitions.CacheMemento;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public interface CachePolicy<T extends Node> {
    public static final CachePolicy<Node> CACHE = new CachePolicy<Node>(){
        private WeakHashMap<Node, CacheMemento> cache = new WeakHashMap();

        @Override
        public void cache(Node node) {
            if (!this.cache.containsKey(node)) {
                CacheMemento cacheMemento = new CacheMemento(node);
                this.cache.put(node, cacheMemento);
                cacheMemento.cache();
            }
        }

        @Override
        public void restore(Node node) {
            CacheMemento cacheMemento = this.cache.remove(node);
            if (cacheMemento != null) {
                cacheMemento.restore();
            }
        }
    };
    public static final CachePolicy<Node> NONE = new CachePolicy<Node>(){

        @Override
        public void cache(Node node) {
        }

        @Override
        public void restore(Node node) {
        }
    };
    public static final CachePolicy<Pane> IMAGE = new CachePolicy<Pane>(){
        private WeakHashMap<Node, ArrayList<Node>> cache = new WeakHashMap();

        @Override
        public void cache(Pane pane) {
            if (!this.cache.containsKey(pane)) {
                SnapshotParameters snapshotParameters = new SnapshotParameters();
                snapshotParameters.setFill((Paint)Color.TRANSPARENT);
                WritableImage writableImage = pane.snapshot(snapshotParameters, new WritableImage((int)pane.getLayoutBounds().getWidth(), (int)pane.getLayoutBounds().getHeight()));
                ImageView imageView = new ImageView((Image)writableImage);
                imageView.setCache(true);
                imageView.setCacheHint(CacheHint.SPEED);
                this.cache.put((Node)pane, new ArrayList(pane.getChildren()));
                pane.getChildren().setAll((Object[])new Node[]{imageView});
            }
        }

        @Override
        public void restore(Pane pane) {
            ArrayList<Node> arrayList = this.cache.remove(pane);
            if (arrayList != null) {
                pane.getChildren().setAll(arrayList);
            }
        }
    };

    public void cache(T var1);

    public void restore(T var1);
}

