/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.filter;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.filter.TokenFilter;

public class JsonPointerBasedFilter
extends TokenFilter {
    protected final JsonPointer _pathToMatch;
    protected final boolean _includeAllElements;

    public JsonPointerBasedFilter(String string) {
        this(JsonPointer.compile(string), false);
    }

    public JsonPointerBasedFilter(JsonPointer jsonPointer) {
        this(jsonPointer, false);
    }

    public JsonPointerBasedFilter(JsonPointer jsonPointer, boolean bl2) {
        this._pathToMatch = jsonPointer;
        this._includeAllElements = bl2;
    }

    protected JsonPointerBasedFilter construct(JsonPointer jsonPointer, boolean bl2) {
        return new JsonPointerBasedFilter(jsonPointer, bl2);
    }

    @Override
    public TokenFilter includeElement(int n2) {
        JsonPointer jsonPointer = this._includeAllElements && !this._pathToMatch.mayMatchElement() ? this._pathToMatch.tail() : this._pathToMatch.matchElement(n2);
        if (jsonPointer == null) {
            return null;
        }
        if (jsonPointer.matches()) {
            return TokenFilter.INCLUDE_ALL;
        }
        return this.construct(jsonPointer, this._includeAllElements);
    }

    @Override
    public TokenFilter includeProperty(String string) {
        JsonPointer jsonPointer = this._pathToMatch.matchProperty(string);
        if (jsonPointer == null) {
            return null;
        }
        if (jsonPointer.matches()) {
            return TokenFilter.INCLUDE_ALL;
        }
        return this.construct(jsonPointer, this._includeAllElements);
    }

    @Override
    public TokenFilter filterStartArray() {
        return this;
    }

    @Override
    public TokenFilter filterStartObject() {
        return this;
    }

    @Override
    protected boolean _includeScalar() {
        return this._pathToMatch.matches();
    }

    @Override
    public String toString() {
        return "[JsonPointerFilter at: " + this._pathToMatch + "]";
    }
}

