/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import java.io.Serializable;

public class ErrorReportConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_ERROR_TOKEN_LENGTH = 256;
    public static final int DEFAULT_MAX_RAW_CONTENT_LENGTH = 500;
    protected final int _maxErrorTokenLength;
    protected final int _maxRawContentLength;
    private static ErrorReportConfiguration DEFAULT = new ErrorReportConfiguration(256, 500);

    public static void overrideDefaultErrorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        DEFAULT = errorReportConfiguration == null ? new ErrorReportConfiguration(256, 500) : errorReportConfiguration;
    }

    protected ErrorReportConfiguration(int n2, int n3) {
        this._maxErrorTokenLength = n2;
        this._maxRawContentLength = n3;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ErrorReportConfiguration defaults() {
        return DEFAULT;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public int getMaxErrorTokenLength() {
        return this._maxErrorTokenLength;
    }

    public int getMaxRawContentLength() {
        return this._maxRawContentLength;
    }

    static void validateMaxErrorTokenLength(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("Value of maxErrorTokenLength (%d) cannot be negative", n2));
        }
    }

    static void validateMaxRawContentLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("Value of maxRawContentLength (%d) cannot be negative", n2));
        }
    }

    public static final class Builder {
        private int maxErrorTokenLength;
        private int maxRawContentLength;

        public Builder maxErrorTokenLength(int n2) {
            ErrorReportConfiguration.validateMaxErrorTokenLength(n2);
            this.maxErrorTokenLength = n2;
            return this;
        }

        public Builder maxRawContentLength(int n2) {
            ErrorReportConfiguration.validateMaxRawContentLength(n2);
            this.maxRawContentLength = n2;
            return this;
        }

        Builder() {
            this(256, 500);
        }

        Builder(int n2, int n3) {
            this.maxErrorTokenLength = n2;
            this.maxRawContentLength = n3;
        }

        Builder(ErrorReportConfiguration errorReportConfiguration) {
            this.maxErrorTokenLength = errorReportConfiguration._maxErrorTokenLength;
            this.maxRawContentLength = errorReportConfiguration._maxRawContentLength;
        }

        public ErrorReportConfiguration build() {
            return new ErrorReportConfiguration(this.maxErrorTokenLength, this.maxRawContentLength);
        }
    }
}

