/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BehaviorSkinBase;
import atlantafx.base.controls.Calendar;
import atlantafx.base.controls.CalendarBehavior;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.DateCell;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class CalendarSkin
extends BehaviorSkinBase<Calendar, CalendarBehavior> {
    final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("y");
    final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM");
    final DateTimeFormatter weekNumberFormatter = DateTimeFormatter.ofPattern("w");
    final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
    final DateTimeFormatter monthFormatterSO = DateTimeFormatter.ofPattern("LLLL");
    final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("ccc");
    protected final VBox rootPane = new VBox();
    protected CalendarGrid calendarGrid;
    protected Button forwardButton;
    protected Button backButton;
    protected Label monthLabel;
    protected Label yearLabel;
    protected final List<DateCell> dayNameCells = new ArrayList<DateCell>();
    protected final List<DateCell> weekNumberCells = new ArrayList<DateCell>();
    protected final List<DateCell> dayCells = new ArrayList<DateCell>();
    protected LocalDate[] dayCellDates;
    protected DateCell lastFocusedDayCell = null;
    protected final int daysPerWeek = this.getDaysPerWeek();
    private final ObjectProperty<YearMonth> displayedYearMonth = new SimpleObjectProperty((Object)this, "displayedYearMonth");
    private final ObjectBinding<LocalDate> firstDayOfMonth = Bindings.createObjectBinding(() -> ((YearMonth)this.displayedYearMonth.get()).atDay(1), (Observable[])new Observable[]{this.displayedYearMonth});

    public ObjectProperty<YearMonth> displayedYearMonthProperty() {
        return this.displayedYearMonth;
    }

    public LocalDate getFirstDayOfMonth() {
        return (LocalDate)this.firstDayOfMonth.get();
    }

    public CalendarSkin(Calendar calendar) {
        super(calendar);
        this.createUI();
        this.registerChangeListener((ObservableValue)calendar.valueProperty(), observableValue -> {
            LocalDate localDate = calendar.getValue();
            this.displayedYearMonthProperty().set((Object)(localDate != null ? YearMonth.from(localDate) : YearMonth.now(ZoneId.systemDefault())));
            this.updateValues();
            calendar.fireEvent((Event)new ActionEvent());
        });
        this.registerChangeListener((ObservableValue)calendar.showWeekNumbersProperty(), observableValue -> {
            this.updateGrid();
            this.updateWeekNumberCells();
        });
        this.registerChangeListener((ObservableValue)calendar.topNodeProperty(), observableValue -> {
            Node node2 = calendar.getTopNode();
            if (node2 == null) {
                this.rootPane.getChildren().removeIf(node -> node.getStyleClass().contains((Object)"top-node"));
            } else {
                if (!node2.getStyleClass().contains((Object)"top-node")) {
                    node2.getStyleClass().add((Object)"top-node");
                }
                this.rootPane.getChildren().add(0, (Object)node2);
            }
        });
        this.registerChangeListener((ObservableValue)calendar.bottomNodeProperty(), observableValue -> {
            Node node2 = calendar.getBottomNode();
            if (node2 == null) {
                this.rootPane.getChildren().removeIf(node -> node.getStyleClass().contains((Object)"bottom-node"));
            } else {
                if (!node2.getStyleClass().contains((Object)"bottom-node")) {
                    node2.getStyleClass().add((Object)"bottom-node");
                }
                this.rootPane.getChildren().add((Object)node2);
            }
        });
    }

    @Override
    public CalendarBehavior createDefaultBehavior() {
        return new CalendarBehavior((Calendar)((Object)this.getControl()), this);
    }

    public Locale getLocale() {
        return Locale.getDefault(Locale.Category.FORMAT);
    }

    public Scene getScene() {
        return ((Calendar)((Object)this.getControl())).getScene();
    }

    public Chronology getPrimaryChronology() {
        return ((Calendar)((Object)this.getControl())).getChronology();
    }

    public int getMonthsPerYear() {
        ValueRange valueRange = this.getPrimaryChronology().range(ChronoField.MONTH_OF_YEAR);
        return (int)(valueRange.getMaximum() - valueRange.getMinimum() + 1L);
    }

    public int getDaysPerWeek() {
        ValueRange valueRange = this.getPrimaryChronology().range(ChronoField.DAY_OF_WEEK);
        return (int)(valueRange.getMaximum() - valueRange.getMinimum() + 1L);
    }

    protected void createUI() {
        DateCell dateCell;
        int n2;
        LocalDate localDate;
        if (((Calendar)((Object)this.getControl())).getTopNode() != null) {
            ((Calendar)((Object)this.getControl())).getTopNode().getStyleClass().add((Object)"top-node");
            this.rootPane.getChildren().add((Object)((Calendar)((Object)this.getControl())).getTopNode());
        }
        this.displayedYearMonth.set((Object)((localDate = ((Calendar)((Object)this.getControl())).getValue()) != null ? YearMonth.from(localDate) : YearMonth.now(ZoneId.systemDefault())));
        this.displayedYearMonth.addListener((observableValue, yearMonth, yearMonth2) -> this.updateValues());
        this.rootPane.getChildren().add((Object)this.createMonthYearPane());
        this.calendarGrid = new CalendarGrid();
        this.calendarGrid.getStyleClass().add((Object)"calendar-grid");
        this.calendarGrid.setFocusTraversable(true);
        this.calendarGrid.setVgap(-1.0);
        this.calendarGrid.setHgap(-1.0);
        for (n2 = 0; n2 < this.daysPerWeek; ++n2) {
            dateCell = new DateCell();
            dateCell.getStyleClass().add((Object)"day-name-cell");
            this.dayNameCells.add(dateCell);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            dateCell = new DateCell();
            dateCell.getStyleClass().add((Object)"week-number-cell");
            this.weekNumberCells.add(dateCell);
        }
        this.createDayCells();
        this.updateGrid();
        this.rootPane.getStyleClass().addAll((Object[])new String[]{"date-picker-popup", "calendar"});
        this.rootPane.getChildren().add((Object)this.calendarGrid);
        if (((Calendar)((Object)this.getControl())).getBottomNode() != null) {
            ((Calendar)((Object)this.getControl())).getBottomNode().getStyleClass().add((Object)"bottom-node");
            this.rootPane.getChildren().add((Object)((Calendar)((Object)this.getControl())).getBottomNode());
        }
        this.getChildren().add((Object)this.rootPane);
        ((Calendar)((Object)this.getControl())).setOnKeyPressed(keyEvent -> ((CalendarBehavior)this.behavior).onKeyPressed((KeyEvent)keyEvent));
        this.refresh();
    }

    protected HBox createMonthYearPane() {
        HBox hBox = new HBox();
        hBox.getStyleClass().add((Object)"month-year-pane");
        this.backButton = new Button();
        this.backButton.getStyleClass().addAll((Object[])new String[]{"back-button"});
        this.backButton.setOnMouseClicked(((CalendarBehavior)this.behavior)::moveBackward);
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().add((Object)"left-arrow");
        stackPane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backButton.setGraphic((Node)stackPane);
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        this.monthLabel = new Label();
        this.monthLabel.getStyleClass().add((Object)"month-label");
        this.yearLabel = new Label();
        this.yearLabel.getStyleClass().add((Object)"year-label");
        this.forwardButton = new Button();
        this.forwardButton.getStyleClass().addAll((Object[])new String[]{"forward-button"});
        this.forwardButton.setOnMouseClicked(((CalendarBehavior)this.behavior)::moveForward);
        StackPane stackPane2 = new StackPane();
        stackPane2.getStyleClass().add((Object)"right-arrow");
        stackPane2.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardButton.setGraphic((Node)stackPane2);
        hBox.getChildren().addAll((Object[])new Node[]{this.monthLabel, this.yearLabel, region, this.backButton, this.forwardButton});
        return hBox;
    }

    public void refresh() {
        this.updateDayNameCells();
        this.updateValues();
    }

    public void updateValues() {
        this.updateWeekNumberCells();
        this.updateDayCells();
        this.updateMonthYearPane();
    }

    public void updateGrid() {
        int n2;
        this.calendarGrid.getColumnConstraints().clear();
        this.calendarGrid.getChildren().clear();
        int n3 = this.daysPerWeek + (((Calendar)((Object)this.getControl())).isShowWeekNumbers() ? 1 : 0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        for (n2 = 0; n2 < n3; ++n2) {
            this.calendarGrid.getColumnConstraints().add((Object)columnConstraints);
        }
        for (n2 = 0; n2 < this.daysPerWeek; ++n2) {
            this.calendarGrid.add((Node)this.dayNameCells.get(n2), n2 + n3 - this.daysPerWeek, 1);
        }
        if (((Calendar)((Object)this.getControl())).isShowWeekNumbers()) {
            for (n2 = 0; n2 < 6; ++n2) {
                this.calendarGrid.add((Node)this.weekNumberCells.get(n2), 0, n2 + 2);
            }
        }
        for (n2 = 0; n2 < 6; ++n2) {
            for (int i2 = 0; i2 < this.daysPerWeek; ++i2) {
                this.calendarGrid.add((Node)this.dayCells.get(n2 * this.daysPerWeek + i2), i2 + n3 - this.daysPerWeek, n2 + 2);
            }
        }
    }

    public void updateDayNameCells() {
        int n2 = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        LocalDate localDate = LocalDate.of(2009, 7, 12 + n2);
        for (int i2 = 0; i2 < this.daysPerWeek; ++i2) {
            String string = this.weekDayNameFormatter.withLocale(this.getLocale()).format(localDate.plus(i2, ChronoUnit.DAYS));
            this.dayNameCells.get(i2).setText(CalendarSkin.capitalize(string));
        }
    }

    public void updateWeekNumberCells() {
        if (((Calendar)((Object)this.getControl())).isShowWeekNumbers()) {
            Locale locale = this.getLocale();
            int n2 = 6;
            LocalDate localDate = ((YearMonth)this.displayedYearMonth.get()).atDay(1);
            for (int i2 = 0; i2 < 6; ++i2) {
                LocalDate localDate2 = localDate.plus(i2, ChronoUnit.WEEKS);
                String string = this.weekNumberFormatter.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).format(localDate2);
                this.weekNumberCells.get(i2).setText(string);
            }
        }
    }

    public void updateDayCells() {
        Locale locale = this.getLocale();
        Chronology chronology = this.getPrimaryChronology();
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        int n2 = this.determineFirstOfMonthDayOfWeek();
        YearMonth yearMonth2 = null;
        YearMonth yearMonth3 = null;
        int n3 = -1;
        int n4 = -1;
        for (int i2 = 0; i2 < 6 * this.daysPerWeek; ++i2) {
            DateCell dateCell = this.dayCells.get(i2);
            dateCell.getStyleClass().setAll((Object[])new String[]{"cell", "date-cell", "day-cell"});
            dateCell.setDisable(false);
            dateCell.setStyle(null);
            dateCell.setGraphic(null);
            dateCell.setTooltip(null);
            try {
                LocalDate localDate;
                n3 = n3 == -1 ? yearMonth.lengthOfMonth() : n3;
                YearMonth yearMonth4 = yearMonth;
                int n5 = i2 - n2 + 1;
                if (i2 < n2) {
                    if (yearMonth2 == null) {
                        yearMonth2 = yearMonth.minusMonths(1L);
                        n4 = yearMonth2.lengthOfMonth();
                    }
                    yearMonth4 = yearMonth2;
                    n5 = i2 + n4 - n2 + 1;
                    dateCell.getStyleClass().add((Object)"previous-month");
                } else if (i2 >= n2 + n3) {
                    if (yearMonth3 == null) {
                        yearMonth3 = yearMonth.plusMonths(1L);
                    }
                    yearMonth4 = yearMonth3;
                    n5 = i2 - n3 - n2 + 1;
                    dateCell.getStyleClass().add((Object)"next-month");
                }
                this.dayCellDates[i2] = localDate = yearMonth4.atDay(n5);
                ChronoLocalDate chronoLocalDate = chronology.date(localDate);
                dateCell.setDisable(false);
                if (CalendarSkin.isToday(localDate)) {
                    dateCell.getStyleClass().add((Object)"today");
                }
                if (localDate.equals(((Calendar)((Object)this.getControl())).getValue())) {
                    dateCell.getStyleClass().add((Object)"selected");
                }
                String string = this.dayCellFormatter.withLocale(locale).withChronology(chronology).withDecimalStyle(DecimalStyle.of(locale)).format(chronoLocalDate);
                dateCell.setText(string);
                dateCell.updateItem(localDate, false);
                continue;
            }
            catch (DateTimeException dateTimeException) {
                dateCell.setText(" ");
                dateCell.setDisable(true);
            }
        }
    }

    private int determineFirstOfMonthDayOfWeek() {
        int n2 = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        int n3 = ((YearMonth)this.displayedYearMonth.get()).atDay(1).getDayOfWeek().getValue() - n2;
        return n3 < 0 ? n3 + this.daysPerWeek : n3;
    }

    public void updateMonthYearPane() {
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        this.monthLabel.setText(this.formatMonth(yearMonth));
        this.yearLabel.setText(this.formatYear(yearMonth));
        this.backButton.setDisable(!this.canGoMonthBack());
        this.forwardButton.setDisable(!this.canGoMonthForward());
    }

    protected String formatMonth(YearMonth yearMonth) {
        Chronology chronology = this.getPrimaryChronology();
        try {
            ChronoLocalDate chronoLocalDate = chronology.date(yearMonth.atDay(1));
            String string = this.monthFormatterSO.withLocale(this.getLocale()).withChronology(chronology).format(chronoLocalDate);
            if (Character.isDigit(string.charAt(0))) {
                string = this.monthFormatter.withLocale(this.getLocale()).withChronology(chronology).format(chronoLocalDate);
            }
            return CalendarSkin.capitalize(string);
        }
        catch (DateTimeException dateTimeException) {
            return "";
        }
    }

    protected String formatYear(YearMonth yearMonth) {
        Chronology chronology = this.getPrimaryChronology();
        try {
            ChronoLocalDate chronoLocalDate = chronology.date(yearMonth.atDay(1));
            return this.yearFormatter.withLocale(this.getLocale()).withChronology(chronology).withDecimalStyle(DecimalStyle.of(this.getLocale())).format(chronoLocalDate);
        }
        catch (DateTimeException dateTimeException) {
            return "";
        }
    }

    public void forward(int n2, ChronoUnit chronoUnit, boolean bl2) {
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        DateCell dateCell = this.lastFocusedDayCell;
        if (dateCell == null || !this.getDayCellDate(dateCell).getMonth().equals(yearMonth.getMonth())) {
            dateCell = this.findDayCellForDate(yearMonth.atDay(1));
        }
        this.goToDayCell(dateCell, n2, chronoUnit, bl2);
    }

    public void goToDayCell(DateCell dateCell, int n2, ChronoUnit chronoUnit, boolean bl2) {
        this.goToDate(this.getDayCellDate(dateCell).plus(n2, chronoUnit), bl2);
    }

    public void goToDate(LocalDate localDate, boolean bl2) {
        if (Calendar.isValidDate(this.getPrimaryChronology(), localDate)) {
            this.displayedYearMonth.set((Object)YearMonth.from(localDate));
            if (bl2) {
                this.findDayCellForDate(localDate).requestFocus();
            }
        }
    }

    private DateCell findDayCellForDate(LocalDate localDate) {
        for (int i2 = 0; i2 < this.dayCellDates.length; ++i2) {
            if (!localDate.equals(this.dayCellDates[i2])) continue;
            return this.dayCells.get(i2);
        }
        return this.dayCells.get(this.dayCells.size() / 2 + 1);
    }

    public void selectDayCell(DateCell dateCell) {
        ((Calendar)((Object)this.getControl())).setValue(this.getDayCellDate(dateCell));
    }

    private LocalDate getDayCellDate(DateCell dateCell) {
        return this.dayCellDates[this.dayCells.indexOf(dateCell)];
    }

    protected void createDayCells() {
        EventHandler eventHandler = mouseEvent -> {
            if (mouseEvent.getButton() != MouseButton.PRIMARY) {
                return;
            }
            DateCell dateCell = (DateCell)mouseEvent.getSource();
            this.selectDayCell(dateCell);
            this.lastFocusedDayCell = dateCell;
        };
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int i3 = 0; i3 < this.daysPerWeek; ++i3) {
                DateCell dateCell = this.createDayCell();
                dateCell.addEventHandler(MouseEvent.MOUSE_CLICKED, eventHandler);
                this.dayCells.add(dateCell);
            }
        }
        this.dayCellDates = new LocalDate[6 * this.daysPerWeek];
    }

    protected DateCell createDayCell() {
        Callback<Calendar, DateCell> callback = ((Calendar)((Object)this.getControl())).getDayCellFactory();
        return Objects.requireNonNullElseGet(callback != null ? (DateCell)callback.call((Object)((Calendar)((Object)this.getControl()))) : null, DateCell::new);
    }

    public void rememberFocusedDayCell() {
        Node node = ((Calendar)((Object)this.getControl())).getScene().getFocusOwner();
        if (node instanceof DateCell) {
            DateCell dateCell;
            this.lastFocusedDayCell = dateCell = (DateCell)node;
        }
    }

    public boolean canGoMonthBack() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), -1, ChronoUnit.DAYS);
    }

    public boolean canGoMonthForward() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), 1, ChronoUnit.MONTHS);
    }

    public boolean canGoYearBack() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), -1, ChronoUnit.YEARS);
    }

    public boolean canGoYearForward() {
        return Calendar.isValidDate(this.getPrimaryChronology(), this.getFirstDayOfMonth(), 1, ChronoUnit.YEARS);
    }

    public void clearFocus() {
        LocalDate localDate = Objects.requireNonNullElseGet(((Calendar)((Object)this.getControl())).getValue(), LocalDate::now);
        if (YearMonth.from(localDate).equals(this.displayedYearMonth.get())) {
            this.goToDate(localDate, true);
        } else {
            this.backButton.requestFocus();
        }
    }

    private static String capitalize(String object) {
        int n2;
        if (((String)object).length() > 0 && !Character.isTitleCase(n2 = ((String)object).codePointAt(0))) {
            object = new String(new int[]{Character.toTitleCase(n2)}, 0, 1) + ((String)object).substring(Character.offsetByCodePoints((CharSequence)object, 0, 1));
        }
        return object;
    }

    private static boolean isToday(LocalDate localDate) {
        return localDate != null && localDate.equals(CalendarSkin.today());
    }

    private static LocalDate today() {
        return LocalDate.now(ZoneId.systemDefault());
    }

    protected class CalendarGrid
    extends GridPane {
        protected CalendarGrid() {
        }

        protected double computePrefWidth(double d2) {
            double d3 = super.computePrefWidth(d2);
            int n2 = CalendarSkin.this.daysPerWeek + (((Calendar)((Object)CalendarSkin.this.getControl())).isShowWeekNumbers() ? 1 : 0);
            double d4 = this.snapSpaceX(this.getHgap());
            double d5 = d4 * (double)(n2 - 1);
            double d6 = this.snapSpaceX(this.getInsets().getLeft());
            double d7 = this.snapSpaceX(this.getInsets().getRight());
            double d8 = d3 - d6 - d7 - d5;
            return this.snapSizeX(d8 / (double)n2) * (double)n2 + d6 + d7 + d5;
        }

        protected void layoutChildren() {
            if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                super.layoutChildren();
            }
        }
    }
}

