/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.PngjOutputException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CompressorStream
extends FilterOutputStream {
    protected OutputStream os;
    public final int blockLen;
    public final long totalbytes;
    boolean closed = false;
    protected boolean done = false;
    protected long bytesIn = 0L;
    protected long bytesOut = 0L;
    protected int block = -1;
    private byte[] firstBytes;
    protected boolean storeFirstByte = false;

    public CompressorStream(OutputStream outputStream, int n2, long l2) {
        super(outputStream);
        if (n2 < 0) {
            n2 = 4096;
        }
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        if (n2 < 1 || l2 < 1L) {
            throw new RuntimeException(" maxBlockLen or totalLen invalid");
        }
        this.os = outputStream;
        this.blockLen = n2;
        this.totalbytes = l2;
    }

    public void close() {
        this.done();
        this.closed = true;
    }

    public abstract void done();

    public final void write(byte[] byArray, int n2, int n3) {
        ++this.block;
        if (n3 <= this.blockLen) {
            this.mywrite(byArray, n2, n3);
            if (this.storeFirstByte && this.block < this.firstBytes.length) {
                this.firstBytes[this.block] = byArray[n2];
            }
        } else {
            while (n3 > 0) {
                this.mywrite(byArray, n2, this.blockLen);
                n2 += this.blockLen;
                n3 -= this.blockLen;
            }
        }
        if (this.bytesIn >= this.totalbytes) {
            this.done();
        }
    }

    protected abstract void mywrite(byte[] var1, int var2, int var3);

    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n2) throws IOException {
        throw new PngjOutputException("should not be used");
    }

    public void reset() {
        this.reset(this.os);
    }

    public void reset(OutputStream outputStream) {
        if (this.closed) {
            throw new PngjOutputException("cannot reset, discarded object");
        }
        this.done();
        this.bytesIn = 0L;
        this.bytesOut = 0L;
        this.block = -1;
        this.done = false;
        this.os = outputStream;
    }

    public final double getCompressionRatio() {
        return this.bytesOut == 0L ? 1.0 : (double)this.bytesOut / (double)this.bytesIn;
    }

    public final long getBytesRaw() {
        return this.bytesIn;
    }

    public final long getBytesCompressed() {
        return this.bytesOut;
    }

    public OutputStream getOs() {
        return this.os;
    }

    public void flush() {
        if (this.os != null) {
            try {
                this.os.flush();
            }
            catch (IOException iOException) {
                throw new PngjOutputException(iOException);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDone() {
        return this.done;
    }

    public byte[] getFirstBytes() {
        return this.firstBytes;
    }

    public void setStoreFirstByte(boolean bl2, int n2) {
        this.storeFirstByte = bl2;
        if (this.storeFirstByte) {
            if (this.firstBytes == null || this.firstBytes.length < n2) {
                this.firstBytes = new byte[n2];
            }
        } else {
            this.firstBytes = null;
        }
    }
}

