/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;
import java.io.ByteArrayInputStream;

public class PngChunkIHDR
extends PngChunkSingle {
    public static final String ID = "IHDR";
    private int cols;
    private int rows;
    private int bitspc;
    private int colormodel;
    private int compmeth;
    private int filmeth;
    private int interlaced;

    public PngChunkIHDR(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = new ChunkRaw(13, ChunkHelper.b_IHDR, true);
        int n2 = 0;
        PngHelperInternal.writeInt4tobytes(this.cols, chunkRaw.data, n2);
        PngHelperInternal.writeInt4tobytes(this.rows, chunkRaw.data, n2 += 4);
        n2 += 4;
        chunkRaw.data[n2++] = (byte)this.bitspc;
        chunkRaw.data[n2++] = (byte)this.colormodel;
        chunkRaw.data[n2++] = (byte)this.compmeth;
        chunkRaw.data[n2++] = (byte)this.filmeth;
        chunkRaw.data[n2++] = (byte)this.interlaced;
        return chunkRaw;
    }

    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 13) {
            throw new PngjException("Bad IDHR len " + chunkRaw.len);
        }
        ByteArrayInputStream byteArrayInputStream = chunkRaw.getAsByteStream();
        this.cols = PngHelperInternal.readInt4(byteArrayInputStream);
        this.rows = PngHelperInternal.readInt4(byteArrayInputStream);
        this.bitspc = PngHelperInternal.readByte(byteArrayInputStream);
        this.colormodel = PngHelperInternal.readByte(byteArrayInputStream);
        this.compmeth = PngHelperInternal.readByte(byteArrayInputStream);
        this.filmeth = PngHelperInternal.readByte(byteArrayInputStream);
        this.interlaced = PngHelperInternal.readByte(byteArrayInputStream);
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int n2) {
        this.cols = n2;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n2) {
        this.rows = n2;
    }

    public int getBitspc() {
        return this.bitspc;
    }

    public void setBitspc(int n2) {
        this.bitspc = n2;
    }

    public int getColormodel() {
        return this.colormodel;
    }

    public void setColormodel(int n2) {
        this.colormodel = n2;
    }

    public int getCompmeth() {
        return this.compmeth;
    }

    public void setCompmeth(int n2) {
        this.compmeth = n2;
    }

    public int getFilmeth() {
        return this.filmeth;
    }

    public void setFilmeth(int n2) {
        this.filmeth = n2;
    }

    public int getInterlaced() {
        return this.interlaced;
    }

    public void setInterlaced(int n2) {
        this.interlaced = n2;
    }

    public boolean isInterlaced() {
        return this.getInterlaced() == 1;
    }

    public ImageInfo createImageInfo() {
        this.check();
        boolean bl2 = (this.getColormodel() & 4) != 0;
        boolean bl3 = (this.getColormodel() & 1) != 0;
        boolean bl4 = this.getColormodel() == 0 || this.getColormodel() == 4;
        return new ImageInfo(this.getCols(), this.getRows(), this.getBitspc(), bl2, bl4, bl3);
    }

    public void check() {
        if (this.cols < 1 || this.rows < 1 || this.compmeth != 0 || this.filmeth != 0) {
            throw new PngjInputException("bad IHDR: col/row/compmethod/filmethod invalid");
        }
        if (this.bitspc != 1 && this.bitspc != 2 && this.bitspc != 4 && this.bitspc != 8 && this.bitspc != 16) {
            throw new PngjInputException("bad IHDR: bitdepth invalid");
        }
        if (this.interlaced < 0 || this.interlaced > 1) {
            throw new PngjInputException("bad IHDR: interlace invalid");
        }
        switch (this.colormodel) {
            case 0: {
                break;
            }
            case 3: {
                if (this.bitspc != 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            case 2: 
            case 4: 
            case 6: {
                if (this.bitspc == 8 || this.bitspc == 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            default: {
                throw new PngjInputException("bad IHDR: invalid colormodel");
            }
        }
    }
}

